package com.cku.restful.v1.dog.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.sys.dao.AssociationDao;
import com.cku.oa.sys.dao.OrgDao;
import com.cku.oa.sys.entity.Association;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.restful.v1.dog.model.RestDogPedigreeCertifiedChange;
import com.cku.restful.v1.dog.vo.ChangeOrgReqVo;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 证书换发Service
 *
 * @author lgl
 * @version 2016-08-11
 */
@Service
@Transactional(readOnly = true)
public class RestDogPedigreeCertifiedChangeService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_pedigree_certified_change@All";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_pedigree_certified_change@Zangao";

	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private OrgDao orgDao;
	@Autowired
	private DogColorMarkDao dogColorMarkDao;
	@Autowired
	private AssociationDao associationDao;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	private OrgDogTypeLimitService orgDogTypeLimitService;
	    @Autowired
    public PaymentOrderService paymentOrderService;
	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		DogPedigreeCertifiedChange dogPedigreeCertifiedChange = dogPedigreeCertifiedChangeService.get(id);
		if (dogPedigreeCertifiedChange == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if(!dogPedigreeCertifiedChange.getPaymentMemberCode().equals(member.getMemberCode())){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogPedigreeCertifiedChange vo = new RestDogPedigreeCertifiedChange();
		BeanUtil.copyProperties(vo, dogPedigreeCertifiedChange, "yyyy-MM-dd");
		vo.setDogGender(DictUtils.getDictLabel(dogPedigreeCertifiedChange.getDogGender(),"dog_gender",""));
		Association association = associationDao.getByCode(dogPedigreeCertifiedChange.getAssociation());
		if(association!=null){
			vo.setAssociation(association.getName());
		}
		DogType dogType = dogTypeService.getByDogBreedCode(dogPedigreeCertifiedChange.getDogBreed());
		String breedCnName = "";
		if(dogType==null){
			breedCnName = dogTypeService.getUnMapBreedCnName(dogPedigreeCertifiedChange.getDogBreed());
		}else{
			breedCnName = dogType.getBreedCnName();
		}
		vo.setBreedCnName(breedCnName);
		if(StringUtils.isNotBlank(dogPedigreeCertifiedChange.getDogFurColor())){
			DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogPedigreeCertifiedChange.getDogFurColor());
			if(dogColorMark!=null){
				vo.setDogFurColor(dogColorMark.getDogColorMarkCn());
			}
		}
		vo.setBusinessState(dogPedigreeCertifiedChangeService.getBusinessState(dogPedigreeCertifiedChange));
		
		// 是否可以修改办理机构
		vo.setChangeOrgFlag(!dogPedigreeCertifiedChange.getDogChipCheck().equals("1")
				&& StringUtils.isEmpty(dogPedigreeCertifiedChange.getDogDnaArchiveId()));
		return new RESTResponse("data", vo);
    }
    
    private void validateRefundState(DogPedigreeCertifiedChange po,RestDogPedigreeCertifiedChange vo) {
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(po.getId(),po.getRunningNumber());
		if(vo == null){
			if(!canCanceled) throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		}else {
			vo.setCanEdit(canCanceled);
		}
	}
    
    /**
     * 申请退款数据
     *
     * @param ids
     * @return
     */
    public RESTResponse getRefundList(String ids) {
        DogPedigreeCertifiedChange example = new DogPedigreeCertifiedChange();
        example.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
        example.setId(ids);
        List<DogPedigreeCertifiedChange> dogPedigreeCertifiedChangeList = dogPedigreeCertifiedChangeService.findList(example);
        List<RestDogPedigreeCertifiedChange> list = new ArrayList<RestDogPedigreeCertifiedChange>();
        for (DogPedigreeCertifiedChange dogPedigreeCertifiedChange : dogPedigreeCertifiedChangeList) {
            RestDogPedigreeCertifiedChange vo = new RestDogPedigreeCertifiedChange();
            BeanUtil.copyProperties(vo, dogPedigreeCertifiedChange, "yyyy-MM-dd");
            vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(), "dog_gender", ""));
            vo.setReviewStateCode(vo.getReviewState());
            vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
            if ("1".equals(vo.getReviewState()))
                vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(), "proccess_state", ""));
            else {
                if ("0".equals(dogPedigreeCertifiedChange.getDelFlag()))
                    vo.setProcessState("撤销");
                else
                    vo.setProcessState("已撤销");
            }
            DogType dogType = dogTypeService.getByDogBreedCode(vo.getDogBreed());
            String breedCnName = "";
            if (dogType == null) {
                breedCnName = dogTypeService.getUnMapBreedCnName(vo.getDogBreed());
            } else {
                breedCnName = dogType.getBreedCnName();
            }
            vo.setBreedCnName(breedCnName);
            vo.setBusinessState(dogPedigreeCertifiedChangeService.getBusinessState(dogPedigreeCertifiedChange));
            vo.setIsCanCancel(dogPedigreeCertifiedChangeService.isCanCancel(dogPedigreeCertifiedChange) == false ? "0" : "1");
            Association association = associationDao.getByCode(dogPedigreeCertifiedChange.getAssociation());
            if (association != null)
                vo.setAssociation(association.getName());
            list.add(vo);
        }
        return new RESTResponse("data", list);
	}

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String overseasPedigreeCertified = request
				.getParameter("overseasPedigreeCertified");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		DogPedigreeCertifiedChange example = new DogPedigreeCertifiedChange();
		// 设置分页参数
		Page<DogPedigreeCertifiedChange> page = new Page<DogPedigreeCertifiedChange>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setPage(page);
		if (StringUtils.isNotBlank(overseasPedigreeCertified)) {
			example.setOverseasPedigreeCertifiedLike(overseasPedigreeCertified);
		}
		//根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if(StringUtils.isBlank(example.getDogBreed())){
			//根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		}else{
			example.getSqlMap().put("dogBreedMap", " ='"+example.getDogBreed()+"'");
		}
		// 查询并组装返回对象
		Page<DogPedigreeCertifiedChange> result = dogPedigreeCertifiedChangeService
				.findPage(page, example);
		List<DogPedigreeCertifiedChange> dogPedigreeCertifiedChangeList = result
				.getList();
		List<RestDogPedigreeCertifiedChange> list = new ArrayList<RestDogPedigreeCertifiedChange>();
		for (DogPedigreeCertifiedChange dogPedigreeCertifiedChange : dogPedigreeCertifiedChangeList) {
			RestDogPedigreeCertifiedChange vo = new RestDogPedigreeCertifiedChange();
			BeanUtil.copyProperties(vo, dogPedigreeCertifiedChange,
					"yyyy-MM-dd");
			vo.setDogGender(DictUtils.getDictLabel(vo.getDogGender(),
					"dog_gender", ""));
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(),
					"review_state", ""));
			if ("1".equals(vo.getReviewState())) {
				vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(),
						"proccess_state", ""));
			} else {
				if ("0".equals(dogPedigreeCertifiedChange.getDelFlag())) {
					vo.setProcessState("撤销");
				} else {
					vo.setProcessState("已撤销");
				}
			}
			DogType dogType = dogTypeService
					.getByDogBreedCode(vo.getDogBreed());
			String breedCnName = "";
			if(dogType==null){
				breedCnName = dogTypeService.getUnMapBreedCnName(vo.getDogBreed());
			}else{
				breedCnName = dogType.getBreedCnName();
			}
			vo.setBreedCnName(breedCnName);
			vo.setBusinessState(dogPedigreeCertifiedChangeService.getBusinessState(dogPedigreeCertifiedChange));
			vo.setIsCanCancel(dogPedigreeCertifiedChangeService.isCanCancel(dogPedigreeCertifiedChange)==false?"0":"1");
            this.validateRefundState(dogPedigreeCertifiedChange,vo);
			Association association = associationDao.getByCode(dogPedigreeCertifiedChange.getAssociation());
			if(association!=null){
				vo.setAssociation(association.getName());
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list",
				new PageBeanResult<RestDogPedigreeCertifiedChange>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		// 获取参数
		RestDogPedigreeCertifiedChange vo = BeanUtil.toBean(json,
				RestDogPedigreeCertifiedChange.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		DogPedigreeCertifiedChange po = buildPo(vo);
		// 业务校验
		dogPedigreeCertifiedChangeService.validateBusiness(po);
		// 写入业务表
		dogPedigreeCertifiedChangeService.save(po);
		// 写入购物车
        String businessOrderCode = IdGen.uuid();
        PaymentCart paymentCart = buildPaymentCart(po, businessOrderCode);
        paymentCartService.addToCart(paymentCart, "1007");
		return new RESTResponse("data",paymentCart.getId());
	}

	/**
	 *
	 * @description: 参数校验
	 * 除了所属协会和犬只芯片为非必填，其余都为必填
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(RestDogPedigreeCertifiedChange vo) {
		Member member = UserUtils.getLoginMember();
		if(!MemberUtil.isProfessionalMember(member)){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,"该业务仅限有效专业会员办理");
		}
		if (StringUtils.isBlank(vo.getDogBreed())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种为空");
		}
		if (StringUtils.isBlank(vo.getOrgId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请选择合作机构");
		}
		if (StringUtils.isBlank(vo.getDogGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只性别为空");
		}
		if (StringUtils.isBlank(vo.getOverseasPedigreeCertified())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "外国血统证书号为空");
		}
		if (StringUtils.isBlank(vo.getDogName())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬名为空");
		}
		if (StringUtils.isBlank(vo.getDogFurColor())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "毛色为空");
		}
		if (StringUtils.isBlank(vo.getDogBirthday())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期为空");
		}
		if (!"1".equals(vo.getDogGender()) && !"2".equals(vo.getDogGender())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只性别只能为1,2");
		}
	}

	/**
	 *
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private DogPedigreeCertifiedChange buildPo(RestDogPedigreeCertifiedChange vo) {
		DogPedigreeCertifiedChange po = new DogPedigreeCertifiedChange();
		po.setOverseasPedigreeCertified(vo.getOverseasPedigreeCertified());
		//判断该换发犬只是否CKU出口的犬只，不是返回NULL
		Dog dog = dogPedigreeCertifiedChangeService.isCkuExportDog(vo.getOverseasPedigreeCertified().toUpperCase());
		if(dog!=null){
			//构建CKU的犬只进行证书换发
			dogPedigreeCertifiedChangeService.buildCkuChange(po,dog);
		}else{
			po.setDogBreed(vo.getDogBreed());
			po.setDogName(vo.getDogName());
			po.setDogGender(vo.getDogGender());
			po.setDogFurColor(vo.getDogFurColor());
			try {
				po.setDogBirthday(new SimpleDateFormat("yyyy-MM-dd").parse(vo
						.getDogBirthday()));
			} catch (ParseException e) {
				e.printStackTrace();
			}
			po.setDogChip(vo.getDogChip());
			//由于会员中心协会下拉框换了实现方式，无法取得code，只能传name，所以服务端需要进行处理
			po.setAssociation(vo.getAssociation().substring(vo.getAssociation().indexOf("-")+1));
		}
		//设置合作机构信息
		Org org = orgDao.get(vo.getOrgId());
		Member member = UserUtils.getLoginMember();
		//判断是否可申请该单犬种俱乐部
		orgDogTypeLimitService.checkSingleTypeClub(vo.getOrgId(),po.getDogBreed());
		po.setOrgId(org.getId());
		po.setOrgName(org.getName());
		po.setCallName(vo.getCallName());
		po.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(po.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		po.setPrice(paymentChargingItem.getPrice());
		po.setReviewState("0");
		po.setProcessState("0");
		po.setPaymentState("1");
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(vo.getStickerFlag())){
//			po.setStickerFlag("1");
//		}
		po.setStickerFlag("0");
		return po;
	}

    private PaymentCart buildPaymentCart(DogPedigreeCertifiedChange po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(po.getDogBreed())) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		paymentCart.setChargingItemId(paymentChargingItem.getId());
		paymentCart.setChargingItemName(paymentChargingItem.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(paymentChargingItem.getPrice());
		paymentCart.setTotalPrice(paymentChargingItem.getPrice());
		paymentCart.setBusinessTable("dog_pedigree_certified_change");
		paymentCart.setBusinessIds(po.getId());
        paymentCart.setBusinessOrderCode(businessOrderCode);
        return paymentCartService.addBusinessManage(paymentCart, "1007");
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String dogBreed = request.getParameter("dogBreed");
		if (StringUtils.isBlank(dogBreed)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬种不能为空");
		}
		// 获取价格
		String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
		if ("230".equals(dogBreed)) {
			shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
		}
		PaymentChargingItem paymentChargingItem = paymentChargingItemService
				.getByShortName(shortName);
		JSONObject jo = new JSONObject();
		jo.put("price", paymentChargingItem.getPrice());
		return new RESTResponse("data", jo);
	}

	/**
	 *
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月9日 上午11:03:52
	 */
	public RESTResponse orderDetail(String id) {
		DogPedigreeCertifiedChange po = dogPedigreeCertifiedChangeService.get(id);
		SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd");
		Map<String, String> map = new HashMap<>();
		map.put("key1", "犬名："+po.getDogName());
		DogType dogType = dogTypeService
				.getByDogBreedCode(po.getDogBreed());
		String breedCnName = "";
		if(dogType==null){
			breedCnName = dogTypeService.getUnMapBreedCnName(po.getDogBreed());
		}else{
			breedCnName = dogType.getBreedCnName();
		}
		map.put("key2", "犬种："+breedCnName);
		map.put("key3", "国外血统证书号："+po.getOverseasPedigreeCertified());
		map.put("key4", "性别："+DictUtils.getDictLabel(po.getDogGender(),"dog_gender", ""));
		if(po.getDogBirthday()!=null&&!"".equals(po.getDogBirthday())){
			map.put("key5", "出生日期："+sdf.format(po.getDogBirthday()));
		} else {
			map.put("key5", "出生日期：");
		}
		map.put("key6", "毛色："+po.getDogFurColor());
		map.put("key7", "所属协会："+po.getAssociation());
		return new RESTResponse("data", map);
	}

	/**
	 *
	 * @Description：新生犬登记撤销操作
	 * @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:00:53
	 */
	@Transactional(readOnly = false)
	public RESTResponse canceled(String id) {
		DogPedigreeCertifiedChange po = dogPedigreeCertifiedChangeService.get(id);
		Member member = UserUtils.getLoginMember();
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
        this.validateRefundState(po,null);
		dogPedigreeCertifiedChangeService.canceled(po);
		return  new RESTResponse();
	}
	
	@Transactional(readOnly = false)
	public RESTResponse changeOrg(ChangeOrgReqVo changeOrgReqVo) {
		Member member = UserUtils.getLoginMember();
		DogPedigreeCertifiedChange po = dogPedigreeCertifiedChangeService.get(changeOrgReqVo.getBusinessId());

		if( StringUtils.isNotEmpty(po.getDogChip())
				&& StringUtils.isNotEmpty(po.getDogDnaArchiveId()))  {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "机构已核对芯片,DNA已采集不能修改合作机构");
		}
		Org org = orgDao.get(changeOrgReqVo.getOrgId());
		// 判断是否可申请该单犬种俱乐部
		orgDogTypeLimitService.checkSingleTypeClubNew(changeOrgReqVo.getOrgId(), po.getDogBreed());
		po.setOrgId(org.getId());
		po.setOrgName(org.getName());

		dogPedigreeCertifiedChangeService.updateChange(po);
		return new RESTResponse();
	}

}