package com.cku.partner.sys;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 地方俱乐部登录拦截器
 * 
 * @author chaixueteng
 */
public class LoginInterceptor implements HandlerInterceptor {
	// private Logger logger = LoggerFactory.getLogger(LoginInterceptor.class);

	@Override
	public void afterCompletion(HttpServletRequest arg0,
			HttpServletResponse arg1, Object arg2, Exception arg3)
			throws Exception {
	}

	
	@Override
	public void postHandle(HttpServletRequest arg0, HttpServletResponse arg1,
			Object arg2, ModelAndView arg3) throws Exception {
	}

	/**
	 * 合作学校的接口拦截器
	 */
	@Override
	public boolean preHandle(HttpServletRequest request,
			HttpServletResponse response, Object arg2) throws Exception {
		
		//如果为app登陆登录等接口不做拦截限制
		if (request.getRequestURI().startsWith(
				request.getContextPath() + "/partner/open/")) {
			return true;
		}
		
		String token = request.getHeader("token");
		//判断是否存在token参数，若存在则放行请求
		if(StringUtils.isNotBlank(token)){
			return true;
		}
		
		// 判断用户的登录信息
		User user = UserUtils.getLoginUser();
		if(user == null || user.getId() == null){
			response.sendRedirect("/oa-web/partner/login");
			return false;
		}
		return true;
	}

}
