package com.cku.partner.club.web;

import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.core.ZAException;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.finance.entity.PaymentRecord;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.dao.SysOrgPrintDao;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.SysOrgPrint;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.SysOrgPrintService;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.partner.club.service.PaymentService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 合作俱乐部
 *user chaixueteng
 *2016年10月8日
 */
@Controller
@RequestMapping(value="/partner/clubPrint")
public class clubPrintController  extends BaseController{

	@Autowired
	public OrgService orgService;
	@Autowired
	public DogService dogService;
	@Autowired
	public MemberService memberService;
	@Autowired
	public SysOrgPrintService sysOrgPrintService;
	@Autowired
	public SysOrgPrintDao sysOrgPrintDao;
	@Autowired
	public PaymentService paymentService;
	@Autowired
	public PaymentChargingItemService paymentChargingItemService;

	/**
	 * 血统证书重置打印
	 * @Author chaixueteng
	 * @2016年10月8日下午6:24:28
	 */
	@RequestMapping(value = "restPrint")
	public String restPrint(HttpServletRequest request, HttpServletResponse response, Model model,RedirectAttributes redirectAttributes) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String birthCode = request.getParameter("birthCode").trim();
		Dog dog = dogService.getByBirthCertificateLevelCode(birthCode);
		SysOrgPrint sysOrgPrint = sysOrgPrintDao.getByOrgId(org.getId());
		String restPrintCode = sysOrgPrint.getRestPrintCode();
		Integer printCode = Integer.valueOf(restPrintCode);
		if(printCode==0){
			addMessage(redirectAttributes, "您账号可重置次数为0!");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		if(dog==null){
			addMessage(redirectAttributes, "查询登记卡失败:登记卡编号不正确!");
			return "redirect:/partner/clubMember/dogList?repage";
		}
		if(StringUtils.isBlank(dog.getPrintState())){
			addMessage(redirectAttributes, "查询登记卡失败:该登记卡打印参数有误!");
			return "redirect:/partner/clubMember/dogList?repage";
		}else if("2".equals(dog.getPrintState())){
				addMessage(redirectAttributes, "该登记卡未打印,不需要重置!");
				return "redirect:/partner/clubMember/dogList?birthCerRegCode="+birthCode;
		}
        String resultCode = (Long.parseLong(restPrintCode)-1)+"";
        sysOrgPrint.setRestPrintCode(resultCode);
		sysOrgPrintService.save(sysOrgPrint);
		dog.setPrintState("2");
        //打印更新时间和操作人
		dog.preUpdate();
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		dog.setOperator(dog.getOperator()+"["+dog.getUpdateBy()+"<重置打印>:"+format.format(dog.getUpdateDate())+"]");
		dogService.updatePrintState(dog);
		return "redirect:/partner/clubMember/dogList?birthCerRegCode="+birthCode;
	}

    @RequestMapping(value = "toMemberPay")
    public String toMemberPay(String memberCode,String type,Integer num,String price,String id, Model model) {
        model.addAttribute("payType",paymentChargingItemService.getByShortName(type));
        model.addAttribute("memberForm",memberService.getByMemberCode(memberCode));
        model.addAttribute("num",num);
        if(price!=null && !"".equals(price)){
            model.addAttribute("price",price);
        }else{
            model.addAttribute("price",null);
        }

        model.addAttribute("id",id);
		return "partner/pay/clubMemberPay";
    }
   
    @RequestMapping(value = "paySave")
    @ResponseBody
    public String paySave(PaymentRecord paymentRecord, Model model) {
        if (!beanValidator(model, paymentRecord)){
            return "{\"rc\":-1,\"msg\":\"error\"}";
        }
        try {
            paymentService.paySave(paymentRecord);
        } catch (ZAException e) {
            return "{\"rc\":"+e.get_code()+",\"msg\":\""+e.getMessage()+"\"}";
        }
        return "{\"rc\":0,\"msg\":\""+paymentRecord.getPaymentRemarks()+"\"}"; 
    }
}
