/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.trainschool.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 美容学校邮寄Entity
 *
 * @author 赖广龙
 * @version 2017-06-20
 */
public class GroomerSchoolMail extends DataEntity<GroomerSchoolMail> {

    private static final long serialVersionUID = 1L;
    private String schoolId;        // 美容学校id，training_institution表主键
    private Date releaseDate;        // 发放日期
    private String releaseNum;        // 发放数量
    //美容学校相关字段
    private String schoolNameCn;        // 学校中文

    public GroomerSchoolMail() {
        super();
    }

    public GroomerSchoolMail(String id) {
        super(id);
    }

    @Length(min = 1, max = 50, message = "美容学校id，training_institution表主键长度必须介于 1 和 50 之间")
    public String getSchoolId() {
        return schoolId;
    }

    public void setSchoolId(String schoolId) {
        this.schoolId = schoolId;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "发放日期不能为空")
    public Date getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(Date releaseDate) {
        this.releaseDate = releaseDate;
    }

    @Length(min = 1, max = 5, message = "发放数量长度必须介于 1 和 5 之间")
    public String getReleaseNum() {
        return releaseNum;
    }

    public void setReleaseNum(String releaseNum) {
        this.releaseNum = releaseNum;
    }

    public String getSchoolNameCn() {
        return schoolNameCn;
    }

    public void setSchoolNameCn(String schoolNameCn) {
        this.schoolNameCn = schoolNameCn;
    }
}