package com.cku.oa.sys.util;

import java.util.Calendar;
import java.util.Date;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberType;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
/**
 * 工具类，用于用户的基本校验
 * @author fanhuibin
 *
 */
public class MemberUtil {
	
	/**
	 * 判断一个用户是否为基础类型用户
	 * @param member
	 * @return
	 */
	public static boolean isBasicMember(Member member) {
		if(member!=null && member.getMemberType().equals(MemberType.basic.toString())){
			return true;
		}
		
		if(member!=null && (member.getMemberType() == null || member.getMemberType().equals(""))){
			return true;
		}
		
		return false;
	}
	
	/**
	 * 判断一个用户是否为专业版的用户
	 * @param member
	 * @return
	 */
	public static boolean isProfessionalMember(Member member) {
		if(member!=null && member.getMemberType().equals(MemberType.professional.toString())){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断一个用户是否为专业版的用户
	 * @param member
	 * @return
	 */
	public static boolean isProfessionalBreedMember(Member member) {
		if(member!=null && member.getMemberType().equals(MemberType.professional.toString()) && member.getKennel() != null && "year".equals(member.getKennel().getType())){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断当前一个用户是否为已缴费状态
	 * @param member
	 * @return
	 */
	public static boolean isActiveMember(Member member) {
		if(member == null) {
			return false;
		}
		//校验是否是冻结会员
		if("1".equals(member.getFreezeFlag())){
			return false;
		}
		Calendar calendar = Calendar.getInstance();  
        calendar.setTime(new Date());  
        calendar.add(Calendar.DAY_OF_MONTH, -1);  
	    Date  currentDate = calendar.getTime(); 
		//美容师会员没有过期，但是会员过期的，默认算是基础会员，享有基础会员的基本功能
		if(member!=null && member.getGroomerEndDate()!= null && member.getGroomerEndDate().getTime()>currentDate.getTime()){
			return true;
		}
		if(member!=null &&member.getPaymentState() != null && member.getPaymentState().equals("2")){
			return true;
		}
		return false;
	}

	/**
	 * @Description： 专业有效会员判断
	 * @author: yuanshuai
	 * @date: 2019/12/2 14:16
	 */
	public static boolean isActiveProfessionalMember(Member member) {
		if (member == null) {
			return false;
		}
		//校验是否是冻结会员
		if ("1".equals(member.getFreezeFlag())) {
			return false;
		}
		//有效期判断
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(new Date());
		calendar.add(Calendar.DAY_OF_MONTH, -1);
		Date currentDate = calendar.getTime();
		if (MemberType.professional.toString().equals(member.getMemberType()) &&
				member.getMemberEndDate() != null && member.getMemberEndDate().getTime() > currentDate.getTime()) {
			return true;
		}
		return false;
	}

	/**
	 * 
	 * @Description：犬舍是否有效校验
	 * @author: zhuoHeng
	 * @version: 2016年9月21日 下午3:05:01
	 */
	public static boolean isActiveKennel(Member member) {
		Date currentDate = new Date();
		//犬舍是否有效校验
		if(member!=null && member.getKuEndDate()!= null && member.getKuEndDate().getTime()>currentDate.getTime()){
			return true;
		}
		return false;
	}
	
	/**
	 * 美容师正式会员
	 */
	public static boolean isActiveGroomer(Member member) {
		Date currentDate = new Date();
		if(member!=null && member.getGroomerEndDate()!= null && member.getGroomerEndDate().getTime()>currentDate.getTime()){
			return true;
		}
		return false;
	} 
	/**
	 * @Description : 根据当前登录端判断犬种
	 * @param member
	 * @return
	 */
	public static String findDogTypeByUType(){
		Member po = UserUtils.getLoginMember();
		if("4".equals(po.getUser().getUserType())){//杜高会员端登录
			return "292";//杜高犬种
		}else{
			return "!292";
		}
	}


	/**
	 * @Description： 查询会员或美容会员是否失效
	 * @author: yuanshuai
	 * @date: 2019/12/2 14:16
	 */
	public static Boolean queryActiveMemberOrGroomerMember(Member member) {
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_ERROR, "会员信息不存在");
		}
		//校验是否是冻结会员
		if ("1".equals(member.getFreezeFlag())) {
			return Boolean.FALSE;
		}
		if ((member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime())
				|| (member.getGroomerEndDate() != null
				&& member.getGroomerEndDate().getTime() >= new Date().getTime())) {
			return Boolean.TRUE;
		} else {
			return Boolean.FALSE;
		}
	}

	/**
	 * 判断当前一个用户是否为已缴费状态
	 * @param member
	 * @return
	 */
	public static boolean isCkuActiveMember(Member member) {
		if(member == null) {
			return false;
		}
		//校验是否是冻结会员
		if("1".equals(member.getFreezeFlag())){
			return false;
		}
		if(member!=null &&member.getPaymentState() != null && member.getPaymentState().equals("2")
				&& member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime()){
			return true;
		}
		return false;
	}
}
