package com.cku.oa.sys.service.user;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.oa.activity.service.SysMemberActivityRecordService;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.dao.GroomerQualificationCertificateDao;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.entity.GroomerPost;
import com.cku.oa.groomer.entity.GroomerQualificationCertificate;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.ExpressQueueService;
import com.cku.oa.sys.service.RemindService;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.sys.zalog.SysZaLogDao;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.excel.ExportExcel;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.entity.User;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

/**
 * 美容师会员的service
 * 
 * @author fanhuibin
 *
 */
@Service
@Transactional(readOnly = true)
public class GroomerMemberService extends CrudService<MemberDao, Member> {
	@Autowired
	public GroomerDiplomaDao groomerDiplomaDao;
	@Autowired
	public GroomerQualificationCertificateDao groomerQualificationCertificateDao;
	@Autowired
	public ExpressQueueService expressQueueService;
	@Autowired
	public RemindService remindService;
	@Autowired
	public SysMemberActivityRecordService sysMemberActivityRecordService;

	/**
	 * 获取美容师的列表
	 */
	public Page<Member> findPage(Page<Member> page, Member sysMember) {
		sysMember.setPage(page);
		page.setList(dao.findGroomerList(sysMember));
		return page;
	}

	/**
	 * 更新美容师会员的开始与结束时间
	 * 
	 * @param memberCode 会员号
	 */
	@Transactional(readOnly = false)
	public void groomerUpdate(String memberCode) {
		Member member = dao.getByMemberCode(memberCode);
		// 如果不是美容会员则同步
		if (StringUtils.isBlank(member.getGroomerType())) {
			Member update = new Member();
			update.setMemberCode(memberCode);
			Date memberEndDate = member.getMemberEndDate();
			update.setGroomerEndDate(memberEndDate);
			update.setGroomerType("reserve");
			dao.updateGroomer(update);
		}
	}

	/**
	 * 美容师会员注册
	 * 
	 * @param memberCode 会员号
	 */
	@Transactional(readOnly = false)
	public void groomerRegister(String memberCode) {

	}

	/**
	 * 美容师会员升级（预备转正式）
	 * 
	 * @param memberCode 会员号
	 */
	@Transactional(readOnly = false)
	public void groomerGradeUpgraded(String memberCode) {

	}

	/**
	 * 获取美容师培训和考试经历
	 * 
	 * @Author chaixueteng
	 * @2016年7月26日下午4:45:47
	 */
	public String getMemberExperience(String memberCode) {
		List list = new ArrayList();
		Map<String, Object> map = new HashMap<String, Object>();
		SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
		// 得到培训信息
		GroomerDiploma gd = groomerDiplomaDao.getTrain(memberCode);
		if (gd != null) {
			map.put("rc", "0");
			String schoolNameCn = gd.getSchoolNameCn();
			if (schoolNameCn != null) {
				map.put("schoolNameCn", schoolNameCn);
			} else {
				map.put("schoolNameCn", "");
			}
			if (gd.getStartDate() != null) {
				map.put("startDate", df.format(gd.getStartDate()));
			} else {
				map.put("startDate", "");
			}
			if (gd.getEndDate() != null) {
				map.put("endDate", df.format(gd.getEndDate()));
			} else {
				map.put("endDate", "");
			}
			map.put("level", gd.getCertificateLevel());
			map.put("code", gd.getCertificateCode());
		} else {
			map.put("rc", "1");
		}
		// 得到考试信息
		List<GroomerQualificationCertificate> gqc = groomerQualificationCertificateDao.getMemberTest(memberCode);
		if (gqc != null && gqc.size() > 0) {
			for (GroomerQualificationCertificate qc : gqc) {
				Map<String, Object> map1 = new HashMap<String, Object>();
				Date takeCertificateDate = qc.getTakeCertificateDate();
				String code = qc.getCertificateCode();
				String referee = qc.getGroomerRegister().getReferee();
				String level = DictUtils.getDictLabel(qc.getLevelEn(), "groomer_test_level", "");
				String grade = DictUtils.getDictLabel(qc.getGroomerRegister().getGrade(), "Grade", "");
				map1.put("showName", qc.getGroomerShow().getShowName());
				map1.put("grade", grade);
				map1.put("level", level);
				if (referee != null) {
					map1.put("referee", referee);
				} else {
					map1.put("referee", "");
				}
				if (takeCertificateDate != null) {
					map1.put("takeDate", df.format(takeCertificateDate));
				} else {
					map1.put("takeDate", "");
				}
				if (code != null) {
					map1.put("code", code);
				} else {
					map1.put("code", "");
				}
				list.add(map1);
			}
		} else {
			map.put("rc", "1");
		}
		map.put("list", list);
		return JSONObject.fromObject(map).toString();
	}

	/**
	 * 更新美容师会员信息
	 * 
	 * @Author chaixueteng
	 * @2016年8月20日上午11:14:07
	 */
	@Transactional(readOnly = false)
	public void updateGroomerMember(Member member) {
		member.preUpdate();
		dao.updateGroomerMember(member);
	}

	/**
	 * 更新美容师会员信息
	 * 
	 * @Author chaixueteng
	 * @2016年8月20日上午11:14:07
	 */
	@Transactional(readOnly = false)
	public void updateGroomerMemberClub(Member member) {
		SysContext sysContext = new SysContext(null,null,null);
		User user = UserUtils.getUser();
		Member dbMember = dao.get(member.getId());
		String info = String.format("会员所属俱乐部修改，修改人：%s | %s，修改前：%s，修改后：%s，是否同时修改登记人：%s，", user.getId(), user.getName(),
				dbMember.getCkuClub(), member.getCkuClub(), "1".equals(member.getRegistrantModifyFlag()) ? "是" : "否");
		sysContext.noStateExecute(sysContext, info, member.getMemberCode(), "sys_member", member.getId(), "", (str) -> {
			member.preUpdate();
			dao.updateGroomerMemberClub(member);
		});
	}

	/**
	 * 第一次申领资格证书 更改为正式会员
	 * 
	 * @throws ParseException
	 * @Author chaixueteng
	 * @2016年9月1日下午5:22:44
	 */
	@Transactional(readOnly = false)
	public void updateMember(String memberCode) {
		Member member = dao.getByMemberCode(memberCode);
		Member oldMember = new Member();
		BeanUtils.copyProperties(member, oldMember);
		if (!"1".equals(member.getPrintState())) {
			member.setPrintState("0");
		}
		member.setGroomerType("formal");
		if (member.getMemberEndDate() != null) {
			if (member.getGroomerEndDate() == null) {
				member.setGroomerEndDate(member.getMemberEndDate());
			} else if (member.getMemberEndDate().getTime() > member.getGroomerEndDate().getTime()) {// 会员截止日期长
				member.setGroomerEndDate(member.getMemberEndDate());
			}
		}
		dao.updateMember(member);
		sysMemberActivityRecordService.saveMemberRecordWoOrder(oldMember, member, UserUtils.getUser(), null);
	}

	/**
	 * 美容师打印
	 * 
	 * @Author chaixueteng
	 * @2016年11月1日下午1:44:23
	 */
	@Transactional(readOnly = false)
	public Member groomerMemberPrint(Member member) {
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "美容师正式会员打印", member.getMemberCode(), "sys_member", member.getId(), "",
				(str) -> {
				});
		member.setPrintState("1");
		dao.restPrint(member);
		// 推送打印消息
		expressQueueService.push(member.getMemberCode(), null, "美容师正式会员打印", null, null); // GYH2 TODO
		return member;
	}

	/**
	 * 美容师正式会员卡 重置打印
	 * 
	 * @Author chaixueteng
	 * @2016年11月1日下午3:17:41
	 */
	@Transactional(readOnly = false)
	public void updatePrint(Member member) {
		member.setPrintState("0");
		dao.restPrint(member);
	}

	/**
	 *
	 * @throws Exception
	 * @Author chaixueteng
	 * @2016年7月26日上午10:32:18
	 */
	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importShows(MultipartFile file, HttpServletResponse response) throws Exception {
		ImportExcel ei = new ImportExcel(file, 0, 0);
		List<GroomerPost> list = ei.getDataList(GroomerPost.class);
		List<GroomerPost> plist = new ArrayList<GroomerPost>();
		for (GroomerPost gp : list) {
			GroomerPost gp2 = new GroomerPost();
			Member member = dao.getByMemberCode(gp.getMemberCode().trim());
			gp2.setMemberCode(member.getMemberCode());
			gp2.setName(member.getName());
			gp2.setMoblie(member.getMobile());
			gp2.setAddress(member.getProvince() + "" + member.getCity() + "" + member.getStreet());
			plist.add(gp2);
		}
		export(plist, response);
	}

	public void export(List<GroomerPost> GroomerPostList, HttpServletResponse response) throws IOException {
		new ExportExcel("", GroomerPost.class, 1).setDataList(GroomerPostList).write(response, "美容邮寄信息表.xlsx")
				.dispose();
	}
}
