package com.cku.oa.sys.service;

import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.finance.dao.PaymentOrderDao;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.sys.dao.ExpressQueueDao;
import com.cku.oa.sys.dao.user.MemberDao;
import com.cku.oa.sys.entity.ExpressQueue;
import com.cku.oa.sys.entity.user.Member;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 待邮寄物品Service
 * 
 * @author fanhuibin
 * @version 2016-09-01
 */
@Service
@Transactional(readOnly = true)
public class ExpressQueueService extends CrudService<ExpressQueueDao, ExpressQueue> {

	@Autowired
	private PaymentOrderDao paymentOrderDao;
	@Autowired
	private MemberDao memberDao;

	public ExpressQueue get(String id) {
		return super.get(id);
	}

	public List<ExpressQueue> findList(ExpressQueue expressQueue) {
		return super.findList(expressQueue);
	}

	public Page<ExpressQueue> findPage(Page<ExpressQueue> page, ExpressQueue expressQueue) {
		return super.findPage(page, expressQueue);
	}

	@Transactional(readOnly = false)
	public void save(ExpressQueue expressQueue) {
		super.save(expressQueue);
	}

	@Transactional(readOnly = false)
	public void delete(ExpressQueue expressQueue) {
		super.delete(expressQueue);
	}

	/**
	 * 推送一条待邮寄的证书的信息
	 * 
	 * @param memberCode      该证书对应的会员
	 * @param runningNum      该证书的支付流水信息，用于获取订单的地址信息
	 * @param certificateName 证书名称
	 * @param certificateNo   证书的编号
	 * @param businessTable   业务表
	 * @param businessId      业务表主键
	 */
	@Transactional(readOnly = false)
	public void push(String memberCode, String runningNum, String certificateName, String certificateNo,
			String businessTable, String businessId, String chargingItemId) {
		// 先判断当前要发件的内容是否已经被添加到了发送的列表
		ExpressQueue queue = new ExpressQueue();
		String itemName = certificateName + "(" + certificateNo + ")";
		queue.setItemName(itemName);
		List<ExpressQueue> queues = this.findList(queue);
		if (queues.size() != 0) {
			return;
		}

		// 查询会员的信息
		if (!StringUtils.isEmpty(memberCode)) {
			Member member = memberDao.getByMemberCode(memberCode);
			String province = null, city = null, area = null, address = null, name = null, phone = null,
					postcode = null;
			// 通过流水号查询订单中的收件信息
			if (!StringUtils.isEmpty(runningNum)) {
				PaymentOrder order = new PaymentOrder();
				order.setOrderCode(runningNum);
				List<PaymentOrder> list = paymentOrderDao.findList(order);

				// 如果找到这条记录，则读取该记录的收件地址
				if (list.size() == 1) {
					order = list.get(0);
					province = order.getReceiveProvince();
					city = order.getReceiveCity();
					area = order.getReceiveArea();
					address = order.getReceiveAddress();
					name = order.getReceiver();
					phone = order.getReceiveDel();
					postcode = order.getReceivePostCode();
				}
			}

			if (province == null || city == null || area == null) {
				province = member.getProvince();
				city = member.getCity();
				area = member.getArea();
				address = member.getStreet();
				phone = member.getMobile();
				name = member.getName();
				postcode = member.getPostcode();
			}

			// 如果没有找到这条记录，则查询用户个人信息中的收件地址
			queue.setMemberCode(memberCode);
			queue.setMemberName(member.getName());
			queue.setProvince(province);
			queue.setCity(city);
			queue.setArea(area);
			queue.setStreet(address);
			queue.setPhone(phone);
			queue.setReceiver(name);
			queue.setPostcode(postcode);
			queue.setRunningNumber(runningNum);
			queue.setBusinessId(businessId);
			queue.setBusinessTable(businessTable);
			queue.setChargeItemId(chargingItemId);
			this.save(queue);
		}
	}

	/**
	 * 推送一条待邮寄的证书的信息
	 * 
	 * @param memberCode      该证书对应的会员
	 * @param runningNum      该证书的支付流水信息，用于获取订单的地址信息
	 * @param certificateName 证书名称
	 * @param certificateNo   证书的编号
	 */
	@Transactional(readOnly = false)
	@Deprecated
	public void push(String memberCode, String runningNum, String certificateName, String certificateNo,
			String chargingItemId) {
		this.push(memberCode, runningNum, certificateName, certificateNo, "", "", chargingItemId);
	}

	/**
	 * 逻辑删除待发货邮件记录
	 * 
	 * @param id
	 * @return
	 */
	@Transactional(readOnly = false)
	public Integer deleteByBusinessId(String id) {
		return dao.deleteByBusinessId(id);
	}
	
	
	public List<ExpressQueue> getByIds(List<String> ids) {
		return dao.getByIds(ids);
	}


	@Transactional(readOnly = false)
	public Integer deleteByBusinessIds(Set<String> ids) {
		return dao.deleteByBusinessIds(ids);
	}
}