package com.cku.oa.statistics.entity;

import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;
import com.thinkgem.jeesite.modules.sys.entity.Office;

public class ShowOfficeRegion extends DataEntity<ShowOfficeRegion> {
	
	private static final long serialVersionUID = 1L;
	private Office office;		// 办公室id
	private String officeName;		// 大区名称
	private String region;		// 省份
	private String adminUserId;		// 业务管理员ID
	private String regionUserId;		// 区域负责人ID
	
	public ShowOfficeRegion() {
		super();
	}

	public ShowOfficeRegion(String id){
		super(id);
	}

	public Office getOffice() {
		return office;
	}

	public void setOffice(Office office) {
		this.office = office;
	}
	
	@Length(min=0, max=20, message="大区名称长度必须介于 0 和 20 之间")
	public String getOfficeName() {
		return officeName;
	}

	public void setOfficeName(String officeName) {
		this.officeName = officeName;
	}
	
	@Length(min=0, max=64, message="省份长度必须介于 0 和 64 之间")
	public String getRegion() {
		return region;
	}

	public void setRegion(String region) {
		this.region = region;
	}
	
	@Length(min=0, max=64, message="业务管理员ID长度必须介于 0 和 64 之间")
	public String getAdminUserId() {
		return adminUserId;
	}

	public void setAdminUserId(String adminUserId) {
		this.adminUserId = adminUserId;
	}
	
	@Length(min=0, max=64, message="区域负责人ID长度必须介于 0 和 64 之间")
	public String getRegionUserId() {
		return regionUserId;
	}

	public void setRegionUserId(String regionUserId) {
		this.regionUserId = regionUserId;
	}
	
}