package com.cku.oa.show.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.show.entity.ShowVenue;
import com.cku.oa.show.service.ShowVenueService;

/**
 * 犬展场馆Controller
 * @author 柴雪腾
 * @version 2017-08-02
 */
@Controller
@RequestMapping(value = "${adminPath}/show/showVenue")
public class ShowVenueController extends BaseController {
	
	private final static String URL_PRDFIX = "oa/show/venue/";
	@Autowired
	private ShowVenueService showVenueService;
	
	@ModelAttribute
	public ShowVenue get(@RequestParam(required=false) String id) {
		ShowVenue entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = showVenueService.get(id);
		}
		if (entity == null){
			entity = new ShowVenue();
		}
		return entity;
	}
	
	@RequiresPermissions("show:showVenue:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShowVenue showVenue, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShowVenue> page = showVenueService.findPage(new Page<ShowVenue>(request, response), showVenue); 
		model.addAttribute("page", page);
		return URL_PRDFIX+"showVenueList";
	}

	@RequiresPermissions("show:showVenue:view")
	@RequestMapping(value = "view")
	public String view(ShowVenue showVenue, Model model) {
		model.addAttribute("showVenue", showVenue);
		return URL_PRDFIX+"showVenueView";
	}
	@RequiresPermissions("show:showVenue:edit")
	@RequestMapping(value = "form")
	public String form(ShowVenue showVenue, Model model) {
		model.addAttribute("showVenue", showVenue);
		return URL_PRDFIX+"showVenueForm";
	}

	@RequiresPermissions("show:showVenue:view")
	@RequestMapping(value = "save")
	public String save(ShowVenue showVenue, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(StringUtils.isEmpty(showVenue.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("show:showVenue:add");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("show:showVenue:edit");
		}
		if(!hasPermission){
			throw new AuthorizationException("用户权限不足");
		}
		
		if (!beanValidator(model, showVenue)){
			return form(showVenue, model);
		}
		showVenueService.save(showVenue);
		addMessage(redirectAttributes, "保存犬展场馆成功");
		return "redirect:"+Global.getAdminPath()+"/show/showVenue/?repage";
	}
	
	@RequiresPermissions("show:showVenue:delete")
	@RequestMapping(value = "delete")
	public String delete(ShowVenue showVenue, RedirectAttributes redirectAttributes) {
		showVenueService.delete(showVenue);
		addMessage(redirectAttributes, "删除犬展场馆成功");
		return "redirect:"+Global.getAdminPath()+"/show/showVenue/?repage";
	}

}