package com.cku.oa.show.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.show.dao.ShowReportScoreDao;
import com.cku.oa.show.entity.ChildShows;
import com.cku.oa.show.entity.MainShows;
import com.cku.oa.show.entity.ShowJudge;
import com.cku.oa.show.entity.ShowReportScore;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.utils.excel.ImportExcel;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;

/**
 * 播报成绩Service
 * @author lyy
 * @version 2018-01-22
 */
@Service
@Transactional(readOnly = true)
public class ShowReportScoreService extends CrudService<ShowReportScoreDao, ShowReportScore> {
	@Autowired
	private ChildShowsService childShowsService;
	@Autowired
	private MainShowsService mainShowsService;
	@Autowired
	private ShowJudgeService showJudgeService;

	public ShowReportScore get(String id) {
		return super.get(id);
	}
	
	public List<ShowReportScore> findList(ShowReportScore showReportScore) {
		return super.findList(showReportScore);
	}
	
	public Page<ShowReportScore> findPage(Page<ShowReportScore> page, ShowReportScore showReportScore) {
		return super.findPage(page, showReportScore);
	}

	public List<ShowJudge> findJudgeById(String id){
		List<ShowJudge> result = new ArrayList<ShowJudge>();
		ShowReportScore showReportScore = super.get(id);
		String mainShowId = showReportScore.getMainShowId();
		MainShows mainShows = mainShowsService.get(mainShowId);
		String referees = mainShows.getReferee();
		if(StringUtils.isNotBlank(referees)){
			String [] arr = referees.split(",");
			for(String judgeId : arr){
				ShowJudge pre = showJudgeService.get(judgeId);
				result.add(pre);
			}
		}
		return result;
	}
	public ShowReportScore findScore(String showCode,String order){
		return dao.findScore(showCode,order);
	}
	@Transactional(readOnly = false)
	public void save(ShowReportScore showReportScore) {
		super.save(showReportScore);
	}
	
	@Transactional(readOnly = false)
	public void delete(ShowReportScore showReportScore) {
		super.delete(showReportScore);
	}

	@Transactional(readOnly = false, rollbackFor = Exception.class)
	public void importShowReportScore(MultipartFile file) throws IOException, InvalidFormatException, IllegalAccessException, InstantiationException, CloneNotSupportedException {

		ImportExcel ei = new ImportExcel(file, 0, 0);
		List<ShowReportScore> list = ei.getDataList(ShowReportScore.class);
		//1,将所有犬展编号拆分放入set中
		Set<String> showCodeSet = new HashSet<String>();
		for(int i=0;i<list.size();i++){
			ShowReportScore showReportScore =  list.get(i);
			String showCodeStr = showReportScore.getShowCode();
			if(StringUtils.isNotBlank(showCodeStr)){
				String[] codeArr = showCodeStr.split(",");
				for(String realShowCode : codeArr){
					showCodeSet.add(realShowCode);
				}
			}
		}
		if(showCodeSet.size()<=0){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"没有犬展编号！");
		}
		//2，验证set中的值是否属于同一场主犬展
		Set<String> mainShowSet = new HashSet<String>();
		String mainShowId = "";
		for(String showCode : showCodeSet){
			ChildShows childShows = childShowsService.getByShowCode(showCode);
			if( childShows==null ){
				throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"犬展编号"+showCode+"未查到！");
			}
			mainShowSet.add(childShows.getMainShowId());
			mainShowId = childShows.getMainShowId();
		}

		if(mainShowSet.size()!=1){
			throw new ZAException(ZAErrorCode.ZA_ERC_UNKNOWN,"导入数据不属于同一场主犬展，请修改导入文件！");
		}
		//3,如果重复导入 覆盖数据
		if(dao.findCountByMainShowId(mainShowId)>=1){
			dao.deleteByMainShowId(mainShowId);
		}

		//4 所有犬展编号分割 查询是否这一批都 ---  属于统一主犬展
		for(int i=0;i<list.size();i++){
			ShowReportScore showReportScore =  list.get(i);
			String showCodeStr = showReportScore.getShowCode();
			if(StringUtils.isNotBlank(showCodeStr)){
				String[] codeArr = showCodeStr.split(",");
				for(String realShowCode : codeArr){
					ChildShows childShows = childShowsService.getByShowCode(realShowCode);
					showReportScore.setMainShowId(childShows.getMainShowId());
					showReportScore.setShowCode(realShowCode);
					showReportScore.setJudgeId(childShows.getReferee());
					ShowReportScore insert = (ShowReportScore) showReportScore.clone();
					insert.setDogYearGroup(DictUtils.getDictValue(insert.getDogYearGroup(),"show_age_group","0"));
					super.save(insert);
				}
			}
		}


	}
	
}