/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.show.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.common.persistence.DataEntity;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 赛事规范Entity
 * @author wj
 * @version 2020-07-10
 */
public class CkuMatchRule extends DataEntity<CkuMatchRule> {

	private static final long serialVersionUID = 1L;
	private String ruleName;		// rule_name
	private String ruleInfo;		// rule_info
	private Date createTime;		// create_time
	private String code;		// 序号
	private String type;		// 类型： cku、ckumc、 ckudc
	private String typeArr[];		// 类型： cku、ckumc、 ckudc

	public String[] getTypeArr() {
		return typeArr;
	}

	public void setTypeArr(String[] typeArr) {
		this.typeArr = typeArr;
	}

	public CkuMatchRule() {
		super();
	}

	public CkuMatchRule(String id){
		super(id);
	}

	@Length(min=0, max=50, message="rule_name长度必须介于 0 和 50 之间")
	public String getRuleName() {
		return ruleName;
	}

	public void setRuleName(String ruleName) {
		this.ruleName = ruleName;
	}

	public String getRuleInfo() {
		return ruleInfo;
	}

	public void setRuleInfo(String ruleInfo) {
		this.ruleInfo = ruleInfo;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	@Length(min=1, max=16, message="序号长度必须介于 1 和 16 之间")
	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Length(min=1, max=16, message="类型： cku、ckumc、 ckudc长度必须介于 0 和 16 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

}