package com.cku.oa.shop.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.shop.entity.ShopSaleChannel;
import com.cku.oa.shop.service.ShopSaleChannelService;

/**
 * 商品销售渠道Controller
 * @author lyy
 * @version 2016-08-15
 */
@Controller
@RequestMapping(value = "${adminPath}/shop/shopSaleChannel")
public class ShopSaleChannelController extends BaseController {

	@Autowired
	private ShopSaleChannelService shopSaleChannelService;
	
	@ModelAttribute
	public ShopSaleChannel get(@RequestParam(required=false) String id) {
		ShopSaleChannel entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = shopSaleChannelService.get(id);
		}
		if (entity == null){
			entity = new ShopSaleChannel();
		}
		return entity;
	}
	
	@RequiresPermissions("shop:shopSaleChannel:view")
	@RequestMapping(value = {"list", ""})
	public String list(ShopSaleChannel shopSaleChannel, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<ShopSaleChannel> page = shopSaleChannelService.findPage(new Page<ShopSaleChannel>(request, response), shopSaleChannel); 
		model.addAttribute("page", page);
		return "oa/shop/shopSaleChannelList";
	}

	@RequiresPermissions("shop:shopSaleChannel:view")
	@RequestMapping(value = "form")
	public String form(ShopSaleChannel shopSaleChannel, Model model) {
		model.addAttribute("shopSaleChannel", shopSaleChannel);
		return "oa/shop/shopSaleChannelForm";
	}

	@RequiresPermissions("shop:shopSaleChannel:view")
	@RequestMapping(value = "view")
	public String view(ShopSaleChannel shopSaleChannel, Model model) {
		model.addAttribute("shopSaleChannel", shopSaleChannel);
		return "oa/shop/shopSaleChannelView";
	}
	@RequiresPermissions("shop:shopSaleChannel:view")
	@RequestMapping(value = "save")
	public String save(ShopSaleChannel shopSaleChannel, Model model, RedirectAttributes redirectAttributes) {
		boolean hasPermission = false;
		if(!StringUtils.isEmpty(shopSaleChannel.getId())){
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoods:edit");
		}else{
			hasPermission = SecurityUtils.getSubject().isPermitted("shop:shopGoods:add");
		}
		if(hasPermission){
			if (!beanValidator(model, shopSaleChannel)){
				return form(shopSaleChannel, model);
			}
			shopSaleChannelService.save(shopSaleChannel);
			addMessage(redirectAttributes, "保存销售渠道成功");
		}else{
			throw new UnauthenticatedException();
		}
		return "redirect:"+Global.getAdminPath()+"/shop/shopSaleChannel/?repage";
	}
	
	@RequiresPermissions("shop:shopSaleChannel:delete")
	@RequestMapping(value = "delete")
	public String delete(ShopSaleChannel shopSaleChannel, RedirectAttributes redirectAttributes) {
		shopSaleChannelService.delete(shopSaleChannel);
		addMessage(redirectAttributes, "删除销售渠道成功");
		return "redirect:"+Global.getAdminPath()+"/shop/shopSaleChannel/?repage";
	}
	@RequiresPermissions("shop:shopSaleChannel:export")
	@RequestMapping("export")
	public String export(ShopSaleChannel shopSaleChannel,HttpServletResponse response, RedirectAttributes redirectAttributes){
		try {
			shopSaleChannelService.export(shopSaleChannel,response);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导出销售渠道失败！失败信息："+e.getMessage());
		}
		return null;
	}
	@RequiresPermissions("shop:shopSaleChannel:import")
	@RequestMapping(value = "import", method= RequestMethod.POST)
	public String importFile(MultipartFile file, RedirectAttributes redirectAttributes) {
		try {
			shopSaleChannelService.importChannel(file);
		} catch (Exception e) {
			addMessage(redirectAttributes, "导入销售渠道失败！失败信息："+e.getMessage());
		}
		return "redirect:"+Global.getAdminPath()+"/shop/shopSaleChannel/?repage";
	}
}