package com.cku.oa.kennel.web;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.entity.KennelAlliance;
import com.cku.oa.kennel.service.KennelAllianceService;
import com.cku.oa.kennel.service.KennelService;
import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

/**
 * 犬舍联盟Controller
 * @author lgl
 * @version 2016-09-03
 */
@Controller
@RequestMapping(value = "${adminPath}/kennel/kennelAlliance")
public class KennelAllianceController extends BaseController {
	
	private final static String REPAGE = "redirect:"+Global.getAdminPath()+"/kennel/kennelAlliance/?repage";
	
	private final static String AUTHORITY_PRDFIX = "kennel:kennelAlliance:";

	@Autowired
	private KennelAllianceService kennelAllianceService;
	@Autowired
	private KennelService kennelService;
	
	@ModelAttribute
	public KennelAlliance get(@RequestParam(required=false) String id) {
		KennelAlliance entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = kennelAllianceService.get(id);
		}
		if (entity == null){
			entity = new KennelAlliance();
		}
		return entity;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = {"list", ""})
	public String list(KennelAlliance kennelAlliance, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<KennelAlliance> page = kennelAllianceService.findPage(new Page<KennelAlliance>(request, response), kennelAlliance); 
		model.addAttribute("page", page);
		return "oa/kennel/kennelAllianceList";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"view")
	@RequestMapping(value = "form")
	public String form(KennelAlliance kennelAlliance, Model model) {
		Kennel kennel = kennelService.getKennelByMemberCode(kennelAlliance.getMemberCode());
		if(kennel!=null){
			kennelAlliance.setKennel(kennel);
		}
		model.addAttribute("kennelAlliance", kennelAlliance);
		return "oa/kennel/kennelAllianceForm";
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"delete")
	@RequestMapping(value = "delete")
	public String delete(KennelAlliance kennelAlliance, RedirectAttributes redirectAttributes) {
		kennelAllianceService.delete(kennelAlliance);
		addMessage(redirectAttributes, "删除犬舍联盟成功");
		return REPAGE;
	}

	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "setMemberInfo")
	@ResponseBody
	public Map<String,Object> setMemberInfo(String memberCode){
		Map<String,Object> map = null;
		try {
			map = kennelAllianceService.setMemberInfo(memberCode);
		} catch (Exception e) {
			logger.warn("查询会员信息出错",e);
		}
		return map;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"add")
	@RequestMapping(value = "add")
	public String add(KennelAlliance kennelAlliance, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, kennelAlliance)){
			return form(kennelAlliance, model);
		}
		kennelAllianceService.add(kennelAlliance);
		addMessage(redirectAttributes, "保存犬舍联盟成功");
		return REPAGE;
	}
	
	@RequiresPermissions(AUTHORITY_PRDFIX+"edit")
	@RequestMapping(value = "edit")
	public String edit(KennelAlliance kennelAlliance, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, kennelAlliance)){
			return form(kennelAlliance, model);
		}
		kennelAllianceService.edit(kennelAlliance);
		addMessage(redirectAttributes, "保存犬舍联盟成功");
		return REPAGE;
	}
}