/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.groomer.entity;

import org.hibernate.validator.constraints.Length;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容考试题表Entity
 * @author hjx
 * @version 2023-11-23
 */
public class GroomerExamQuestions extends DataEntity<GroomerExamQuestions> {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 试卷id
	 */
	private String examPaperId;

	/**
	 * 考题id
	 */
	private String questionId;

	/**
	 * 考题内容
	 */
	private String questionContent;

	/**
	 * 考题类型
	 */
	private String questionType;

	/**
	 * 答案
	 */
	private String answer;

	/**
	 * 考生选择的选项(只做展示)
	 */
	private String selectOptionId;

	private List<GroomerExamQuestionsOptions> groomerExamQuestionsOptionsList;
	
	public GroomerExamQuestions() {
		super();
	}

	public GroomerExamQuestions(String id){
		super(id);
	}

	@Length(min=1, max=4, message="试卷id长度必须介于 1 和 4 之间")
	public String getExamPaperId() {
		return examPaperId;
	}

	public void setExamPaperId(String examPaperId) {
		this.examPaperId = examPaperId;
	}
	
	@Length(min=1, max=64, message="考题id长度必须介于 1 和 64 之间")
	public String getQuestionId() {
		return questionId;
	}

	public void setQuestionId(String questionId) {
		this.questionId = questionId;
	}
	
	@Length(min=1, max=255, message="考题内容长度必须介于 1 和 255 之间")
	public String getQuestionContent() {
		return questionContent;
	}

	public void setQuestionContent(String questionContent) {
		this.questionContent = questionContent;
	}
	
	@Length(min=1, max=2, message="考题类型长度必须介于 1 和 2 之间")
	public String getQuestionType() {
		return questionType;
	}

	public void setQuestionType(String questionType) {
		this.questionType = questionType;
	}
	
	@Length(min=1, max=64, message="答案长度必须介于 1 和 64 之间")
	public String getAnswer() {
		return answer;
	}

	public void setAnswer(String answer) {
		this.answer = answer;
	}

	public List<GroomerExamQuestionsOptions> getGroomerExamQuestionsOptionsList() {
		return groomerExamQuestionsOptionsList;
	}

	public void setGroomerExamQuestionsOptionsList(List<GroomerExamQuestionsOptions> groomerExamQuestionsOptionsList) {
		this.groomerExamQuestionsOptionsList = groomerExamQuestionsOptionsList;
	}

	public String getSelectOptionId() {
		return selectOptionId;
	}

	public void setSelectOptionId(String selectOptionId) {
		this.selectOptionId = selectOptionId;
	}

}