package com.cku.oa.finance.dao.statistics;

import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 订单详情查询
 * @author xuzhenxing
 *
 */
@MyBatisDao

public interface OrderDetailsDao {
	/**
	 * 订单详情页订单号、会员号
	 * @param orderCode
	 * @param ID
	 * @return
	 */
	Map orderHead(@Param("orderID")String orderID,@Param("orderCode")String orderCode);
	
	/**
	 * 订单详情页订单详情
	 * @param orderCode
	 */
	List<Map> orderBody(@Param("orderCode")String orderCode);
	/**
	 * 犬舍更名
	 * @param orderCode
	 * @return
	 */
	List<Map> kennelRename(@Param("orderCode")String orderCode);
	
	/**
	 * 犬舍主理人变更
	 * @param orderCode
	 * @return
	 */
	List<Map> kennelOwnerChange(@Param("orderCode")String orderCode);
	
	/**
	 * 配种证明
	 * @param orderCode
	 * @return
	 */
	List<Map> dogNew(@Param("orderCode")String orderCode);
	
	/**
	 * 国外证书换发
	 * @param orderCode
	 * @return
	 */
	List<Map> dogOverseasPedigreeChange(@Param("orderCode")String orderCode);
	
	/**
	 * 国外证书出口
	 * @param orderCode
	 * @return
	 */
	List<Map> dogPedigreeExport(@Param("orderCode")String orderCode);
	
	/**
	 * 犬只鉴定
	 * @param orderCode
	 * @return
	 */
	List<Map> dogAppraisal(@Param("orderCode")String orderCode);
	
	/**
	 * DNA存档
	 * @param orderCode
	 * @return
	 */
	List<Map> dogDNAArchive(@Param("orderCode")String orderCode);
	
	/**
	 * 犬主变更
	 * @param orderCode
	 * @return
	 */
	List<Map> dogOwnerChange(@Param("orderCode")String orderCode);
	
	/**
	 * 证书补做
	 * @param orderCode
	 * @return
	 */
	List<Map> dogPedigreeRedo(@Param("orderCode")String orderCode);
	
	/**
	 * 血统证书登记费
	 * @param orderCode
	 * @return
	 */
	List<Map> dogChip(@Param("orderCode")String orderCode);
	
	/**
	 * 芯片更换
	 * @param orderCode
	 * @return
	 */
	List<Map> dogChipChange(@Param("orderCode")String orderCode);
	
	/**
	 * 赛事报名
	 * @param orderCode
	 * @return
	 */
	List<Map> showApply(@Param("orderCode")String orderCode);

	/**
	 * 新生幼犬登记（出生纸）
	 * @param orderCode
	 * @return
	 */
	List<Map> dogNewBornAndBirth(@Param("orderCode")String orderCode);
	
	/**
	 * 冠军登录
	 * @param orderCode
	 * @return
	 */
	List<Map> showChampion(@Param("orderCode")String orderCode);
	
	/**
	 * 其他类型
	 * @param orderCode
	 * @return
	 */
	List<Map> others(@Param("orderCode")String orderCode,@Param("chargeItemID")String chargeItemID);
}
