package com.cku.oa.dog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.dog.entity.DogNoseMock;
import com.cku.oa.dog.service.DogNoseMockService;

/**
 * 鼻纹模拟Controller
 * @author yuanshuai
 * @version 2023-08-14
 */
@Controller
@RequestMapping(value = "${adminPath}/dog/dogNoseMock")
public class DogNoseMockController extends BaseController {

	@Autowired
	private DogNoseMockService dogNoseMockService;
	
	@ModelAttribute
	public DogNoseMock get(@RequestParam(required=false) String id) {
		DogNoseMock entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = dogNoseMockService.get(id);
		}
		if (entity == null){
			entity = new DogNoseMock();
		}
		return entity;
	}
	
	@RequiresPermissions("dog:dogNoseMock:view")
	@RequestMapping(value = {"list", ""})
	public String list(DogNoseMock dogNoseMock, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<DogNoseMock> page = dogNoseMockService.findPage(new Page<DogNoseMock>(request, response), dogNoseMock); 
		model.addAttribute("page", page);
		return "oa/dog/dogNoseMockList";
	}

	@RequiresPermissions("dog:dogNoseMock:view")
	@RequestMapping(value = "form")
	public String form(DogNoseMock dogNoseMock, Model model) {
		model.addAttribute("dogNoseMock", dogNoseMock);
		return "oa/dog/dogNoseMockForm";
	}

	@RequiresPermissions("dog:dogNoseMock:edit")
	@RequestMapping(value = "save")
	public String save(DogNoseMock dogNoseMock, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, dogNoseMock)){
			return form(dogNoseMock, model);
		}
		dogNoseMockService.save(dogNoseMock);
		addMessage(redirectAttributes, "保存鼻纹模拟成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogNoseMock/?repage";
	}
	
	@RequiresPermissions("dog:dogNoseMock:edit")
	@RequestMapping(value = "delete")
	public String delete(DogNoseMock dogNoseMock, RedirectAttributes redirectAttributes) {
		dogNoseMockService.delete(dogNoseMock);
		addMessage(redirectAttributes, "删除鼻纹模拟成功");
		return "redirect:"+Global.getAdminPath()+"/dog/dogNoseMock/?repage";
	}

}