package com.cku.oa.dog.service;

import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.cku.oa.dog.entity.DogTypeShow;
import com.cku.oa.dog.dao.DogTypeShowDao;

/**
 * 赛事犬种Service
 * @author yuanshuai
 * @version 2018-03-27
 */
@Service
@Transactional(readOnly = true)
public class DogTypeShowService extends CrudService<DogTypeShowDao, DogTypeShow> {

	public DogTypeShow get(String id) {
		return super.get(id);
	}
	
	public List<DogTypeShow> findList(DogTypeShow dogTypeShow) {
		return super.findList(dogTypeShow);
	}
	
	public Page<DogTypeShow> findPage(Page<DogTypeShow> page, DogTypeShow dogTypeShow) {
		return super.findPage(page, dogTypeShow);
	}
	
	@Transactional(readOnly = false)
	public void save(DogTypeShow dogTypeShow) {
		super.save(dogTypeShow);
	}
	
	@Transactional(readOnly = false)
	public void delete(DogTypeShow dogTypeShow) {
		super.delete(dogTypeShow);
	}

	/**
	 * @Description： 获取赛事犬种数据列表并将showEnName拼接为：编号-中文名-英文名的形式
	 * @author: yuanshuai
	 * @date: 2018/3/27 14:45
	 */
	public List<DogTypeShow> findAllList() {
		List<DogTypeShow> list = dao.findAllList(new DogTypeShow());
		for (DogTypeShow dogTypeShow : list) {
			dogTypeShow.setShowEnName(dogTypeShow.getDogShowCode() + "-" + dogTypeShow.getShowCnName() + "-" + dogTypeShow.getShowEnName());
		}
		return list;
	}

	/**
	 * @Description： 根据繁殖犬种获取赛事犬种列表并将showEnName拼接为：编号-中文名-英文名的形式
	 * @author: yuanshuai
	 * @date: 2018/3/27 14:47
	 */
	public List<DogTypeShow> findListByDogBreed(String dogBreed) {
		DogTypeShow entity = new DogTypeShow();
		entity.setDogBreedCode(dogBreed);
		List<DogTypeShow> list = dao.findList(entity);
		for (DogTypeShow dogTypeShow : list) {
			dogTypeShow.setShowEnName(dogTypeShow.getDogShowCode() + "-" + dogTypeShow.getShowCnName() + "-" + dogTypeShow.getShowEnName());
		}
		return list;
	}

	/**
	 * @Description： 根据FCI赛事编码查询赛事犬种
	 * @author: yuanshuai
	 * @date: 2018/3/27 15:51
	 */
	public DogTypeShow getByDogShowCode(String dogBreedCode) {
		return dao.getByDogShowCode(dogBreedCode);
	}
}