package com.cku.oa.dog.service;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.oa.dog.dao.DogStickerDao;
import com.cku.oa.dog.entity.DogSticker;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;

/**
 * 犬只贴纸Service
 *
 * @author lgl
 * @version 2018-11-26
 */
@Service
@Transactional(readOnly = true)
public class DogStickerService extends CrudService<DogStickerDao, DogSticker> {

	public DogSticker get(String id) {
		return super.get(id);
	}

	public List<DogSticker> findList(DogSticker dogSticker) {
		return super.findList(dogSticker);
	}

	public Page<DogSticker> findPage(Page<DogSticker> page, DogSticker dogSticker) {
		return super.findPage(page, dogSticker);
	}

	@Transactional(readOnly = false)
	public void save(DogSticker dogSticker) {
		super.save(dogSticker);
	}

	@Transactional(readOnly = false)
	public void delete(DogSticker dogSticker) {
		super.delete(dogSticker);
	}

	public DogSticker getDogStickerByIdentificationFlagByOne(String identificationFlag) {
		return dao.getByIdentificationFlagByOne(identificationFlag);
	}
	// public List<DogSticker> getDogStickerByIdentificationFlag(String
	// identificationFlag) {
	// return dao.getByIdentificationFlag(identificationFlag);
	// }

	public String getSticker(DogSticker sticker) {
		String grade = "";
		if (sticker == null || StringUtils.isBlank(sticker.getStickerClass())) {
			return grade;
		}
		switch (sticker.getStickerClass()) {
		case "1":
			grade = "纯种级";
			break;
		case "2":
			grade = "纯血级";
			break;
		case "3":
			grade = "赛级";
			break;
		case "4":
			grade = "冠军级";
			break;
		default:
			break;
		}
		return grade;
	}

}