/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.dog.dao;

import java.util.List;
import java.util.Map;

import com.cku.oa.dog.entity.DogType;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;
import org.apache.ibatis.annotations.Param;

/**
 * 犬只种类DAO接口
 * @author zhuoHeng
 * @version 2016-07-21
 */
@MyBatisDao
public interface DogTypeDao extends CrudDao<DogType> {
	
	public DogType getByDogBreedCode(String dogBreedCode);

	public List<DogType> codeCheck(String dogBreedCode);

	List<DogType> getInDogBreedList(Map map);

	List<DogType> findSingOrgDogTypeList(@Param("orgId") String orgId);
	
	List<DogType> findFormalAndNBList(DogType entity);
}