package com.cku.oa.banner.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.banner.entity.AppSplashAds;
import com.cku.oa.banner.service.AppSplashAdsService;

/**
 * 开屏广告配置Controller
 * @author xx
 * @version 2023-08-07
 */
@Controller
@RequestMapping(value = "${adminPath}/banner/appSplashAds")
public class AppSplashAdsController extends BaseController {

	@Autowired
	private AppSplashAdsService appSplashAdsService;
	
	@ModelAttribute
	public AppSplashAds get(@RequestParam(required=false) String id) {
		AppSplashAds entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = appSplashAdsService.get(id);
		}
		if (entity == null){
			entity = new AppSplashAds();
		}
		return entity;
	}
	
	@RequiresPermissions("banner:appSplashAds:view")
	@RequestMapping(value = {"list", ""})
	public String list(AppSplashAds appSplashAds, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<AppSplashAds> page = appSplashAdsService.findPage(new Page<AppSplashAds>(request, response), appSplashAds); 
		model.addAttribute("page", page);
		return "oa/banner/appSplashAdsList";
	}

	@RequiresPermissions("banner:appSplashAds:view")
	@RequestMapping(value = "form")
	public String form(AppSplashAds appSplashAds, Model model) {
		model.addAttribute("appSplashAds", appSplashAds);
		return "oa/banner/appSplashAdsForm";
	}

	@RequiresPermissions("banner:appSplashAds:edit")
	@RequestMapping(value = "save")
	public String save(AppSplashAds appSplashAds, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, appSplashAds)){
			return form(appSplashAds, model);
		}
		appSplashAdsService.save(appSplashAds);
		addMessage(redirectAttributes, "保存开屏广告配置成功");
		return "redirect:"+Global.getAdminPath()+"/banner/appSplashAds/?repage";
	}
	
	@RequiresPermissions("banner:appSplashAds:edit")
	@RequestMapping(value = "delete")
	public String delete(AppSplashAds appSplashAds, RedirectAttributes redirectAttributes) {
		appSplashAdsService.delete(appSplashAds);
		addMessage(redirectAttributes, "删除开屏广告配置成功");
		return "redirect:"+Global.getAdminPath()+"/banner/appSplashAds/?repage";
	}

}