package com.initSplit;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.cku.oa.sync.dao.VoucherSyncLogDao;
import com.cku.oa.sync.entity.VoucherSyncLog;
import com.cku.oa.sys.entity.MemberSyncTask;
import com.cku.oa.sys.service.MemberSyncTaskService;
import com.ufida.api.request.VoucherAddRequest;
import com.ufida.api.response.UfidaSyncResponse;
import com.ufida.api.service.UfidaBaseInfoSyncService;
import com.ufida.api.service.UfidaVoucherSyncService;
import com.ufida.api.service.VoucherQueryService;
import com.ufida.api.vo.CustomerVo;

//@RunWith(SpringJUnit4ClassRunner.class)
//@WebAppConfiguration
//@ContextConfiguration({ "classpath*:/spring-context*.xml" })
public class VoucherAddTest {

	@Autowired
	private VoucherQueryService voucherQueryService;
	
	@Autowired
	private UfidaBaseInfoSyncService ufidaBaseInfoSyncService;

	@Autowired
	private MemberSyncTaskService memberSyncTaskService;

	@Autowired
	private UfidaVoucherSyncService syncService;

	@Autowired
	private VoucherSyncLogDao voucherSyncLogDao;

	private static final Integer VOUCHER_TYPE_CZ = 1;// 充值

	private static final Integer VOUCHER_TYPE_DD = 2;// 订单

	private static final Integer VOUCHER_TYPE_TK = 3;// 退款

	private static final Integer VOUCHER_TYPE_ZZ = 4;// 转账
	
	//@Test
	public void testBaseInfo() throws Exception {
		
		try {
			MemberSyncTask memberSyncTask = new MemberSyncTask();
			memberSyncTask.setSyncStatus("0");
			List<MemberSyncTask> findList = memberSyncTaskService.findList(memberSyncTask);
			for (MemberSyncTask temp : findList) {
				UfidaSyncResponse syncProject = ufidaBaseInfoSyncService
						.syncCustomer(new CustomerVo(temp.getMemberCode(), temp.getMemberName(),
								temp.getMemberName() + "(" + temp.getMemberCode() + ")", null));
				if (syncProject.success()) {
					temp.setSyncTime(new Date());
					temp.setSyncStatus("1");
					memberSyncTaskService.save(temp);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	//@Test
	public void testAddCZ() throws Exception {

		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		Date startDate = calendar.getTime();

		calendar.set(Calendar.HOUR_OF_DAY, 23);
		calendar.set(Calendar.MINUTE, 59);
		calendar.set(Calendar.SECOND, 59);
		Date endDate = calendar.getTime();

		VoucherSyncLog logEntity = new VoucherSyncLog(VOUCHER_TYPE_CZ, new Timestamp(startDate.getTime()),
				new Timestamp(endDate.getTime()), new Timestamp(System.currentTimeMillis()), false, "");
		VoucherAddRequest request = voucherQueryService.findRechargeVoucherData(startDate, endDate);
		if (request != null) {
			UfidaSyncResponse response = syncService.syncVoucher(request);
			logEntity.setSyncStatus(response.success());
			logEntity.setSyncFailReason(response.getMessage());
		}
		voucherSyncLogDao.insert(logEntity);
	}

	// @Test
	public void testAddDD() throws Exception {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		Date startDate = calendar.getTime();

		calendar.set(Calendar.HOUR_OF_DAY, 23);
		calendar.set(Calendar.MINUTE, 59);
		calendar.set(Calendar.SECOND, 59);
		Date endDate = calendar.getTime();
		VoucherSyncLog logEntity = new VoucherSyncLog(VOUCHER_TYPE_DD, new Timestamp(startDate.getTime()),
				new Timestamp(endDate.getTime()), new Timestamp(System.currentTimeMillis()), false, "");
		VoucherAddRequest request = voucherQueryService.findFinishedOrderVoucherData(startDate, endDate);
		if (request != null) {
			UfidaSyncResponse response = syncService.syncVoucher(request);
			logEntity.setSyncStatus(response.success());
			logEntity.setSyncFailReason(response.getMessage());
		}
		voucherSyncLogDao.insert(logEntity);
	}

	// @Test
	public void testRefund() throws Exception {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		Date startDate = calendar.getTime();

		calendar.set(Calendar.HOUR_OF_DAY, 23);
		calendar.set(Calendar.MINUTE, 59);
		calendar.set(Calendar.SECOND, 59);
		Date endDate = calendar.getTime();

		VoucherSyncLog logEntity = new VoucherSyncLog(VOUCHER_TYPE_TK, new Timestamp(startDate.getTime()),
				new Timestamp(endDate.getTime()), new Timestamp(System.currentTimeMillis()), false, "");
		VoucherAddRequest request = voucherQueryService.findRefundOrderVoucherData(startDate, endDate);
		if (request != null) {
			UfidaSyncResponse response = syncService.syncVoucher(request);
			logEntity.setSyncStatus(response.success());
			logEntity.setSyncFailReason(response.getMessage());
		}
		voucherSyncLogDao.insert(logEntity);
	}

	// @Test
	public void testPayOther() throws Exception {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		Date startDate = calendar.getTime();

		calendar.set(Calendar.HOUR_OF_DAY, 23);
		calendar.set(Calendar.MINUTE, 59);
		calendar.set(Calendar.SECOND, 59);
		Date endDate = calendar.getTime();

		VoucherSyncLog logEntity = new VoucherSyncLog(VOUCHER_TYPE_ZZ, new Timestamp(startDate.getTime()),
				new Timestamp(endDate.getTime()), new Timestamp(System.currentTimeMillis()), false, "");
		VoucherAddRequest request = voucherQueryService.findTransferVoucherData(startDate, endDate);
		if (request != null) {
			UfidaSyncResponse response = syncService.syncVoucher(request);
			logEntity.setSyncStatus(response.success());
			logEntity.setSyncFailReason(response.getMessage());
		}
		voucherSyncLogDao.insert(logEntity);
	}
}
