define(["knockout"],function(ko){
    return function(context){
    	var me = this;
    	me.memberName = ko.observable("");
    	me.lastNum = ko.observable("");
    	me.getLoginMemberMessage = function(){
    		var sendData = {};
    		util.sendAjax({
                url:'safe/memberCardInfo',
                data:sendData,
                async:true,
                loadFlag:true,
                type:'GET',
                cache:false,
                success:function(data){
                    if(data.rc==0){
                        me.memberName(data.memberCardInfo.name);
                    }else{
                        layer.msg("获取用户身份信息失败:"+data.msg);
                        window.location.href = "login.html#/accountsecurity/identityverificationfail";
                    }
                }
            });
    	};
    	me.next = function(){
    		if(util.isVal(me.lastNum())==""){
    			layer.msg("请填写身份证号");
    		} else {
    			var sendData = {};
                sendData["idCard"] = me.lastNum();
                util.sendAjax({
                    url:'safe/validateIDCard',
                    data:JSON.stringify(sendData),
                    async:true,
                    loadFlag:true,
                    type:'POST',
                    cache:false,
                    success:function(json){
                    	// console.log(json);
                        if(json.rc==0){
                        	if(json.authentication==1){
                        		window.location.href = "login.html#/accountsecurity/identityverificationsuccess";
                        	} else if(json.authentication==0){
                        		
                        	}
                        }else{
                            layer.alert("错误信息："+json.msg, {
                                title:"错误提示",
                                time: 0 //不自动关闭
                                ,btn: ['确认']
                                ,yes: function(index){
                                    layer.close(index);
                                }
                            });
                        }
                    }
                });	
    		}
    	}
    	$(function(){
    		me.getLoginMemberMessage();
    	})
    	context.app.loading(false);
    }
});