<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp" %>
<html>
<head>
    <title>犬只冷冻精子管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function () {
            //悬浮提示插件
            $(document).tooltip();
        });
        function page(n, s) {
            $("#pageNo").val(n);
            $("#pageSize").val(s);
            $("#searchForm").submit();
            return false;
        }
    </script>
</head>
<body>
<ul class="nav nav-tabs">
    <li class="active"><a href="${ctxDc}/dogFrozenSemen/list?businessType=1">种犬报备列表</a></li>
</ul>
<form:form id="searchForm" modelAttribute="dogFrozenSemen" action="${ctxDc}/dogFrozenSemen/list?businessType=1" method="post"
           class="breadcrumb form-search">
    <input name="businessType" type="hidden" value="1"/>
    <input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
    <input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
    <ul class="ul-form">
        <li><label>血统证书/芯片号：</label>
            <form:input path="pedigreeCertifiedAndDogChipLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>犬主姓名/会员号：</label>
            <form:input path="memberCodeAndMemberNameLike" htmlEscape="false" maxlength="64" class="input-medium"/>
        </li>
        <li><label>业务状态：</label>
            <form:select path="reviewState" class="input-medium">
                <form:option value="" label="全部"/>
                <form:option value="0" label="待审核"/>
                <form:option value="1" label="已通过"/>
                <form:option value="2" label="未通过"/>
            </form:select>
        </li>
        <li><label>申请日期：</label>
            <input name="createDateStart" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogFrozenSemen.createDateStart}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/> -
            <input name="createDateEnd" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate"
                   value="<fmt:formatDate value="${dogFrozenSemen.createDateEnd}" pattern="yyyy-MM-dd"/>"
                   onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
        </li>
        <li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
        <li class="clearfix"></li>
    </ul>
</form:form>
<sys:message content="${message}"/>
<table id="contentTable" class="table table-striped table-bordered table-condensed">
    <thead>
    <tr>
        <th>血统证书号</th>
        <th>芯片号</th>
        <th>犬种</th>
        <th>犬主人</th>
        <th>精子数量</th>
        <th>申请日期</th>
        <th>采集时间</th>
        <th>处理状态</th>
        <th>操作</th>
    </tr>
    </thead>
    <tbody>
    <c:forEach items="${page.list}" var="dogFrozenSemen">
        <tr>
            <td>
                    ${fns:escapeHtml(dogFrozenSemen.pedigreeCertified) }
            </td>
            <td>
                    ${fns:escapeHtml(dogFrozenSemen.dogChip) }
            </td>
            <td>
                    ${fns:escapeHtml(dogFrozenSemen.breedCnName) }
            </td>
            <td title="${fns:escapeHtml(dogFrozenSemen.memberCode)}">
                    ${fns:escapeHtml(dogFrozenSemen.memberName) }
            </td>
            <td>
                    ${fns:escapeHtml(dogFrozenSemen.semenNumber) }
            </td>
            <td>
                <fmt:formatDate value="${dogFrozenSemen.createDate }" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <fmt:formatDate value="${dogFrozenSemen.acquisitionTime }" pattern="yyyy-MM-dd"/>
            </td>
            <td>
                <c:if test="${dogFrozenSemen.reviewState=='0'||dogFrozenSemen.reviewState=='2'}">
                            ${fns:escapeHtml(dogFrozenSemen.businessState) }
                </c:if>
                <c:if test="${dogFrozenSemen.reviewState=='1'}">
                    ${fns:escapeHtml(dogFrozenSemen.businessState) }
                </c:if>
            </td>
            <td>
                <a href="${ctxDc}/dogFrozenSemen/form?id=${dogFrozenSemen.id}">详情</a>
            </td>
        </tr>
    </c:forEach>
    </tbody>
</table>
<div class="pagination">${page}</div>
</body>
</html>