<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>用户会员信息表管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//悬浮提示插件
			$(document).tooltip();
			resetTip();
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
		function memberPay(){
			layer.open({
	            type: 1,
	            title: "请输入会员号",
	            shadeClose: true,
	            area: ['300px', '150px'],
	            content: '<form id="memberFrom"  action="${ctxSchools}/schoolsMember/memberPay"><div>'+
	            '<span>会员号 :</span><input type="text" id="memberCode2" name="memberCode" ></span></div></form>'
	            ,btn: ['确定', '取消']
	    		,yes: function(index){
	    			var a = $("#memberCode2").val();
	    			if(a!=''){
	    				$("#memberFrom").submit();
			        }
	    		}
			});
		}
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="#">当前位置:会员管理</a></li>
	</ul>
	<form:form id="searchForm" modelAttribute="member" action="${ctxSchools}/schoolsMember/list" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-small"/>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="btns" style="float:right"><a class="btn btn-primary" onclick="memberPay()" href="#">会员缴费</a></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员编号</th>
				<th>姓名</th>
				<th>电话</th>
				<th>会员类型</th>
				<th>美容师会员类型</th>
				<th>美容师会员有效期</th>
				<th>美容师会员是否有效</th>
				<th>登记日期</th>
				<th>编辑</th>
				<th>删除</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="member">
			<tr>
				<td>
					${fns:escapeHtml(member.memberCode) }
				</td>
				<td>
					${fns:escapeHtml(member.name)}
				</td>
				<td>
					${fns:escapeHtml(member.mobile)}
				</td>
				<td>
					${fns:getDictLabels(member.memberType, 'user_member_type', '')}
				</td>
				<td>
					${fns:getDictLabels(member.groomerType, 'user_groomer_type', '无')}
				</td>
				<td>
					<fmt:formatDate value="${member.groomerEndDate}" pattern="yyyy-MM-dd"/>
						<c:if test="${member.groomerEndDate >date || member.groomerEndDate <date}">
							<a href="${ctxSchools}/payment/pay?memberCode=${member.memberCode}">续费</a>
						</c:if>
						<c:if test="${empty member.groomerEndDate}">
							<a href="${ctxSchools}/payment/pay?memberCode=${member.memberCode}">缴费</a>
						</c:if>
				</td>
				<td>
					<c:if test="${not empty member.groomerEndDate  && member.groomerEndDate  >date}">
						<font color="green">有效</font>
					</c:if>
					<c:if test="${empty member.groomerEndDate  || member.groomerEndDate <date}">
						<font color="red">无效</font>
					</c:if>
				</td>
				<td>
					<fmt:formatDate value="${member.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					<c:if test="${(empty member.groomerEndDate || member.groomerEndDate <date)&&member.registrant eq fns:getUser().name }">
    					<a href="${ctxSchools}/schoolsMember/edit?id=${member.id}">编辑</a>
    				</c:if>
				</td>
				<td>
					<c:if test="${empty member.groomerEndDate && member.registrant eq fns:getUser().name}">
						<a href="${ctxSchools}/schoolsMember/delete?id=${member.id}" onclick="return confirmx('确认要删除该用户会员吗？此操作不可回退!', this.href)">删除</a>
					</c:if>
				</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>