<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬只信息管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
						resetTip();
			$("#inputForm").validate({
				submitHandler: function(form){
					form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a >犬只信息${not empty clubDog.id?'修改':'添加'}</a></li>
	</ul><br/>
	<form:form id="inputForm" modelAttribute="clubDog" action="${ctxPartner}/clubDog/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">鉴定人：</label>
			<div class="controls">
				<form:input path="identifyer" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定编号：</label>
			<div class="controls">
				<form:input path="identifyCode" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">鉴定时间：</label>
 			<div class="controls">
				<input name="identifyTime" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${clubDog.identifyTime}" pattern="yyyy-MM-dd HH:mm:ss"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
                <font color="#FF0000">* </font>
			</div> 
		</div>
	<hr style="width:100%;height:2px;border:none;border-top:2px groove skyblue;" />
		<div class="control-group">
			<label class="control-label">芯片号：</label>
			<div class="controls">
				<form:input path="identificationFlag" onblur="chip()" htmlEscape="false" maxlength="15" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<script type="text/javascript">
			function chip(){
				var chipCode=$("#identificationFlag").val();
				if(chipCode==''){
					$.jBox.alert("芯片不可为空","提示");
					return false;
				}else if(chipCode.match(/^[0-9]*$/)){
					if(chipCode.length!=15){
						$.jBox.alert("芯片号必须为15位数字","提示");
						$("#identificationFlag").val("");
						return false;
					}else{
						$.ajax({
							type:"POST",
				            url: "${ctxPartner}/clubMember/checkChip",
				            data : {'xinpian2':chipCode},
				            dataType: 'json',
				            async: false, 
				            success: function(jsons){
				            	if (jsons.rc==1) {
									$.jBox.alert(jsons.msg,"提示");
									$("#identificationFlag").val("");
									return false;
								}
				            }
						});
					}
				}else{
					$.jBox.alert("芯片必须为数字","提示");
					$("#identificationFlag").val("");
					return false;
				}
			}
		</script>
		<div class="control-group">
			<label class="control-label">犬只中文名：</label>
			<div class="controls">
				<form:input path="nameCn" htmlEscape="false" maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬只英文名：</label>
			<div class="controls">
				<form:input path="nameEn" htmlEscape="false" maxlength="255" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:radiobuttons path="gender" items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false" class="required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬种：</label>
			<div class="controls">
                <form:select id="dogBreed" path="dogBreed" class="input-xlarge required" onchange="selectDogBreed()">
                    <form:option value="" label="请选择犬种"/>
                    <form:options items="${dogBreedList}" itemLabel="breedEnName" itemValue="dogBreedCode" htmlEscape="false"/>
                </form:select>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<script type="text/javascript">
			function selectDogBreed(){
				var dogBreed=$("#dogBreed").val();
				$.ajax({
					type:"GET",
		            url: "${ctxPartner}/clubDog/dogcolormark/getColormark",
		            data : {'dogBreed':dogBreed},
		            dataType: 'json',
		            async: false, 
		            success: function(jsons){
		            	console.log(jsons);
		            	if(jsons.rc==0){
		            		var data=jsons.list;
		                    $("#colorFlag").html("");
		            		$("#colorFlag").val("");
		                    $.each(data, function (i, item) {
		                        var num = i + 1;
		                        if (i == 0) {
		                            $("#colorFlag").append("<option value='' checked>" + "请选择毛色" + "</option>");
		                            $("#colorFlag").trigger("change")
		                        }
		                        $("#colorFlag").append("<option value='" + item.dogColorMarkCode + "'>" + item.dogColorMarkCn + "</option>");
		                    });
		            	}else{
		                    $("#colorFlag").html("");
		            		$("#colorFlag").val("");
		            		$.jBox.alert(jsons.msg); 
		            	}
		            }
				});
			}
		</script>
		<div class="control-group">
			<label class="control-label">毛色：</label>
			<div class="controls">
				<form:select id="colorFlag" path="colorFlag" class="input-xlarge required">
                </form:select>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthdate" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					value="<fmt:formatDate value="${clubDog.birthdate}" pattern="yyyy-MM-dd"/>"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:false});"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
	<hr style="width:100%;height:2px;border:none;border-top:2px groove skyblue;" />
		<div class="control-group">
			<label class="control-label">会员号：</label>
			<div class="controls">
				<form:input path="memberCode" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
                <input id="selectMember" class="btn btn-primary" value="查询" type="button" onclick="searchUser()"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<script type="text/javascript">
		function searchUser(){
			var memberCode=$("#memberCode").val();
			if (memberCode=='') {
				$.jBox.alert("请输入会员号!");
				return false;
			}
			$.ajax({
				type:"POST",
	            url: "${ctxPartner}/clubMember/search",
	            data : {'memberCode':memberCode},
	            dataType: 'json',
	            async: false, 
	            success: function(jsons){
	            	if(jsons.rc==1){
	            		$("#dogOwner").val("");
	            		$.jBox.alert(jsons.msg);
	            	}else{
	            		$("#dogOwner").val(jsons.name);
	            	}
	            }
			});
		}
		</script>
		<div class="control-group">
			<label class="control-label">犬主人：</label>
			<div class="controls">
				<form:input path="dogOwner" readonly="true" htmlEscape="false" maxlength="64" class="input-xlarge required"/>
                <font color="#FF0000">* </font>
			</div>
		</div>
		<div class="form-actions" style="float: left;width: 100%">
			<input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>