<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<%@page import="com.cku.oa.sys.entity.user.MemberCardTypeEnum"%>
<html>
<head>
	<title>会员信息</title>
	<meta name="decorator" content="default"/>
	<style type="text/css">
		.form-horizontal .control-label {
		    width: 110px!important;
		}
	</style>
	<script src="${ctxStatic}/jquery/jquery.form.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
				    form.submit();
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
			$("#btnSubmit").click(function(){
				$("#inputForm").ajaxSubmit({
			        dataType: 'json',
			        beforeSubmit: function(){
						if (!$("#inputForm").valid() || $(".error:visible").length > 0){
							return false;
						}
						else{
				            return true;
						}
			        },
			        success: function(data){
			            top.layer.msg(data.msg);
					    if(data.rc == 0){
							window.location = "${ctxPartner}/clubMember/list"
					    }
			        },  
			        error: function(err) { 
						top.layer.msg("操作失败!");           
			        }
				});
			});

			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			$("#area").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var html = "<option value='' code=''>请选择省份</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
						}
						$("#province").append(html);
					}else{
						layer.msg(json.msg);
					}
				}
			});

			$(".kennelClass").hide();

			$("#memberCardType").change(function(obj){
				if($(this).val() == "${MemberCardTypeEnum.PLATINUM_CARD.code()}" || $(this).val() == "${MemberCardTypeEnum.PURPLE_CARD.code()}"){
					$(".kennelClass").show();
					$("#kennelName").rules("add",{required:true,minlength:2,maxlength:4});
					$("#nameEn").rules("add",{required:true,minlength:3,maxlength:30});
					$("#fciName").rules("add",{required:true,minlength:3,maxlength:30});
					$("#fciNameBackup").rules("add",{minlength:3,maxlength:30});
				}else{
					$(".kennelClass").hide();
					$("#kennelName").rules("remove");
					$("#nameEn").rules("remove");
					$("#fciName").rules("remove");
					$("#fciNameBackup").rules("remove");
				}
			});

			$("#kennelName").blur(function(){
				var kennelName = encodeURI($("#kennelName").val());
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctxPartner}/clubMember/nameCheck?name="+kennelName,
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != 0){
	                		$("#nameError").html(data.msg);
							$("#nameError").show();
	                	}else{
	                		$("#nameError").hide();
	                	}
	                }
				})
			});

			$("#nameEn").blur(function(){
				validateEnName($(this).attr("id"),true);
			});

			$("#fciName").blur(function(){
				validateEnName($(this).attr("id"),true);
			});

			$("#fciNameBackup").blur(function(){
				validateEnName($(this).attr("id"),false);
			});

			function validateEnName(inputId,isValidBlank){
				$.ajax({
					type: "POST",
	                dataType:"json",
	                url:"${ctxPartner}/clubMember/nameEnCheck?isValidBlank="+isValidBlank+"&nameEn="+encodeURI($("#"+inputId).val()),
	                async: false,
	                error: function(request, textStatus, errorThrown) {
	                	$.jBox.alert("请求失败！");
	                },
	                success: function(data) {
	                	if(data.rc != 0){
	                		$("#"+inputId+"Error").html(data.msg);
	                		$("#"+inputId+"Error").show();
	                	}else{
	                		$("#"+inputId+"Error").hide();
	                	}
	                }
				})
			}
		});
	</script>
	<link rel="stylesheet" href="${ctxStatic }/modules/common/two-column.css"/>
</head>
<body>
	<h2>会员信息录入</h2>
	<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>
	<div style = "clear:both;"></div>
	<form:form id="inputForm" modelAttribute="member" action="${ctxPartner}/clubMember/save" method="post" class="form-horizontal">
		<form:hidden path="id"/>
		<form:hidden path="freezeFlag" value="0"/>
		<sys:message content="${message}"/>
		<div class="control-group">
			<label class="control-label">姓名：</label>
			<div class="controls">
				<form:input path="name" htmlEscape="false" maxlength="100" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
				<form:select path="gender" class="input-small required">
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('user_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<input name="birthday" type="text" readonly="readonly" maxlength="20" class="input-medium Wdate required"
					onclick="WdatePicker({dateFmt:'yyyy-MM-dd',isShowClear:true});"/>
					<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件类型：</label>
			<div class="controls">
				<form:select path="cardType" class="input-small required">
					<form:option value="身份证">身份证</form:option>
					<form:option value="护照">护照</form:option>
				</form:select>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">证件号：</label>
			<div class="controls">
				<form:input path="cardNo" htmlEscape="false" onBlur="checkCardNo()" maxlength="50" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkCardNo() {
					cardNo = $("#cardNo").val();
					memberSite = $("#memberSite").val();
					if (cardNo != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/cardNoCheck?param="+cardNo+"&memberSite="+memberSite,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("当前选择的站点下证件号已经存在!");
									$("#cardNo").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">手机：</label>
			<div class="controls">
				<form:input path="mobile" htmlEscape="false" onBlur="checkMobile()" maxlength="11" class="input-xlarge required isMobile"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkMobile() {
					mobile = $("#mobile").val();
					if (mobile != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/mobileCheck?param="+mobile,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("手机号已经存在!");
									$("#mobile").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮编：</label>
			<div class="controls">
				<form:input path="postcode" htmlEscape="false" maxlength="60" class="input-xlarge isZipCode" />
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">QQ：</label>
			<div class="controls">
				<form:input path="qq" htmlEscape="false" maxlength="50" class="input-xlarge isQq"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">固定电话：</label>
			<div class="controls">
				<form:input path="phone" htmlEscape="false" maxlength="200" class="input-xlarge isPhone"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">传真：</label>
			<div class="controls">
				<form:input path="fax" htmlEscape="false" maxlength="200" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮箱：</label>
			<div class="controls">
				<form:input path="email" htmlEscape="false" onBlur="checkEmail()" maxlength="200" class="input-xlarge email required"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<script type="text/javascript">
				function checkEmail() {
					email = $("#email").val();
					if (email != "") {
						$.ajax({
							type: "POST",
			                dataType:"json",
			                url:"${ctxPartner}/clubMember/emailCheck?param="+email,
			                async: false,
			                error: function(request, textStatus, errorThrown) {
			                    alert("请求失败！");
			                },
			                success: function(data) {
			                	if(data.rc == false){
			                		$.jBox.alert("邮箱已经存在!");
									$("#email").attr("value", '');
			                	}
			                }
						});
					}
				}
				</script>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">省：</label>
			<div class="controls">
				<form:select id="province" path="province" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">城市：</label>
			<div class="controls">
				<form:select id="city" path="city" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择城市</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
							}
							$("#city").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">区域：</label>
			<div class="controls">
				<form:select id="area" path="area" class="input-small required">
					<form:option value="" code=""></form:option>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<script>
			$("#city").change(function(){
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxArea}',
					data: {city_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var html = "<option value='' code=''>请选择区域</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].area+"'>"+lists[i].area+"</option>";
							}
							$("#area").append(html);
						}else{
							layer.msg(json.msg);
						}
					}
				});
			})
		</script>
		<div class="control-group">
			<label class="control-label">街道：</label>
			<div class="controls">
				<form:input path="street" htmlEscape="false" maxlength="200" class="input-xlarge required"/>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div style = "clear:both;"></div>

		<div class="control-group">
			<label class="control-label">会员类别：</label>
			<div class="controls">
				<form:select path="memberCardType" class="input-small required" style="width:150px;">
					<form:option value="">请选择</form:option>
					<form:options items="${fns:getDictListExcludeValues('member_card_type_club','foreign')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
				站点：
				<form:select path="memberSite" class="input-small">
					<c:if test="${empty orgSite}">
						<form:option value="">CKU会员</form:option>
					</c:if>
					<c:if test="${fn:contains(orgSite,1)}">
						<form:option value="">CKU会员</form:option>
						<form:option value="4">CKUDC会员</form:option>
					</c:if>
					<c:if test="${fn:contains(orgSite,2)}">
						<form:option value="6">CKUMC会员</form:option>
					</c:if>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">所属俱乐部：</label>
			<div class="controls">
				<form:input path="ckuClub" value="${fns:getUser().name}" htmlEscape="false" maxlength="100" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员开始日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly"  maxlength="20" class="input-medium "
					value="<fmt:formatDate value="${date}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">会员结束日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium"/>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍中文名：</label>
			<div class="controls">
				<form:input id="kennelName" path="kennel.name" htmlEscape="false" class="input-xlarge" />
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍英文名：</label>
			<div class="controls">
				<form:input id="nameEn" path="kennel.nameEn" htmlEscape="false" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="nameEnError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI英文名：</label>
			<div class="controls">
				<form:input id="fciName" path="kennel.fciName" htmlEscape="false" class="input-xlarge"/>
				<span class="help-inline"><font color="red">*</font> </span>
				<label id="fciNameError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍FCI备用名：</label>
			<div class="controls">
				<form:input id="fciNameBackup" path="kennel.fciNameBackup" htmlEscape="false" class="input-xlarge"/>
				<label id="fciNameBackupError" style="display:none" class="error"></label>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍开始日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" class="input-medium "
					value="<fmt:formatDate value="${date}" pattern="yyyy-MM-dd"/>"
					/>
			</div>
		</div>
		<div class="control-group kennelClass">
			<label class="control-label">犬舍结束日期：</label>
			<div class="controls">
				<input type="text" readonly="readonly" maxlength="20" class="input-medium"/>
			</div>
		</div>

		<HR style="FILTER: progid:DXImageTransform.Microsoft.Glow(color=#987cb9,strength=10)"  color=#987cb9 SIZE=1>

		<div class="control-group">
			<label class="control-label">邮寄 -证书类：</label>
			<div class="controls">
				<form:select path="deliveryCertified" class="input-small required " >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_certified')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">邮寄-通知类：</label>
			<div class="controls">
				<form:select path="deliveryNotice" class="input-small required" >
					<form:option value=""></form:option>
					<form:options items="${fns:getDictList('delivery_notice')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
				<span class="help-inline"><font color="red">*</font> </span>
			</div>
		</div>

		<div class="control-group">
			<label class="control-label">备注：</label>
			<div class="controls">
				<form:input path="remarks" htmlEscape="false"  maxlength="255" class="input-xlarge "/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">登记人：</label>
			<div class="controls">
				 <form:input path="registrant" htmlEscape="false"  maxlength="255" class="input-xlarge " readonly="true" value="${loginName}"/>
			 </div>
		 </div>
		<c:if test="${org.orgType == 'singleTypeClub'}">
		<div class="control-group">
			<label class="control-label">是否使用抵扣券：</label>
			<div class="controls">
				<form:radiobutton path="couponFlag" value="0" checked="true"/>否
				<c:if test="${availableNum != 0}">
					<form:radiobutton path="couponFlag" value="1"/>是<br/>
				</c:if>
				<br>
				&nbsp;&nbsp;&nbsp;抵扣券数量：共计${memberCouponNum}张，已用${couponNum}张，过期${overdueNum}张，可用${availableNum}张
			 </div>
		 </div>
		</c:if>

		<div style = "clear:both;"></div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="button" value="保 存"/>&nbsp;
			<input id="btnCancel" class="btn" type="button" value="返 回" onclick="history.go(-1)"/>
		</div>
	</form:form>
</body>
</html>