<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
<title>订单明细</title>
<meta name="decorator" content="default" />
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			document.getElementById("isOnSubmit").value = "1";
			$("#searchForm").submit();
        	return false;
        }
		
		function mySubmit()
		{	
			document.getElementById("isOnSubmit").value = "1";
			document.getElementById("searchForm").submit();
		}
	
		function SubmitByDate(date)
		{
			document.getElementById("isOnSubmit").value = "1";
			document.getElementById("nowDate").value=date;
			document.getElementById("searchForm").submit();
		}

	</script>
</head>
<body>
	<ul class="nav nav-tabs">
	 	<li class=""><a href="${ctx}/finance/statistics/revenue">财务收入</a></li> 
		<li class=""><a href="${ctx}/finance/statistics/charge">业务扣费</a></li>
		<li class="active"><a href="javascript:void(0)">业务扣费明细</a></li>
	</ul>
	<form id="searchForm" action="${ctx}/finance/statistics/orderList" method="post" class="breadcrumb form-search">
	<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<input id = "nowDate" name = "nowDate" type = "hidden" value = ""/>
		<input id = "isShowCoupon" name = "isShowCoupon" type = "hidden" value = "${isShowCoupon}"/>
		<input id = "isOnSubmit" name = "isOnSubmit" type = "hidden" value = "" onClick="mySubmit"/>
		<ul class="ul-form">
			<li style="width: 160px;">
				<input placeholder="订单编号" style="width: 120px;" id="orderCode" name="orderCode" type="text"	maxlength="23" value="${orderCode}"/>
			</li>
			<li style="width: 160px;">
				<input placeholder="会员号" style="width: 120px;" id="memberCode" name="memberCode" type="text" maxlength="10" value="${memberCode}"/>
			</li>
			<li style="width: 160px;">
				<input placeholder="会员名" style="width: 120px;" id="memberName" name="memberName" type="text" maxlength="10" value="${memberName}"/>
			</li>
			<li style="width: 160px;">
				<input placeholder="凭证号" style="width: 120px;" id="voucherCode" name="voucherCode"	type="text" maxlength="10" value="${voucherCode}"/>
			</li>
			<li style="width: 160px;">
				<input placeholder="项目标识" style="width: 120px;" id="projectID" name="projectID" type="text" maxlength="32" value="${projectID}"/>
			</li>
			<li style="width: 160px;">
				<input placeholder="金额" style="width: 120px;" id="totalPrice" name="totalPrice" type="text" maxlength="10" value="${totalPrice}" />
			</li>
		</ul>
		<ul class="ul-form">
			<li style="width: 323px;">
                <c:choose>
                    <c:when test="${isShowCoupon==1}">
                        <label style="margin: 0; text-align: left;">
                            优惠券收支类型：
                        </label>
                        <select id="chargingItemID" name="chargingItemID" style="width:200px;overflow:auto" tabindex="-1" class="select2-offscreen">
                            <option value="">全部</option>
                            <c:forEach items="${chargeCouponItemOption}" var="list">
                                <c:choose>
                                    <c:when test="${chargingItemID == list.id}">
                                        <option value="${list.id}" selected="selected">${list.name }</option>

                                    </c:when>
                                    <c:otherwise>
                                        <option value="${list.id}">${list.name }</option>
                                    </c:otherwise>
                                </c:choose>
                            </c:forEach>
                        </select>
                    </c:when>
                    <c:otherwise>
                        <label style="margin: 0; text-align: left;">
                            收支类型：
                        </label>
                        <select id="chargingItemID" name="chargingItemID" style="width:200px;overflow:auto" tabindex="-1" class="select2-offscreen">
                            <option value="">全部</option>
                            <c:forEach items="${chargeItemOption}" var="list">
                                <c:choose>
                                    <c:when test="${chargingItemID == list.id}">
                                        <option value="${list.id}" selected="selected">${list.name }</option>

                                    </c:when>
                                    <c:otherwise>
                                        <option value="${list.id}">${list.name }</option>
                                    </c:otherwise>
                                </c:choose>
                            </c:forEach>
                        </select>
                    </c:otherwise>
                </c:choose>
			</li>
			<li style="width: 318px;">
				<label style="text-align: left; margin: 0;">
					缴费状态：
				</label>			
				<select id="paymentState" name="paymentState"	class="input-small select2-offscreen" tabindex="-1">
					<c:choose>
						<c:when test="${paymentState==1}">
							<option value="">全部</option>
							<option value="1" selected="selected">未缴费</option>
							<option value="2">已缴费</option>
						</c:when>
						<c:when test="${paymentState==2}">
							<option value="">全部</option>
							<option value="1">未缴费</option>
							<option value="2" selected="selected">已缴费</option>
						</c:when>
						<c:otherwise>
							<option value="" selected="selected">全部</option>
							<option value="1">未缴费</option>
							<option value="2">已缴费</option>
						</c:otherwise>
					</c:choose>
				</select>
				</li>
				<li>
					<label style="margin: 0; text-align: left;">
						订单来源：
					</label>							
					<select id="orderType" name="orderType"	class="input-small select2-offscreen" style="box-sizing:120px;"	tabindex="-1">			
					<c:choose>
						<c:when test="${orderType == 'corp'}">
							<option value="">全部</option>
							<option value="corp" selected="selected">合作机构</option>
							<option value="member">会员中心</option>
							<option value="order">业务订单</option>
						</c:when>
						<c:when test="${orderType == 'member'}">
							<option value="">全部</option>
							<option value="corp">合作机构</option>
							<option value="member" selected="selected">会员中心</option>
							<option value="order">业务订单</option>
						</c:when>
						<c:when test="${orderType == 'order'}">
							<option value="">全部</option>
							<option value="corp">合作机构</option>
							<option value="member">会员中心</option>
							<option value="order" selected="selected">业务订单</option>
						</c:when>
						<c:otherwise>
							<option value="" selected="selected">全部</option>
							<option value="corp">合作机构</option>
							<option value="member">会员中心</option>
							<option value="order">业务订单</option>
						</c:otherwise>
					</c:choose>
				</select>
				</li>											
			</ul>		
			<ul class="ul-form">	
				<li style="width: 323px;">
					<label style="margin: 0; text-align: left;">
						开始时间：
					</label>
					<input style="width:160px;" id="startDate" name="startDate" type="text" readonly="readonly" maxlength="20" class="input-mini Wdate" value="${startDate}"	onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});" />
				</li>
				<li>
					<label style="width: 110px;margin: 0;text-align: left;">
						结束时间：
					</label>
					<input style="width:160px;" id="endDate" name="endDate" type="text" readonly="readonly"	maxlength="20" class="input-mini Wdate" value="${endDate}" onclick="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss',isShowClear:true});">
				</li>
				<li class="btns"><input id="btnSubmit" name="btnSubmit"	onClick = "mySubmit" class="btn btn-primary" type="submit" value="查询" />
				</li>
				<li class="clearfix"></li>
			</ul>
		</form>
		<hr	style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
			<p style="font-weight:bold;text-align:left;margin:0;border:none;padding:0">数量合计：${countOrder.countNum} 总计：${countOrder.countFee} 元</p>
		<hr	style="align=center;height:2px;border:none;border-top:2px groove skyblue;" />
		<table id="showResult"
		class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th style="text-align:center;">订单编号</th>
				<th style="text-align:center;">会员号</th>
				<th style="text-align:center;">会员名</th>
				<th style="text-align:center;">业务名称</th>
				<c:if test="${isShowCoupon==1}"><th style="text-align:center;">赛事编号</th></c:if>
				<th style="text-align:center;">单价</th>
				<th style="text-align:center;">数量</th>
				<th style="text-align:center;">总价</th>
				<th style="text-align:center;">标识</th>
				<th style="text-align:center;">凭证号</th>
				<th style="text-align:center;">时间</th>
				<th style="text-align:center;">缴费状态</th>			
				<th style="text-align:center;">操作</th>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${orderList}" var="orderList"> 
			<tr>			
				<td><a href="${ctx}/finance/statistics/orderDetails?orderCode=${orderList.order_code}">${fns:escapeHtml(orderList.order_code)}</a></td>
				<td>${fns:escapeHtml(orderList.member_code)}</td>
				<td>${fns:escapeHtml(orderList.name)}</td>				
				<td>${fns:escapeHtml(orderList.charging_item_name)}</td>
				<c:if test="${isShowCoupon==1}"><td>${fns:escapeHtml(orderList.show_code)}</td></c:if>
				<td>${fns:escapeHtml(orderList.price)}</td>
				<td>${fns:escapeHtml(orderList.num)}</td>
				<td>${fns:escapeHtml(orderList.total_price)}</td>
				<td>${fns:escapeHtml(orderList.project_id)}</td>
				<td>${fns:escapeHtml(orderList.voucher_code)}</td>
				<td>${fns:escapeHtml(orderList.add_time)}</td>
				<td>${fns:escapeHtml(orderList.payment_state)}</td>
				<td><a href="${ctx}/finance/statistics/orderDetails?orderID=${orderList.id}">详情</a></td>
			</tr>
		</c:forEach>		
		</tbody>
		</table>
			<div class="pagination">${page}</div>	
	</body>
</html>