<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬运动会员管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//省市区
			$("#province").empty().val("").select2();
			$("#city").empty().val("").select2();
			//访问省市区域
			$.ajax({
				url:'${ctxProvince}',
				data: {},
				async:true,
				loadFlag:true,
				type:'get',
				cache:false,
				success:function(json){
					if(json.rc==0){
						var option = "";
						var html = "<option value='' code=''>全部</option>";
						var lists = json.items;
						for(var i = 0;i<lists.length;i++){
							html+="<option value='"+lists[i].province+"' code='"+lists[i].provinceId+"'>"+lists[i].province+"</option>";
							if('${dogSportingMembers.province}'==lists[i].province) {
								option = lists[i].province;
							}
						}
						$("#province").append(html);
						$("#province").val(option).select2().change();
					}else{
						layer.msg(json.msg);
					}
				}
			});

			$("#province").change(function(){
				$("#city").empty().val("").select2();
				$("#area").empty().val("").select2();
				var code = $(this).find("option:selected").attr("code");
				$.ajax({
					url:'${ctxCity}',
					data: {province_code:code},
					async:true,
					loadFlag:true,
					type:'get',
					cache:false,
					success:function(json){
						if(json.rc==0){
							var option = "";
							var html = "<option value='' code=''>全部</option>";
							var lists = json.items;
							for(var i = 0;i<lists.length;i++){
								html+="<option value='"+lists[i].city+"' code='"+lists[i].cityId+"'>"+lists[i].city+"</option>";
								if('${dogSportingMembers.city}'==lists[i].city) {
									option = lists[i].city;
								}
							}
							$("#city").append(html);
							$("#city").val(option).select2().change();
						}else{
							layer.msg(json.msg);
						}
					}
				});
			});

			//导入
			$("#btnImport").click(function(){
				$.jBox($("#importBox").html(), {title:"会员导入", buttons:{"关闭":true},
					bottomText:"导入文件不能超过5M，仅允许导入“xls”或“xlsx”格式文件！"});
			});

			//显示导入错误提示
			var errorMsg = "${errorMsg}";
			var reg = new RegExp("##", "g")
			if (errorMsg != null && errorMsg != '' && typeof errorMsg != 'undefined') {
				alert(errorMsg.replace(reg, "\n"));
			}

			//导出
			$("#btnExport").click(function(){
				top.$.jBox.confirm("确认要导出会员信息吗？","系统提示",function(v,h,f){
					if(v=="ok"){
						$("#searchForm").attr("action","${ctx}/dogsporting/member/export");
						$("#searchForm").submit();
					}
				},{buttonsFocus:1});
				top.$('.jbox-body .jbox-icon').css('top','55px');
			});
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<div id="importBox" class="hide">
		<form id="importForm" action="${ctx}/dogsporting/member/import" method="post" enctype="multipart/form-data"
			  class="form-search" style="padding-left:20px;text-align:center;" onsubmit="loading('正在导入，请稍等...');"><br/>
			<input id="uploadFile" name="file" type="file" style="width:330px"/><br/><br/>　　
			<input id="btnImportSubmit" class="btn btn-primary" type="submit" value="   导    入   "/>
			<a href="${ctx}/dogsporting/member/import/template">下载模板</a>
		</form>
	</div>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/dogsporting/member/">犬运动会员列表</a></li>
		<shiro:hasPermission name="dogsporting:member:edit"><li><a href="${ctx}/dogsporting/member/editForm">犬运动会员添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="dogSportingMembers" action="${ctx}/dogsporting/member/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>会员号/姓名：</label>
				<form:input path="memberCode" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>会员类型：</label>
				<form:select path="memberType" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_sporting_member_type')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>电话：</label>
				<form:input path="mobile" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>省：</label>
				<form:select path="province" class="input-medium">
					<form:option value="" label="全部"/>
				</form:select>
			</li>
			<li><label>市：</label>
				<form:select path="city" class="input-medium">
					<form:option value="" label="全部"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<shiro:hasPermission name="dogsporting:member:import">
				<li class="btns"><input id="btnImport" class="btn btn-primary" type="button" value="导入会员信息"/></li>
			</shiro:hasPermission>
			<shiro:hasPermission name="dogsporting:member:export">
				<li class="btns"><button id="btnExport" type="button" class="btn btn-primary" >导出会员信息</button></li>
			</shiro:hasPermission>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>会员号</th>
				<th>会员姓名</th>
				<th>电话</th>
				<th>会员类型</th>
				<th>省</th>
				<th>市</th>
				<th>区</th>
				<shiro:hasPermission name="dogsporting:member:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="dogSportingMembers">
			<tr>
				<td>
					${dogSportingMembers.memberCode}
				</td>
				<td>
					${dogSportingMembers.name}
				</td>
				<td>
					${dogSportingMembers.mobile}
				</td>
				<td>
						${fns:getDictLabel(dogSportingMembers.memberType, 'dog_sporting_member_type', '')}
				</td>
				<td>
					${dogSportingMembers.province}
				</td>
				<td>
					${dogSportingMembers.city}
				</td>
				<td>
					${dogSportingMembers.area}
				</td>
				<td>
					<shiro:hasPermission name="dogsporting:member:view">
						<a href="${ctx}/dogsporting/member/viewForm?id=${dogSportingMembers.id}">查看</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogsporting:member:edit">
						<a href="${ctx}/dogsporting/member/editForm?id=${dogSportingMembers.id}">修改</a>
					</shiro:hasPermission>
					<shiro:hasPermission name="dogsporting:member:del">
					<a href="${ctx}/dogsporting/member/delete?id=${dogSportingMembers.id}"
					   onclick="return confirmx('确认要删除该犬运动会员吗？', this.href)">删除</a>
					</shiro:hasPermission>
				</td>

			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>