<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
    <title>冠军登录信息管理</title>
    <meta name="decorator" content="default"/>
    <script type="text/javascript">
        $(document).ready(function() {
            
        });
		function resolve(id){
			if(confirm('确认要处理该证书补做吗？')==false){
				return 0;
			}
			var data = {id:id};
			loading('正在处理，请稍等...');
			$.get("${ctx}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/resolve",data, function(json){
				closeLoading();
				location.reload();
			});
		}
    </script>
</head>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>原血统证书编号</th>
				<th>新血统证书编号</th>
				<th>犬主</th>
				<th>申请日期</th>
				<th>补做类型</th>
				<th>订单状态</th>
				<th>审核状态</th>
				<th>处理状态</th>
				<shiro:hasPermission name="dogpedigreecertifiedredo:dogPedigreeCertifiedRedo:edit">
				<th>操作</th>
				<th>打印</th>
				</shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${list}" var="dogPedigreeCertifiedRedo">
			<tr>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedRedo.originalPedigreeCertified)}
				</td>
				<td>
					${fns:escapeHtml(dogPedigreeCertifiedRedo.currentPedigreeCertified)}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedRedo.paymentMemberCode)}">
					${fns:escapeHtml(dogPedigreeCertifiedRedo.dogOwnerName)}
				</td>
				<td>
					<fmt:formatDate value="${dogPedigreeCertifiedRedo.createDate}" pattern="yyyy-MM-dd"/>
				</td>
				<td>
					${fns:getDictLabel(dogPedigreeCertifiedRedo.changeType, 'dog_pedigree_certified_redo_type', '')}
				</td>
				<td style="color:${dogPedigreeCertifiedRedo.paymentState=='2'?'#090':'#F00'}">
					${fns:getDictLabel(dogPedigreeCertifiedRedo.paymentState, 'user_payment_state', '')}
				</td>
				<td title="${fns:escapeHtml(dogPedigreeCertifiedRedo.reviewRemarks)}">
					<c:if test="${dogPedigreeCertifiedRedo.paymentState=='2'}">
					<c:choose>
						<c:when test="${dogPedigreeCertifiedRedo.reviewState=='0'}">
							<a style="color:#F00" onclick="review('${fns:escapeHtml(dogPedigreeCertifiedRedo.id)}')">${fns:getDictLabel(dogPedigreeCertifiedRedo.reviewState, 'dog_pedigree_certified_redo_review_state', '')}</a>
							<%-- <a href="${ctx}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/revoke?id=${dogPedigreeCertifiedRedo.id}" onclick="return confirmx('撤销后该业务将不能继续办理！确认撤销吗？', this.href)">撤销</a> --%>
						</c:when>
						<c:otherwise>
							${fns:getDictLabel(dogPedigreeCertifiedRedo.reviewState, 'dog_pedigree_certified_redo_review_state', '')}
						</c:otherwise>
					</c:choose>
					</c:if>
				</td>
				<td>
					<c:choose>
						<c:when test="${dogPedigreeCertifiedRedo.paymentState=='2'&&dogPedigreeCertifiedRedo.reviewState=='1'&&dogPedigreeCertifiedRedo.processState=='0'}">
							<a style="color:#F00" href="#"
							   onclick="resolve('${fns:escapeHtml(dogPedigreeCertifiedRedo.id)}')">
									${fns:getDictLabel(dogPedigreeCertifiedRedo.processState, 'proccess_state', '')}
							</a>
						</c:when>
						<c:when test="${dogPedigreeCertifiedRedo.processState=='1'}">
							${fns:getDictLabel(dogPedigreeCertifiedRedo.processState, 'proccess_state', '')}
						</c:when>
					</c:choose>
				</td>
				<shiro:hasPermission name="dogpedigreecertifiedredo:dogPedigreeCertifiedRedo:edit">
				<td>
					<c:if  test="${!dogPedigreeCertifiedRedo.businessRefundState}">
    						<a href="${ctx}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/form?id=${dogPedigreeCertifiedRedo.id}">修改</a>
						<a href="${ctx}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/delete?id=${dogPedigreeCertifiedRedo.id}" onclick="return confirmx('确认要删除该证书补做吗？', this.href)">删除</a>
					</c:if>
				</td>
				<td>
					<c:if test="${dogPedigreeCertifiedRedo.processState=='1'}">
						<a href="${ctx}/dogpedigreecertifiedredo/dogPedigreeCertifiedRedo/form?id=${dogPedigreeCertifiedRedo.id}">打印</a>
					</c:if>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</body>
</html>