<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>DNA血样留存管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			//$("#name").focus();
			$("#inputForm").validate({
				submitHandler: function(form){
					loading('正在提交，请稍等...');
					$.post('${ctx}/dogbloodsave/dogBloodSave/edit',
							$('#inputForm').serialize(),
							function(data) {
								if(data.rc==0){
									alert("修改成功！");
									parent.isYes = true;
									parent.layer.closeAll();
								}else{
									alert("审核失败,错误信息："+data.msg);
								}
							});
				},
				errorContainer: "#messageBox",
				errorPlacement: function(error, element) {
					$("#messageBox").text("输入有误，请先更正。");
					if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
						error.appendTo(element.parent().parent());
					} else {
						error.insertAfter(element);
					}
				}
			});
		});
	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="dogBloodSave" class="form-horizontal">
		<form:hidden path="id"/>
		<sys:message content="${message}"/>		
		<div class="control-group">
			<label class="control-label">出生证明编号：</label>
			<div class="controls">
					${dogBloodSave.birthCode}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">国外血统证书编号：</label>
			<div class="controls">
					${dogBloodSave.overseasPedigreeCertified}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬展鉴定编号：</label>
			<div class="controls">
					${dogBloodSave.showAppraisalCode}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">血统证书编号：</label>
			<div class="controls">
					${dogBloodSave.pedigreeCertified}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">犬名：</label>
			<div class="controls">
					${dogBloodSave.dogName}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">出生日期：</label>
			<div class="controls">
				<fmt:formatDate value="${dogBloodSave.dogBirthday}" pattern="yyyy-MM-dd"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">性别：</label>
			<div class="controls">
					${fns:getDictLabel(dogBloodSave.dogGender, 'dog_gender', '')}
			</div>
		</div>
		<div class="control-group">
			<label class="control-label">DNA血样编号：</label>
			<div class="controls">
				<form:input path="bloodSampleCode" htmlEscape="false" class="input-xlarge "/>
			</div>
		</div>
		<div class="form-actions">
			<shiro:hasPermission name="dogbloodsave:dogBloodSave:edit"><input id="btnSubmit" class="btn btn-primary" type="submit" value="保 存"/>&nbsp;</shiro:hasPermission>
		</div>
	</form:form>
</body>
</html>