<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>犬展成绩管理</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
		$(document).ready(function() {
			
		});
		function page(n,s){
			$("#pageNo").val(n);
			$("#pageSize").val(s);
			$("#searchForm").submit();
        	return false;
        }
	</script>
</head>
<body>
	<ul class="nav nav-tabs">
		<li class="active"><a href="${ctx}/contest/contestWinner/">犬展成绩列表</a></li>
		<shiro:hasPermission name="contest:contestWinner:edit"><li><a href="${ctx}/contest/contestWinner/form">犬展成绩添加</a></li></shiro:hasPermission>
	</ul>
	<form:form id="searchForm" modelAttribute="contestWinner" action="${ctx}/contest/contestWinner/" method="post" class="breadcrumb form-search">
		<input id="pageNo" name="pageNo" type="hidden" value="${page.pageNo}"/>
		<input id="pageSize" name="pageSize" type="hidden" value="${page.pageSize}"/>
		<ul class="ul-form">
			<li><label>秩序号：</label>
				<form:input path="exhibitNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>成绩编号：</label>
				<form:input path="code" htmlEscape="false" maxlength="32" class="input-medium"/>
			</li>
			<li><label>名次：</label>
				<form:input path="position" htmlEscape="false" maxlength="1" class="input-medium"/>
			</li>
			<li><label>性别：</label>
				<form:select path="gender" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('dog_gender')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li><label>年龄组别编号：</label>
				<form:input path="classNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>犬种编号：</label>
				<form:input path="breedNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>犬种组编号：</label>
				<form:input path="groupNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>子犬展编号：</label>
				<form:input path="contestNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>主犬展编号：</label>
				<form:input path="contestEventNo" htmlEscape="false" maxlength="11" class="input-medium"/>
			</li>
			<li><label>是否显示：</label>
				<form:select path="display" class="input-medium">
					<form:option value="" label="全部"/>
					<form:options items="${fns:getDictList('show_hide')}" itemLabel="label" itemValue="value" htmlEscape="false"/>
				</form:select>
			</li>
			<li class="btns"><input id="btnSubmit" class="btn btn-primary" type="submit" value="查询"/></li>
			<li class="clearfix"></li>
		</ul>
	</form:form>
	<sys:message content="${message}"/>
	<table id="contentTable" class="table table-striped table-bordered table-condensed">
		<thead>
			<tr>
				<th>秩序号</th>
				<th>成绩编号</th>
				<th>名次</th>
				<th>性别</th>
				<th>年龄组别编号</th>
				<th>犬种编号</th>
				<th>犬种组编号</th>
				<th>子犬展编号</th>
				<th>主犬展编号</th>
				<th>是否显示</th>
				<shiro:hasPermission name="contest:contestWinner:edit"><th>操作</th></shiro:hasPermission>
			</tr>
		</thead>
		<tbody>
		<c:forEach items="${page.list}" var="contestWinner">
			<tr>
				<td><a href="${ctx}/contest/contestWinner/form?id=${contestWinner.id}">
					${contestWinner.exhibitNo}
				</a></td>
				<td>
					${contestWinner.code}
				</td>
				<td>
					${contestWinner.position}
				</td>
				<td>
					${fns:getDictLabel(contestWinner.gender, 'dog_gender', '')}
				</td>
				<td>
					${contestWinner.classNo}
				</td>
				<td>
					${contestWinner.breedNo}
				</td>
				<td>
					${contestWinner.groupNo}
				</td>
				<td>
					${contestWinner.contestNo}
				</td>
				<td>
					${contestWinner.contestEventNo}
				</td>
				<td>
					${fns:getDictLabel(contestWinner.display, 'show_hide', '')}
				</td>
				<shiro:hasPermission name="contest:contestWinner:edit">
				<td>
    				<a href="${ctx}/contest/contestWinner/form?id=${contestWinner.id}">修改</a>
					<a href="${ctx}/contest/contestWinner/delete?id=${contestWinner.id}" onclick="return confirmx('确认要删除该犬展成绩吗？', this.href)">删除</a>
				</td>
				</shiro:hasPermission>
			</tr>
		</c:forEach>
		</tbody>
	</table>
	<div class="pagination">${page}</div>
</body>
</html>