<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.apache.shiro.web.filter.authc.FormAuthenticationFilter"%>
<%@ page import="java.util.ResourceBundle" %>
<%@ page import="com.thinkgem.jeesite.modules.sys.entity.Dict" %>
<%@ page import="java.util.List" %>
<%@ page import="com.thinkgem.jeesite.modules.sys.utils.DictUtils" %>
<%@ include file="/WEB-INF/views/include/taglib.jsp"%>
<html>
<head>
	<title>${fns:getConfig('productName')} 登录</title>
	<meta name="decorator" content="blank"/>
	<style type="text/css">
		html, body, table {
			width: 100%;
			text-align: center;
		}

		.form-signin-heading {
			font-family: Helvetica, Georgia, Arial, sans-serif, 黑体;
			font-size: 36px;
			margin-bottom: 20px;
			color: #0663a2;
		}

		.form-signin {
			position: relative;
			text-align: left;
			width: 300px;
			padding: 25px 29px 29px;
			margin: 0 auto 20px;
			background-color: #fff;
			border: 1px solid #e5e5e5;
			-webkit-box-shadow: 0 1px 2px rgba(0, 0, 0, .05);
			-moz-box-shadow: 0 1px 2px rgba(0, 0, 0, .05);
			box-shadow: 0 1px 2px rgba(0, 0, 0, .05);
		}

		.form-signin .checkbox {
			margin-bottom: 10px;
			color: #0663a2;
		}

		.form-signin .input-label {
			font-size: 16px;
			line-height: 23px;
			color: #999;
		}

		.form-signin .input-block-level {
			font-size: 16px;
			height: auto;
			margin-bottom: 15px;
			padding: 7px;
			*width: 283px;
			*padding-bottom: 0;
			_padding: 7px 7px 9px 7px;
		}

		.form-signin .btn.btn-large {
			font-size: 16px;
		}

		.form-signin #themeSwitch {
			position: absolute;
			right: 15px;
			bottom: 10px;
		}

		.form-signin div.validateCode {
			padding-bottom: 15px;
		}

		.mid {
			vertical-align: middle;
		}

		.header {
			height: 80px;
			padding-top: 20px;
		}

		.alert {
			position: relative;
			width: 300px;
			margin: 0 auto;
			*padding-bottom: 0px;
		}

		label.error {
			background: none;
			width: 270px;
			font-weight: normal;
			color: inherit;
			margin: 0;
		}

		body {
			background: #f4f4f4 url(${ctxStatic}/images/bg.gif) repeat top left;
		}

		#login {
			margin: 50px auto;
			width: 400px;
		}

		#login h2 {
			background-color: rgb(47, 64, 80);;
			-webkit-border-radius: 20px 20px 0 0;
			-moz-border-radius: 20px 20px 0 0;
			border-radius: 20px 20px 0 0;
			color: #fff;
			font-size: 28px;
			padding: 20px 26px;
		}

		#login h2 span[class*="fontawesome-"] {
			margin-right: 14px;
		}

		.form-signin {
			width: 340px !important;
		}
		
	</style>
	<script src="https://g.alicdn.com/dingding/dinglogin/0.0.5/ddLogin.js"></script>
	<script type="text/javascript">
		$(document).ready(function() {
			if('${ddLoginErrorMsg}' != ''){
				alert("${ddLoginErrorMsg}");
			}
			//判断用户的浏览器，不支持ie9以下的浏览器
			if(navigator.userAgent.indexOf("MSIE")>0){  
			      if(navigator.userAgent.indexOf("MSIE 6.0")>0){   
			        alert("对不起，您的浏览器版本过低，不能正常使用CKU管理系统");    
			      }   
			      if(navigator.userAgent.indexOf("MSIE 7.0")>0){  
			    	  alert("对不起，您的浏览器版本过低，不能正常使用CKU管理系统");  
			      }   
			      if(navigator.userAgent.indexOf("MSIE 8.0")>0 ){
			    	  alert("对不起，您的浏览器版本过低，不能正常使用CKU管理系统");  
			      }   
			      if(navigator.userAgent.indexOf("MSIE 9.0")>0){  
			      }   
			} 
			
			$("#loginForm").validate({
				rules: {
				},
				messages: {
					username: {required: "请填写用户名."},password: {required: "请填写密码."},
					validateCode: { required: "请填写验证码."}
				},
				errorLabelContainer: "#messageBox",
				errorPlacement: function(error, element) {
					error.appendTo($("#loginError").parent());
				} 
			});
			<%
				ResourceBundle res = ResourceBundle.getBundle("config");
				String appKey = new String(res.getString("dingding.appKey").getBytes("ISO8859-1"),"utf-8");
				String redirectUri = new String(res.getString("dingding.redirectUri").getBytes("ISO8859-1"),"utf-8");
				String mode = new String(res.getString("mode").getBytes("ISO8859-1"),"utf-8");
				String DDLoginSwitch = DictUtils.getDictList("login_switch").get(0).getValue();
			%>

			//如果是正式环境则隐藏用户名密码登录
			if ('<%=mode%>' == 'product' && '<%=DDLoginSwitch%>' == '1') {
				$("#loginForm").hide();
			}

			//钉钉扫码登录
			var redirect_uri = encodeURIComponent('<%=redirectUri%>');
			var goto = encodeURIComponent('https://oapi.dingtalk.com/connect/oauth2/sns_authorize?appid=' + '<%=appKey%>'
					+ '&response_type=code&scope=snsapi_login&state=STATE&redirect_uri=' + redirect_uri);
			
			DDLogin({
				id: "DDlogin_container",
				goto: goto, //请参考注释里的方式
				style: "border:none;background-color:#FFFFFF;",
				width: "400",
				height: "400"
			});

			var handleMessage = function (event) {
				var origin = event.origin;
				if(origin == "https://login.dingtalk.com") { //判断是否来自ddLogin扫码事件。
					var loginTmpCode = event.data;
					//获取到loginTmpCode后就可以在这里构造跳转链接进行跳转了
					var url = 'https://oapi.dingtalk.com/connect/oauth2/sns_authorize?appid=' + '<%=appKey%>'
							+ '&response_type=code&scope=snsapi_login&state=STATE&redirect_uri=' + goto + '&loginTmpCode=' + loginTmpCode;
					window.open(url,'_self');
				}
			};
			if (typeof window.addEventListener != 'undefined') {
				window.addEventListener('message', handleMessage, false);
			} else if (typeof window.attachEvent != 'undefined') {
				window.attachEvent('onmessage', handleMessage);
			}
		});
		// 如果在框架或在对话框中，则弹出提示并跳转到首页
		if(self.frameElement && self.frameElement.tagName == "IFRAME" || $('#left').length > 0 || $('.jbox').length > 0){
			alert('未登录或登录超时。请重新登录，谢谢！');
			top.location = "${ctx}";
		}

	</script>
</head>
<body>
	<!--[if lte IE 6]><br/><div class='alert alert-block' style="text-align:left;padding-bottom:10px;"><a class="close" data-dismiss="alert">x</a><h4>温馨提示：</h4><p>你使用的浏览器版本过低。为了获得更好的浏览体验，我们强烈建议您 <a href="http://browsehappy.com" target="_blank">升级</a> 到最新版本的IE浏览器，或者使用较新版本的 Chrome、Firefox、Safari 等。</p></div><![endif]-->
	<div class="header">
		<div id="messageBox" class="alert alert-error ${empty message ? 'hide' : ''}"><button data-dismiss="alert" class="close">×</button>
			<label id="loginError" class="error">${message}</label>
		</div>
	</div>
	<div id="login">
		<h2>CKU 会员业务后台管理</h2>
		<form id="loginForm" class="form-signin" action="${ctx}/login" method="post">
			<label class="input-label" for="username">登录名</label>
			<input type="text" id="username" name="username" class="input-block-level required" value="${username}">
			<input type="hidden" id="loginType" name="loginType" value="oa">
			<label class="input-label" for="password">密码</label>
			<input type="password" id="password" name="password" class="input-block-level required">
			<c:if test="${isValidateCodeLogin}">
				<div class="validateCode">
					<label class="input-label mid" for="validateCode">验证码</label>
					<sys:validateCode name="validateCode" inputCssStyle="margin-bottom:0;"/>
				</div>
			</c:if>
			<input class="btn btn-large btn-primary" type="submit" value="登 录"/>&nbsp;&nbsp;
			<label for="rememberMe" title="下次不需要再登录"><input type="checkbox" id="rememberMe" name="rememberMe" ${rememberMe ? 'checked' : ''}/>记住我（公共场所慎用）</label>
		</form>
		<div id="DDlogin_container"></div>
	</div>
	<div class="footer">
	</div>
	<script src="${ctxStatic}/flash/zoom.min.js" type="text/javascript"></script>
</body>
</html>