package com.cku.schools.mrschool.service;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.groomer.dao.GroomerCourseDao;
import com.cku.oa.groomer.dao.GroomerDiplomaDao;
import com.cku.oa.groomer.entity.GroomerCourse;
import com.cku.oa.groomer.entity.GroomerDiploma;
import com.cku.oa.groomer.service.GroomerCourseService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.PinYinUtil;
import com.cku.oa.sys.zalog.SysContext;
import com.cku.oa.trainschool.dao.SchoolsTeacherDao;
import com.cku.oa.trainschool.entity.TrainingInstitution;
import com.thinkgem.jeesite.common.utils.DateUtils;
import com.thinkgem.jeesite.common.utils.PropertiesLoader;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

/**
 * user chaixueteng 2017年6月22日
 */
@Service
@Transactional(readOnly = true)
public class SchoolsCourseService {
	@Autowired
	private MemberService memberService;
	@Autowired
	private GroomerCourseService groomerCourseService;
	@Autowired
	private GroomerDiplomaDao groomerDiplomaDao;
	@Autowired
	private GroomerCourseDao groomerCourseDao;
	@Autowired
	private SchoolsTeacherDao schoolsTeacherDao;

	/**
	 * 查询会员信息
	 *
	 * @Author chaixueteng
	 * @2016年10月23日下午2:29:05
	 */
	public String checkStudent(String memberCode) {
		Member member = memberService.getByMemberCode(memberCode);
		if (member == null) {
			return "{\"rc\":false,\"msg\":\"查无此会员\"}";
		} else {
			if ((member.getMemberEndDate() != null && member.getMemberEndDate().getTime() >= new Date().getTime())
					|| (member.getGroomerEndDate() != null
							&& member.getGroomerEndDate().getTime() >= new Date().getTime())) {
				return "{\"rc\":true,\"name\":\"" + member.getName() + "\",\"paymentState\":\"" + "2" + "\"}";
			} else {
				return "{\"rc\":true,\"name\":\"" + member.getName() + "\",\"paymentState\":\"" + "1" + "\"}";
			}
		}
	}

	/**
	 * 查询课程信息
	 *
	 * @Author chaixueteng
	 * @2017年6月23日下午3:30:27
	 */
	public String rockMsg(String id) {
		GroomerCourse groomerCourse = groomerCourseService.get(id);
		if (groomerCourse == null) {
			return "{\"rc\":false,\"msg\":\"课程信息找不到\"}";
		} else {
			return "{\"rc\":true,\"diplomaLevel\":\"" + groomerCourse.getDiplomaLevel() + "\",\"teacher\":\""
					+ groomerCourse.getTeacher() + "\"" + ",\"startDate\":\"" + groomerCourse.getStartDate()
					+ "\",\"endDate\":\"" + groomerCourse.getEndDate() + "\"}";
		}
	}

	/**
	 * 打印
	 *
	 * @Author chaixueteng
	 * @2016年9月3日下午4:23:03
	 */
	@Transactional(readOnly = false)
	public GroomerDiploma print(GroomerDiploma groomerDiploma) {
		TrainingInstitution ti = (TrainingInstitution) UserUtils.getSession().getAttribute("trainingInstitution");
		SysContext sysContext = new SysContext(null, null, null);
		sysContext.noStateExecute(sysContext, "美容师结业证书打印", groomerDiploma.getMemberCode(), "groomer_diploma",
				groomerDiploma.getId(), groomerDiploma.getRunningNumber(), (str) -> {
				});
		groomerDiploma.setPrintState("1");
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		groomerDiploma.setRemarks(format.format(new Date()) + "由 " + ti.getSchoolNameCn() + ":打印");
		groomerDiplomaDao.resetPrint(groomerDiploma);
		Date issueDate = groomerDiploma.getIssueDate();
		String date = DateUtils.formatDate(issueDate, "yyyy年M月d日");
		// 英文名
		Member member = memberService.getByMemberCode(groomerDiploma.getMemberCode());
		groomerDiploma.setNameEn(!Objects.isNull(member) && StringUtils.isNotBlank(groomerDiploma.getNameEn())
				? groomerDiploma.getNameEn()
				: PinYinUtil.getFullSpell(groomerDiploma.getName()));
		groomerDiploma.setIssDate(date);
		return groomerDiploma;
	}

	@Transactional(readOnly = false)
	public void save(GroomerCourse groomerCourse) throws Exception {
		TrainingInstitution trainingInstitution = (TrainingInstitution) UserUtils.getSession()
				.getAttribute("trainingInstitution");
		if ("1".equals(trainingInstitution.getQualifications()) && "1".equals(groomerCourse.getType())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "非金质/银质学校默认线上公开课不支持选择线下培训课！");
		}
		if (StringUtils.isBlank(groomerCourse.getPrice())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "价格为空！");
		}
		if (!"3".equals(groomerCourse.getType()) && StringUtils.isBlank(groomerCourse.getCover())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "课程封面为空！");
		}
		if ("1".equals(groomerCourse.getType()) && Double.parseDouble(groomerCourse.getPrice()) < 1000.00) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "价格最小为1000！");
		}
		if ("1".equals(groomerCourse.getType()) && StringUtils.isBlank(groomerCourse.getPic1())
				&& StringUtils.isBlank(groomerCourse.getPic2()) && StringUtils.isBlank(groomerCourse.getPic3())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "线下培训课需上传课程截好图！");
		}
		if ("2".equals(groomerCourse.getType()) && StringUtils.isBlank(groomerCourse.getVideo())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "线上公开课需上传课程视频！");
		}
		if ("1".equals(groomerCourse.getType()) && !"A".equals(groomerCourse.getDiplomaLevel())
				&& !"B".equals(groomerCourse.getDiplomaLevel()) && !"C".equals(groomerCourse.getDiplomaLevel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "线下课程等级只有A/B/C级！");
		}
		if (StringUtils.isBlank(groomerCourse.getTeacherId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "课程讲师不能为空！");
		}
		groomerCourse
				.setIntroduce(groomerCourse.getPic1() + "," + groomerCourse.getPic2() + "," + groomerCourse.getPic3());
		if (StringUtils.isNotBlank(groomerCourse.getCourseDetails())) {
			groomerCourse.setCourseDetails(StringEscapeUtils.unescapeHtml4(groomerCourse.getCourseDetails()));
		}
		String maxCode = groomerCourseDao.getMaxCode();
		if (StringUtils.isBlank(maxCode)) {
			maxCode = "0";
		}
		groomerCourse.setTeacher(schoolsTeacherDao.get(groomerCourse.getTeacherId()).getTeacherName());
		groomerCourse.setCode(SysCodeUtil.stringFormat(Long.parseLong(maxCode) + 1, "0000000"));
		groomerCourseService.save(groomerCourse);
	}

	private static PropertiesLoader loader = new PropertiesLoader("config.properties");

	@Transactional(readOnly = false)
	public void onOffStates(GroomerCourse groomerCourse) {
		GroomerCourse course = groomerCourseDao.get(groomerCourse.getId());
		if (course == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id不对！");
		}
		if ("2".equals(groomerCourse.getStates())) {
			course.setStates("5");
		} else {
			if ("1".equals(course.getStates()) || "4".equals(course.getStates()) || "5".equals(course.getStates())) {
				course.setStates("2");
			} else if ("2".equals(course.getStates()) || "3".equals(course.getStates())) {
				course.setStates("5");
			}
		}
		groomerCourseDao.update(course);
	}

}
