/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.shop.web;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.cku.core.RESTResponse;
import com.cku.restful.v1.shop.service.RestShopGoodsClassService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

/**
 * 商品类别Controller
 * 
 * @author lyy
 * @version 2016-08-11
 */
@Controller
@RequestMapping(value = "/api/v1/shop")
public class RestShopGoodsClassController extends BaseRestController {

	@Autowired
	private RestShopGoodsClassService restShopGoodsClassService;

	@RequestMapping(value = "/shopGoodsClass", method = RequestMethod.GET)
	@ResponseBody
	public void getList(HttpServletResponse response) throws IOException {
		RESTResponse result = restShopGoodsClassService.getList();
		ServletUtils.writeResponse(response, result);
	}

}