package com.cku.restful.v1.shop.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.shop.dao.ShopCartsDao;
import com.cku.oa.shop.dao.ShopGoodsDao;
import com.cku.oa.shop.entity.ShopCarts;
import com.cku.oa.shop.entity.ShopOrder;
import com.cku.oa.shop.entity.ShopOrderDetail;
import com.cku.oa.shop.service.ShopCartsService;
import com.cku.oa.shop.service.ShopOrderService;
import com.cku.oa.sys.entity.user.Member;
import com.cku.restful.v1.shop.model.RestShopOrder;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

/**
 * 商城订单Service
 * 
 * @author lyy
 * @version 2016-08-12
 */
@Service
@Transactional(readOnly = true)
public class RestShopOrderService {

	@Autowired
	private ShopOrderService shopOrderService;
	@Autowired
	private ShopCartsService shopCartsService;
	@Autowired
	private ShopCartsDao shopCartsDao;
	@Autowired
	private ShopGoodsDao shopGoodsDao;

	public RESTResponse get(String id) {
		Member member = UserUtils.getLoginMember();
		ShopOrder shopOrder = shopOrderService.get(id);
		if (shopOrder == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(shopOrder.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestShopOrder vo = new RestShopOrder();
		BeanUtil.copyProperties(vo, shopOrder, "yyyy-MM-dd HH:mm:ss");
		vo.setOrderDetailList(shopOrder.getOrderDetailList(),shopGoodsDao);
		vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(),
				"payment_way", ""));
		vo.setPaymentState(DictUtils.getDictLabel(vo.getPaymentState(),
				"user_payment_state", ""));
		vo.setPostType(DictUtils.getDictLabel(vo.getPostType(), "mailing_way",
				""));
		vo.setSendPostType(DictUtils.getDictLabel(vo.getSendPostType(),
				"shop_mailing", ""));

		return new RESTResponse("data", vo);
	}

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String paymentState = request.getParameter("paymentState");
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
					"pageNo和pageSize必须都为数字");
		}
		ShopOrder example = new ShopOrder();
		// 设置分页参数
		Page<ShopOrder> page = new Page<ShopOrder>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setMemberCode(UserUtils.getLoginMember().getMemberCode());
		example.setDelFlag("0");
		example.setPage(page);
		if (StringUtils.isNotBlank(paymentState)) {
			example.setPaymentState(paymentState);
		}
		// 查询并组装返回对象
		Page<ShopOrder> result = shopOrderService.findPage(page, example);
		List<ShopOrder> shopOrderList = result.getList();
		List<RestShopOrder> list = new ArrayList<RestShopOrder>();
		for (ShopOrder shopOrder : shopOrderList) {
			RestShopOrder vo = new RestShopOrder();
			BeanUtil.copyProperties(vo, shopOrder, "yyyy-MM-dd HH:mm:ss");
			vo.setOrderDetailList(shopOrder.getOrderDetailList(),shopGoodsDao);
			vo.setPaymentWay(DictUtils.getDictLabel(vo.getPaymentWay(),
					"payment_way", ""));
			vo.setPaymentState(DictUtils.getDictLabel(vo.getPaymentState(),
					"user_payment_state", ""));
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestShopOrder>(list,
				count));
	}

	@Transactional(readOnly = false)
	public RESTResponse delete(String id) {
		Member member = UserUtils.getLoginMember();
		ShopOrder po = shopOrderService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		shopOrderService.delOrder(po);
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse pay(String json) {
		// 获取参数
		ShopOrder vo = BeanUtil.toBean(json, ShopOrder.class);
		// 参数校验
		ShopOrder po = validatePayParameter(vo);
		// 调用支付业务
		shopOrderService.clientPay(po);
		return new RESTResponse();
	}

	/**
	 * 
	 * @description: 支付参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月21日 下午8:25:16
	 */
	private ShopOrder validatePayParameter(ShopOrder vo) {
		if (StringUtils.isBlank(vo.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单id为空");
		}
		if (StringUtils.isBlank(vo.getPaymentWay())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "支付方式为空");
		}
		if ("".equals(DictUtils.getDictLabel(vo.getPaymentWay(), "payment_way",
				""))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "支付方式有误");
		}
		ShopOrder shopOrder = shopOrderService.get(vo.getId());
		if (shopOrder == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "订单id有误");
		}
		if ("1".equals(shopOrder.getDelFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已删除");
		}
		if ("2".equals(shopOrder.getPaymentState())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该订单已支付");
		}
		shopOrder.setPaymentWay(vo.getPaymentWay());
		return shopOrder;
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		if(true){
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "商城功能暂未开放，无法提交订单！");
		}
		// 获取参数
		ShopOrder vo = BeanUtil.toBean(json, ShopOrder.class);
		// 参数校验
		validateParameter(vo);
		// 构造持久对象
		ShopOrder po = buildPo(vo);
		// 写入订单表
		shopOrderService.clientSave(po);
		JSONObject jo = new JSONObject();
		jo.put("id", po.getId());
		return new RESTResponse("data", jo);
	}

	/**
	 * 
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(ShopOrder vo) {
//		if (StringUtils.isBlank(vo.getPostType())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄方式为空");
//		}
//		if (!"0".equals(vo.getPostType()) && !"1".equals(vo.getPostType())
//				&& !"2".equals(vo.getPostType())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮寄方式只能为0，1，2");
//		}
		if (StringUtils.isBlank(vo.getProvince())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收货省份为空");
		}
		if (StringUtils.isBlank(vo.getCity())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收货城市为空");
		}
		if (StringUtils.isBlank(vo.getAddress())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收货地址为空");
		}
		if (StringUtils.isBlank(vo.getPostDel())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收货联系电话为空");
		}
		if (StringUtils.isBlank(vo.getPostName())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "收货人姓名为空");
		}
		if (StringUtils.isBlank(vo.getPostCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "邮编为空");
		}
		if (StringUtils.isBlank(vo.getShopCartsId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车订单id为空");
		}
	}

	/**
	 * 
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private ShopOrder buildPo(ShopOrder vo) {
		Member member = UserUtils.getLoginMember();
		ShopOrder po = new ShopOrder();
		po.setMemberCode(member.getMemberCode());
		po.setMemberName(member.getName());
		po.setProvince(vo.getProvince());
		po.setCity(vo.getCity());
		po.setAddress(vo.getAddress());
		po.setPostDel(vo.getPostDel());
		po.setPostName(vo.getPostName());
		po.setPostCode(vo.getPostCode());
		po.setPostType(vo.getPostType());
		po.setMessage(vo.getMessage());

		List<ShopOrderDetail> orderDetailList = new ArrayList<ShopOrderDetail>();
		//去重复
		String[] shopCartsIds = vo.getShopCartsId().split(",");
		HashSet<String> shopCartsSet = new HashSet<String>();
		for (String shopCartsId1 : shopCartsIds) {
			shopCartsSet.add(shopCartsId1);
		}
		//循环
		for (String shopCartsId : shopCartsSet) {
			ShopCarts shopCarts = shopCartsService.get(shopCartsId);
			if (shopCarts == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "购物车订单id有误");
			}
			addOrderDetailList(orderDetailList, shopCarts);
			if (StringUtils.isNotBlank(shopCarts.getBuyGiftsContent())) {
				// 获取买赠商品
				JSONArray ja = JSONArray.fromObject(shopCarts.getBuyGiftsContent());
				for (int i = 0; i < ja.size(); i++) {
					JSONObject jo = ja.getJSONObject(i);
					ShopCarts buyGift = shopCartsDao.getBuyGift(member.getMemberCode(), jo.getString("id"));
					if (buyGift != null) {
						buyGift.setGoodsNum(jo.getString("num"));
						addOrderDetailList(orderDetailList, buyGift);
					}
				}
			}
		}
		po.setOrderDetailList(orderDetailList);
		return po;
	}

	private void addOrderDetailList(List<ShopOrderDetail> orderDetailList,
			ShopCarts shopCarts) {
		Member member = UserUtils.getLoginMember();
		ShopOrderDetail shopOrderDetail = new ShopOrderDetail();
		shopOrderDetail.setId(shopCarts.getId());
		shopOrderDetail.setGoodsId(shopCarts.getGoodsId());
		shopOrderDetail.setGoodsNum(shopCarts.getGoodsNum());
		shopOrderDetail.setIsBuyGifts(shopCarts.getIsBuyGifts());
		shopOrderDetail.setGoodsName(shopCarts.getGoodsName());
		shopOrderDetail.setGoodsPrice(shopCarts.getGoodsPrice());
		// shopOrderDetail.setShopOrderCode(shopOrderCode);
		shopOrderDetail.setMemberCode(member.getMemberCode());
		shopOrderDetail.setMemberName(member.getName());
		shopOrderDetail.setTotalPrice(shopCarts.getTotalPrice());
		orderDetailList.add(shopOrderDetail);
	}

}