/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.handler.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.handler.entity.HandlerShow;
import com.cku.oa.handler.service.HandlerShowService;
import com.cku.oa.sys.util.ImgUtil;
import com.cku.restful.v1.handler.model.RestHandlerShow;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;


/**
 * 活动Service
 *
 * @author 柴雪腾
 * @version 2016-08-08
 */
@Service
@Transactional(readOnly = true)
public class RestHandlerShowService {

	@Autowired
	private HandlerShowService handlerShowService;

	public RESTResponse getExaminerList(HttpServletRequest request) {
		String canRegister = request.getParameter("canRegister");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		HandlerShow example = new HandlerShow();
		// 设置分页参数
		Page<HandlerShow> page = new Page<HandlerShow>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 1. 可以报名的比赛 2. 活动时间最近 3. 活动发布时间最新
		page.setOrderBy("canRegister desc,  a.register_end_time>now()  desc,ABS(a.start_time-now()),a.create_date desc ");
		// 设置查询条件
		example.setPage(page);
		example.setDelFlag("0");
		example.setOneYear(true);
		example.setShowTypeList(Arrays.asList("10","11"));

		if (StringUtils.isNotBlank(canRegister) && Boolean.valueOf(canRegister)) {
			example.setRegisterEndTime(new Date());
			example.setRegisterNumFlag(true);
		}
		// 查询并组装返回对象
		Page<HandlerShow> result = handlerShowService.findExaminerPage(page, example);
		List<HandlerShow> handlerShowList = result.getList();
		List<RestHandlerShow> list = new ArrayList<RestHandlerShow>();

		for (HandlerShow handlerShow : handlerShowList) {
			RestHandlerShow vo = new RestHandlerShow();
			BeanUtil.copyProperties(vo, handlerShow, "yyyy-MM-dd HH:mm");
			vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "handler_show_type", ""));
			vo.setRegisterImage(ImgUtil.getImgUrl(request, vo.getRegisterImage()));
			vo.setReviewImage(ImgUtil.getImgUrl(request, vo.getReviewImage()));
			vo.setTopicImage(ImgUtil.getImgUrl(request, vo.getTopicImage()));

			Integer max = 0, registerNum = 0;
			if (null != handlerShow.getMaxNumber()) {
				max = handlerShow.getMaxNumber();
			}
			if (null != handlerShow.getRegisterNumber()) {
				registerNum = handlerShow.getRegisterNumber();
			}
			vo.setCanRegister(handlerShow.getRegisterEndTime().after(new Date()) && max > registerNum);
			// 活动头图
			if (StringUtils.isNotBlank(handlerShow.getShowPhoto())) {
				String path = request.getContextPath();
				String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
						+ path + "/api/v1/file/image/" + handlerShow.getShowPhoto();
				vo.setShowPhoto(imgPath);
			}
			
			vo.setRegisterNum(registerNum);
			vo.setDictType("10".equals(handlerShow.getShowType())?"handler_test_level_examiner":"groomer_examiner_course_level");
			vo.setShowName(StringEscapeUtils.unescapeHtml4(vo.getShowName()));
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestHandlerShow>(list, count));
	}

	public RESTResponse getList(HttpServletRequest request) {
		// 获取参数
		String showType = request.getParameter("showType");
		String showName = request.getParameter("showName");
		String showAddress = request.getParameter("showAddress");
		String canRegister = request.getParameter("canRegister");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String recommend = request.getParameter("recommend");// 宠爱王国app推荐
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		HandlerShow example = new HandlerShow();
		// 设置分页参数
		Page<HandlerShow> page = new Page<HandlerShow>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 1. 可以报名的比赛 2. 活动时间最近 3. 活动发布时间最新
		page.setOrderBy("a.register_end_time>now()  desc,ABS(a.start_time-now()),a.create_date desc ");
		// 设置查询条件
		example.setPage(page);
		example.setDelFlag("0");
		example.setOneYear(true);
		example.setFilterType(true);// 过滤训犬师活动
		if (StringUtils.isNotBlank(canRegister) && Boolean.valueOf(canRegister)) {
			example.setRegisterEndTime(new Date());
		}
		if (StringUtils.isNotBlank(showType)) {
			example.setShowType(showType);
		} else {
			example.setShowTypeOld(true);
		}

		if (StringUtils.isNotBlank(showName)) {
			example.setShowName(showName);
		}
		if (StringUtils.isNotBlank(showAddress)) {
			example.setShowAddress(showAddress);
		}
		if (StringUtils.isNotBlank(recommend)) {
			example.setRecommend(recommend);
		}
		example.setShowTypeExclude("7");
		// 查询并组装返回对象
		Page<HandlerShow> result = handlerShowService.findPage(page, example);
		List<HandlerShow> handlerShowList = result.getList();
		List<RestHandlerShow> list = new ArrayList<RestHandlerShow>();
		for (HandlerShow handlerShow : handlerShowList) {
			RestHandlerShow vo = new RestHandlerShow();
			BeanUtil.copyProperties(vo, handlerShow, "yyyy-MM-dd HH:mm");
			vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "handler_show_type", ""));
			if ("none".equals(handlerShow.getTestLevel())) {
				vo.setTestLevel(null);
				// vo.setShowType(vo.getShowType() + "-无级别");
			} else if ("MASTER".equals(handlerShow.getTestLevel())) {
				// vo.setShowType(vo.getShowType() + "-教师级");
			} else {
				// vo.setShowType(vo.getShowType() + "-" + handlerShow.getTestLevel());
			}
			vo.setRegisterImage(ImgUtil.getImgUrl(request, vo.getRegisterImage()));
			vo.setReviewImage(ImgUtil.getImgUrl(request, vo.getReviewImage()));
			vo.setTopicImage(ImgUtil.getImgUrl(request, vo.getTopicImage()));
			vo.setCanRegister(handlerShow.getRegisterEndTime().after(new Date()));
			//防止前端乱码
			if (StringUtils.isNotBlank(vo.getShowName())) {
				vo.setShowName(StringEscapeUtils.unescapeHtml4(vo.getShowName()));
			}
			if (StringUtils.isNotBlank(vo.getShowAddress())) {
				vo.setShowAddress(StringEscapeUtils.unescapeHtml4(vo.getShowAddress()));
			}

			// 活动头图
			if (StringUtils.isNotBlank(handlerShow.getShowPhoto())) {
				String path = request.getContextPath();
				String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
						+ path + "/api/v1/file/image/" + handlerShow.getShowPhoto();
				vo.setShowPhoto(imgPath);
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestHandlerShow>(list, count));
	}


	public RESTResponse getTrainerList(HttpServletRequest request) {
		// 获取参数
		String showType = request.getParameter("showType");
		String showName = request.getParameter("showName");
		String showAddress = request.getParameter("showAddress");
		String canRegister = request.getParameter("canRegister");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");
		String recommend = request.getParameter("recommend");// 宠爱王国app推荐
		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}
		HandlerShow example = new HandlerShow();
		// 设置分页参数
		Page<HandlerShow> page = new Page<HandlerShow>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 1. 可以报名的比赛 2. 活动时间最近 3. 活动发布时间最新
		page.setOrderBy("a.register_end_time>now()  desc,ABS(a.start_time-now()),a.create_date desc ");
		// 设置查询条件
		example.setPage(page);
		example.setDelFlag("0");
		example.setOneYear(true);
		example.setShowTypeList(Arrays.asList("12","13"));
		if (StringUtils.isNotBlank(canRegister) && Boolean.valueOf(canRegister)) {
			example.setRegisterEndTime(new Date());
		}
		if (StringUtils.isNotBlank(showName)) {
			example.setShowName(showName);
		}
		if (StringUtils.isNotBlank(showAddress)) {
			example.setShowAddress(showAddress);
		}
		if (StringUtils.isNotBlank(recommend)) {
			example.setRecommend(recommend);
		}
		//example.setShowTypeExclude("7");
		// 查询并组装返回对象
		Page<HandlerShow> result = handlerShowService.findPage(page, example);
		List<HandlerShow> handlerShowList = result.getList();
		List<RestHandlerShow> list = new ArrayList<RestHandlerShow>();
		for (HandlerShow handlerShow : handlerShowList) {
			RestHandlerShow vo = new RestHandlerShow();
			BeanUtil.copyProperties(vo, handlerShow, "yyyy-MM-dd HH:mm");
			vo.setShowType(DictUtils.getDictLabel(vo.getShowType(), "handler_show_type", ""));
			if ("none".equals(handlerShow.getTestLevel())) {
				vo.setTestLevel(null);
				// vo.setShowType(vo.getShowType() + "-无级别");
			} else if ("MASTER".equals(handlerShow.getTestLevel())) {
				// vo.setShowType(vo.getShowType() + "-教师级");
			} else {
				// vo.setShowType(vo.getShowType() + "-" + handlerShow.getTestLevel());
			}
			vo.setRegisterImage(ImgUtil.getImgUrl(request, vo.getRegisterImage()));
			vo.setReviewImage(ImgUtil.getImgUrl(request, vo.getReviewImage()));
			vo.setTopicImage(ImgUtil.getImgUrl(request, vo.getTopicImage()));
			vo.setCanRegister(handlerShow.getRegisterEndTime().after(new Date()));
			//防止前端乱码
			if (StringUtils.isNotBlank(vo.getShowName())) {
				vo.setShowName(StringEscapeUtils.unescapeHtml4(vo.getShowName()));
			}
			if (StringUtils.isNotBlank(vo.getShowAddress())) {
				vo.setShowAddress(StringEscapeUtils.unescapeHtml4(vo.getShowAddress()));
			}

			// 活动头图
			if (StringUtils.isNotBlank(handlerShow.getShowPhoto())) {
				String path = request.getContextPath();
				String imgPath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort()
						+ path + "/api/v1/file/image/" + handlerShow.getShowPhoto();
				vo.setShowPhoto(imgPath);
			}
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestHandlerShow>(list, count));
	}

}