package com.cku.restful.v1.dog.vo.response;

import java.io.Serializable;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@ApiModel
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
public class GoldCertifiedAuditPageResp implements Serializable {
	private static final long serialVersionUID = 4836388045453673375L;

	@ApiModelProperty("id")
	private String id;

	@ApiModelProperty("申请时间")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date paymentTime;

	@ApiModelProperty("犬主")
	private String dogOwner;

	@ApiModelProperty("出生日期")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date birthdate;

	@ApiModelProperty("血统证书号")
	private String pedigreeCertifiedCode;

	@ApiModelProperty("父犬主姓名")
	private String fdogMemberName;

	@ApiModelProperty(" 母犬主姓名")
	private String mdogMemberName;

	@ApiModelProperty("出生纸编号")
	private String birthCode;

	@ApiModelProperty("父犬血统证书号")
	private String fdogPedigreeCertified;

	@ApiModelProperty("母犬血统证书号")
	private String mdogPedigreeCertified;

	@ApiModelProperty("父犬主审核状态 0未审核 1同意 2不同意")
	private String fdogReviewState;

	// mdogReviewState=2时显示
	@ApiModelProperty("父犬主审核意见")
	private String fdogReviewRemarks;

	@ApiModelProperty("母犬主审核状态 0未审核 1同意 2不同意")
	private String mdogReviewState;

	// mdogReviewState=2时显示
	@ApiModelProperty("母犬主审核意见")
	private String mdogReviewRemarks;
	
	@ApiModelProperty("父犬是否当前人可审核")
	private Boolean isFdogReview;
	
	@ApiModelProperty("母犬是否当前人可审核")
	private Boolean isMdogReview;
	
	@ApiModelProperty("申请人")
	private String paymentMemberName;

}
