package com.cku.restful.v1.dog.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.dog.dao.DogDnaArchiveDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogAppraisal;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogPedigreeCertifiedChange;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.service.DogAppraisalService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogPedigreeCertifiedChangeService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.dog.vo.DogSimpleVO;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.sys.util.MemberUtil;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import net.sf.json.JSONObject;

@Service
@Transactional(readOnly = true)
public class RestDogDloodDnaService {

	@Autowired
	private DogBloodSaveService dogBloodSaveService;

	@Autowired
	private DogService dogService;

	@Autowired
	private DogAppraisalService dogAppraisalService;

	@Autowired
	private DogTypeService dogTypeService;

	@Autowired
	private DogColorMarkService dogColorMarkService;

	@Autowired
	private PaymentCartService paymentCartService;

	@Autowired
	private PaymentChargingItemService paymentChargingItemService;

	@Autowired
	private DogPedigreeCertifiedChangeService dogPedigreeCertifiedChangeService;

	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;

	private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

	@Autowired
	private DogDnaArchiveDao dogDnaArchiveDao;


	@Transactional(readOnly = false)
	public RESTResponse isDogDloodDna(String keyword) {
		return new RESTResponse("data", dogBloodSaveService.checkDna(keyword, false));
	}

	@Transactional(readOnly = false)
	public RESTResponse getDogDetail(String keyword) {
		if (StringUtils.isBlank(keyword))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "血统证书号或者芯片号不能为空");
		Dog dog = dogService.getOneByIdentificationFlagOrPedigreeCertified(keyword);
		if (dog == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号或芯片号不正确");
		if (!UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只不是本人名下");
		DogSimpleVO vo = new DogSimpleVO();
		BeanUtils.copyProperties(dog, vo, "birthdate");
		vo.setBirthdate(sdf.format(dog.getBirthdate()));
		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		String dogBreedCnName = dogType == null ? "" : dogType.getBreedCnName();
		vo.setDogBreedCnName(dogBreedCnName);
		vo.setColorFlagName(dogColorMarkService.getDogColorMarkCnSimple(dog.getColorFlag()));
		vo.setNickname(dog.getCallName());
		return new RESTResponse("data", vo);
	}

	// dog 表----》dog_blood_save 血样留存表
	// birthCode 登记卡号 dog_blood_save.birth_code dog.birth_certificate_level_code
	// dog_birth_certificate.birth_cer_reg_code
	// overseasPedigreeCertified 国外血统证书 dog_blood_save.overseas_pedigree_certified
	// dog_pedigree_certified_change.overseas_pedigree_certified
	// showAppraisalCode 场外鉴定号 dog_blood_save.show_appraisal_code
	// dog_appraisal.show_appraisal_code
	// dog_appraisal.pedigree_certified dog.pedigree_certified_code
	@Transactional(readOnly = false)
	public RESTResponse post(String json) {
		if (!MemberUtil.isActiveMember(UserUtils.getLoginMember())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员无效，无法办理该业务");
		}
		// 参数验证
		JSONObject vo = JSONObject.fromObject(json);
		if (vo.get("pedigreeCertifiedCode") == null || StringUtils.isBlank(vo.getString("pedigreeCertifiedCode")))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号不能为空");
		if (vo.get("dnaSaveWay") == null || StringUtils.isBlank(vo.getString("dnaSaveWay")))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "留存方式不能为空");
		if (vo.get("applyChannel") == null || StringUtils.isBlank(vo.getString("applyChannel")))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA办理方式不能为空");
		String applyChannel = vo.getString("applyChannel");//办理渠道  0	机构办理   1	自检
		if (!("0".equals(applyChannel) ||"1".equals(applyChannel))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA办理方式只能为0或者1");
		}
		if ("0".equals(applyChannel) 
				&&(vo.get("hospitalCode") == null || StringUtils.isBlank(vo.getString("hospitalCode"))))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作机构不能为空");
		String hospitalCode = null;
		if ("0".equals(applyChannel) ) {
			hospitalCode = vo.getString("hospitalCode");
		}
		// 数据正确性验证
		Dog dog = dogService.getByPedigreeCertifiedCode(vo.getString("pedigreeCertifiedCode"));
		if (dog == null)
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书号查不到");
		if (!UserUtils.getLoginMember().getMemberCode().equals(dog.getMemberCode()))
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "不是本人犬只");
		// 是否重复录入验证
		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.setBirthCode(dog.getBirthCertificateLevelCode());
		dogBloodSave.setPedigreeCertified(vo.getString("pedigreeCertifiedCode"));
		String overseasPedigreeCertified = null;
		String showAppraisalCode = null;
		if (StringUtils.isBlank(dog.getBirthCertificateLevelCode())) {
			DogPedigreeCertifiedChange c = dogPedigreeCertifiedChangeService.getByDogIdOrDogChip(dog.getId(),
					dog.getIdentificationFlag());
			if (c != null) {
				overseasPedigreeCertified = c.getOverseasPedigreeCertified();
				dogBloodSave.setOverseasPedigreeCertified(overseasPedigreeCertified);
			} else {
				DogAppraisal da = dogAppraisalService.getByPedigreeCertified(dog.getPedigreeCertifiedCode());
				if (da != null) {
					showAppraisalCode = da.getShowAppraisalCode();
					dogBloodSave.setShowAppraisalCode(showAppraisalCode);
				} else {
					dogBloodSave.setPedigreeCertified(dog.getPedigreeCertifiedCode());
				}
			}
		}
		// 添加购物车
		String businessOrderCode = IdGen.uuid();
		StringBuilder cartIds = new StringBuilder();
		if ("0".equals(vo.getString("dnaSaveWay"))) {
			// 血样
			// 提交订单的时候，有未缴费的记录也不允许提交
			DogBloodSave s = dogBloodSaveService.getByParams2(dogBloodSave, true);
			if (s != null)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"已有血样留存" + ("1".equals(s.getPaymentState()) ? "未付款" : ""));
			// 血样留存业务
			String bloodSaveCartId = bloodSave(dog.getBirthdate(), dog.getBirthCertificateLevelCode(),
					overseasPedigreeCertified, showAppraisalCode, dog.getPedigreeCertifiedCode(),
					vo.getString("dnaSaveWay"), businessOrderCode, hospitalCode);
			cartIds.append(bloodSaveCartId);
		}
		// dnaSaveWay DNA留存方式:血样留存0；DNA位点分析1
		if ("1".equals(vo.getString("dnaSaveWay"))) {
			// 提交订单的时候，有未缴费的记录也不允许提交
			DogBloodSave s = dogBloodSaveService.getByParams2(dogBloodSave, true);
			if (s == null){
				// 血样留存业务
				String bloodSaveCartId = bloodSave(dog.getBirthdate(), dog.getBirthCertificateLevelCode(),
						overseasPedigreeCertified, showAppraisalCode, dog.getPedigreeCertifiedCode(),
						vo.getString("dnaSaveWay"), businessOrderCode, hospitalCode);
				cartIds.append(bloodSaveCartId);
			}
			//判断是否有位点
			DogDnaArchive dogDnaArchive = dogDnaArchiveDao.getByPedigreeCertifiedCode(dog.getPedigreeCertifiedCode());
			if(dogDnaArchive!=null){
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
						"已有位点分析" + ("1".equals(dogDnaArchive.getPaymentState()) ? "未付款" : ""));
			}
			// DNA位点分析业务
			// applyChannel 办理渠道  0	机构办理   1	自检
			String dnaArchiveCartId = dnaArchive(dog.getBirthCertificateLevelCode(), overseasPedigreeCertified,
					dog.getId(), dog.getPedigreeCertifiedCode(), businessOrderCode, hospitalCode,applyChannel);
			cartIds.append(",").append(dnaArchiveCartId);
		}
		return new RESTResponse("data", cartIds.toString());

	}

	// 位点分析业务
	public String dnaArchive(String birthCode, String overseasPedigreeCertified, String dogId,
			String pedigreeCertified, String businessOrderCode, String hospitalCode,String applyChannel) {
		List<PaymentChargingItem> items = paymentChargingItemService.findListByIds(DogDnaArchiveService.DNA_ARCHIVE_FEE);
		Double price = items.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();
		
		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.setDogId(dogId);
		dogDnaArchive.setBirthCode(birthCode);
		dogDnaArchive.setOverseasPedigreeCertified(overseasPedigreeCertified);
		dogDnaArchive.setPedigreeCertified(pedigreeCertified);
		dogDnaArchive.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		dogDnaArchive.setPrice(price.toString());
		dogDnaArchive.setReviewState("0");
		dogDnaArchive.setPaymentState("1");
		dogDnaArchive.setProcessState("0");
		dogDnaArchive.setPrintState("0");
		dogDnaArchive.setOrgId(hospitalCode);
		dogDnaArchive.setIsOEC("1");
		dogDnaArchive.setApplyChannel(Integer.valueOf(applyChannel));
		dogDnaArchiveService.save(dogDnaArchive);
		
		StringBuilder cartIds = new StringBuilder();
		items.stream().forEach(item -> {
			PaymentCart paymentCart = new PaymentCart();
			paymentCart.setChargingItemId(item.getId());
			paymentCart.setChargingItemName(item.getName());
			paymentCart.setPrice(item.getPrice());
			paymentCart.setTotalPrice(item.getPrice());
			paymentCart.setNum("1");
			paymentCart.setBusinessTable("dog_dna_archive");
			paymentCart.setBusinessIds(dogDnaArchive.getId());
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addBusinessManage(paymentCart, "1081");
			paymentCartService.addToCart(paymentCart, "1081");
			cartIds.append(paymentCart.getId());
			cartIds.append(",");
		});
		
		return cartIds.toString();

	}

	private static final List<String> BLOOD_SAVE_ITEM_IDS = Arrays.asList("0d1d2749270443ecb20899ed200f92a7", "246");// 登记服务费(纯种犬DNA样本) 登记服务费（纯种犬DNA样本）减免
	
	private static final List<String> BLOOD_SAVE_ITEM_IDS_OEC = Arrays.asList("034db20398ee4bea828876e7e72a6f8c");

	// 血样留存业务
	public String bloodSave(Date dogBirthday, String birthCerRegCode, String overseasPedigreeCertified,
			String showAppraisalCode, String pedigreeCertifiedCode, String dnaSaveWay, String businessOrderCode,
			String hospitalCode) {
		// 1 查找收费项
		List<String> ids = "1".equals(dnaSaveWay)?BLOOD_SAVE_ITEM_IDS_OEC:BLOOD_SAVE_ITEM_IDS;
		List<PaymentChargingItem> bloodSaveItems = paymentChargingItemService.findListByIds(ids);
		Double price = bloodSaveItems.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();

		// 2 血样留存对象
		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.setBirthCode(birthCerRegCode);
		dogBloodSave.setOverseasPedigreeCertified(overseasPedigreeCertified);
		dogBloodSave.setShowAppraisalCode(showAppraisalCode);
		dogBloodSave.setPedigreeCertified(pedigreeCertifiedCode);
		dogBloodSave.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		dogBloodSave.setPrice(price.toString());
		dogBloodSave.setPaymentState("1");
		dogBloodSave.setOrganizationName("1");// 办理机构
		dogBloodSave.setOrgId(hospitalCode);
		dogBloodSave.setIsOEC(dnaSaveWay);// 是否为口腔上皮细胞测试法:否0；是1
		dogBloodSaveService.save(dogBloodSave);
		// 3 加入购物车
		List<PaymentCart> bloodSaveCarts = getBloodSaveCart(bloodSaveItems, dogBloodSave, businessOrderCode);
		StringBuilder cartIds = new StringBuilder();
		bloodSaveCarts.stream().forEach(a -> {
			paymentCartService.addToCart(a, "1081");
			cartIds.append(a.getId());
			cartIds.append(",");
		});

		return cartIds.substring(0, cartIds.length() - 1);
	}

	/**
	 * @description: 登记服务费(纯种犬DNA样本) 购物车
	 * @author: laiguanglong
	 * @date: 2016/11/25 17:24
	 */
	private List<PaymentCart> getBloodSaveCart(List<PaymentChargingItem> items, DogBloodSave dogBloodSave,
			String businessOrderCode) {
		List<PaymentCart> carts = new ArrayList<>();
		items.stream().forEach(a -> {
			PaymentCart paymentCart = new PaymentCart();
			paymentCart.setChargingItemId(a.getId());
			paymentCart.setChargingItemName(a.getName());
			paymentCart.setPrice(a.getPrice());
			paymentCart.setTotalPrice(a.getPrice());
			paymentCart.setNum("1");
			paymentCart.setBusinessTable("dog_blood_save");
			paymentCart.setBusinessIds(dogBloodSave.getId());
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCartService.addBusinessManage(paymentCart, "1081");
			carts.add(paymentCart);
		});
		return carts;
	}
}
