/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.restful.v1.dog.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.PageBeanResult;
import com.cku.core.RESTResponse;
import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.activity.dao.SysMemberActivityRecordDao;
import com.cku.oa.activity.entity.SysMemberActivityRecord;
import com.cku.oa.dog.dao.DogBirthCertificateDao;
import com.cku.oa.dog.dao.DogColorMarkDao;
import com.cku.oa.dog.dao.DogDao;
import com.cku.oa.dog.entity.Dog;
import com.cku.oa.dog.entity.DogBirthCertificate;
import com.cku.oa.dog.entity.DogBloodSave;
import com.cku.oa.dog.entity.DogChip;
import com.cku.oa.dog.entity.DogChipMemberLock;
import com.cku.oa.dog.entity.DogColorMark;
import com.cku.oa.dog.entity.DogDnaArchive;
import com.cku.oa.dog.entity.DogDnaParentsCompare;
import com.cku.oa.dog.entity.DogNose;
import com.cku.oa.dog.entity.DogSticker;
import com.cku.oa.dog.entity.DogType;
import com.cku.oa.dog.entity.DuplicateDog;
import com.cku.oa.dog.service.DogBirthCertificateService;
import com.cku.oa.dog.service.DogBloodSaveService;
import com.cku.oa.dog.service.DogChipMemberLockService;
import com.cku.oa.dog.service.DogChipService;
import com.cku.oa.dog.service.DogColorMarkService;
import com.cku.oa.dog.service.DogDnaArchiveService;
import com.cku.oa.dog.service.DogDnaParentsCompareService;
import com.cku.oa.dog.service.DogNoseService;
import com.cku.oa.dog.service.DogService;
import com.cku.oa.dog.service.DogStickerService;
import com.cku.oa.dog.service.DogTypeService;
import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.entity.PaymentChargingItem;
import com.cku.oa.finance.entity.PaymentOrder;
import com.cku.oa.finance.service.PaymentCartService;
import com.cku.oa.finance.service.PaymentChargingItemService;
import com.cku.oa.finance.service.PaymentOrderService;
import com.cku.oa.finance.vo.PaymentCartVO;
import com.cku.oa.kennel.entity.Kennel;
import com.cku.oa.kennel.service.KennelService;
import com.cku.oa.sampling.enums.SamplingDogSourceTypeEnum;
import com.cku.oa.sys.badword.service.DemandSensitiveWordService;
import com.cku.oa.sys.code.SysCodeUtil;
import com.cku.oa.sys.coupon.entity.SysCoupon;
import com.cku.oa.sys.coupon.service.SysCouponService;
import com.cku.oa.sys.entity.LoginServer;
import com.cku.oa.sys.entity.Org;
import com.cku.oa.sys.entity.user.Member;
import com.cku.oa.sys.entity.user.MemberCardTypeEnum;
import com.cku.oa.sys.service.LoginServerService;
import com.cku.oa.sys.service.OrgDogTypeLimitService;
import com.cku.oa.sys.service.OrgService;
import com.cku.oa.sys.service.user.MemberActivity20201212Discount;
import com.cku.oa.sys.service.user.MemberService;
import com.cku.oa.sys.util.ConstantUtils;
import com.cku.oa.sys.util.DateUtils;
import com.cku.oa.sys.util.MemberUtil;
import com.cku.partner.club.service.ClubDnaService;
import com.cku.restful.v1.breeder.dto.RestDogChipApplyCommonDto;
import com.cku.restful.v1.dog.model.RestDogChip;
import com.cku.restful.v1.dog.model.RestDogChipPriceDto;
import com.cku.restful.v1.dog.model.RestDogChipPriceResultDto;
import com.cku.restful.v1.dog.model.ViewCertificateVo;
import com.cku.restful.v1.dog.vo.response.GoldCertifiedPageResp;
import com.cku.restful.v1.sys.model.RestCouponGroup;
import com.cku.restful.v1.sys.model.RestRenew;
import com.cku.restful.v1.sys.model.RestRenewPaymentItem;
import com.cku.restful.v1.sys.service.RestIDCardService;
import com.cku.restful.v1.sys.service.RestMemberService;
import com.cku.restful.v1.sys.utils.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AtomicDouble;
import com.thinkgem.jeesite.common.mapper.JsonMapper;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.utils.IdGen;
import com.thinkgem.jeesite.modules.sys.utils.DictUtils;
import com.thinkgem.jeesite.modules.sys.utils.UserUtils;

import edu.emory.mathcs.backport.java.util.Arrays;
import net.sf.json.JSONObject;

/**
 * 新生犬登记Service
 *
 * @author zhuoHeng
 * @version 2016-08-04
 */
@Service
@Transactional
public class RestDogChipService {

	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ALL = "dog_chip@All";
	private static final String PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO = "dog_chip@Zangao";
	private static final String CHIP_FEE_ALL = "dog_chip@chip_All";
	private static final String CHIP_FEE_ZANGAO = "dog_chip@chip_Zangao";
	private static final String BLOOD_SAVE_FEE_ZANGAO = "dog_blood_save@Zangao";
	private static final String DNA_ARCHIVE_FEE_ZANGAO = "dog_dna_archive@Zangao";
	private static final String DNA_PARENTS_COMPARE_FEE_ZANGAO = "dog_dna_parents_compare@Zangao";
	private static final String CHIP_INJECT = "dog_chip@chip_inject";

	private static final String CHIP_FEE = "dog_chip_change@chipFee";
	private static final String EMBED_CHIP_FEE = "dog_chip_change@embedChipFee";
	private static final String INFO_MATCH_FEE = "dog_chip@infoMatch";
	private static final String SAVE_INFO_FEE = "dog_chip@saveInfo";
	private static final String SAVE_INFO_YOUNG_FEE = "dog_chip@saveInfoYoung";
	private static final String PEDIGREE_CERTIFIED_FEE = "dog_chip@pedigreeCertified";
	protected static final String BLOOD_SAVE_FEE = "dog_blood_save@New";
	private static final String BLOOD_SAVE_FEE_DX = "dog_blood_save_fee@New";
//	protected static final String DNA_ARCHIVE_FEE = "dog_dna_archive@New";
	// dog_dna_archive@OEC_fz dog_dna_archive@OEC_fyjs
//	public static final List<String> DNA_ARCHIVE_FEE =  java.util.Arrays.asList("56444644f3a64d1b96e53236a85e1948","c2a14ef1c2fc44d6977c69073b4bc802");
	public static final String BLOOD_SAVE_FEE_OEC = "dog_blood_save@OEC";

	protected static final String DNA_PARENTS_COMPARE_FEE = "dog_dna_parents_compare@New";
	private static final String NEW_MEMBER_FEE = "sys_member@B";
	public static final String NOSE_LINE = "dog_chip@noseline";
	// private static final String NEW_MEMBER_FEE = "sys_member@B";

	// 电子血统证书优惠，30元
	public static final double ECERT_DISCOUNTS = 30;

	@Autowired
	public DogChipService dogChipService;
	@Autowired
	private PaymentCartService paymentCartService;
	@Autowired
	private DogBirthCertificateService dogBirthCertificateService;
	@Autowired
	private PaymentChargingItemService paymentChargingItemService;
	@Autowired
	private OrgService orgService;
	@Autowired
	private MemberService memberService;
	@Autowired
	private DogBirthCertificateDao dogBirthCertificateDao;
	@Autowired
	private DogTypeService dogTypeService;
	@Autowired
	private DogBloodSaveService dogBloodSaveService;
	@Autowired
	private DogDnaArchiveService dogDnaArchiveService;
	@Autowired
	private DogDnaParentsCompareService dogDnaParentsCompareService;
	@Autowired
	public DogColorMarkDao dogColorMarkDao;
	@Autowired
	public LoginServerService loginServerService;
	@Autowired
	private DemandSensitiveWordService demandSensitiveWordService;
	@Autowired
	private OrgDogTypeLimitService orgDogTypeLimitService;
	@Autowired
	private PaymentOrderService paymentOrderService;
	@Autowired
	private DogNoseService dogNoseService;
	@Autowired
	private DogService dogService;
	@Autowired
	private DogColorMarkService dogColorMarkService;
	@Autowired
	private KennelService kennelService;
	@Autowired
	private DogStickerService dogStickerService;
	@Autowired
	private RestMemberService restMemberService;
	@Autowired
	private MemberActivity20201212Discount memberActivity20201212Discount;
	@Autowired
	private RestIDCardService restIDCardService;
	@Autowired
	private SysMemberActivityRecordDao sysMemberActivityRecordDao;
	@Autowired
	private DogChipMemberLockService dogChipMemberLockService;
	@Autowired
	private SysCouponService sysCouponService;
	@Autowired
	private DogDao dogDao;

	public RESTResponse get(String id) {
		DogChip dogChip = dogChipService.get(id);
		Member member = UserUtils.getLoginMember();
		if (dogChip == null || !member.getMemberCode().equals(dogChip.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		RestDogChip vo = new RestDogChip();
		BeanUtil.copyProperties(vo, dogChip, "yyyy-MM-dd");
		vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
		vo.setPedigreeCertified(dogChip.getDogBirthCertificate().getPedigreeCertified());
		vo.setHasChip(!dogChipService.dogChipCanCanceled(dogChip));
		vo.setCanCanceled(dogChipService.dogChipCanCanceled(dogChip));
		vo.setIdentificationFlag(dogChip.getDogBirthCertificate().getIdentificationFlag());
		String tempUserName = dogChip.getDogBirthCertificate().getTempUserName();
		if (StringUtils.isNotBlank(dogChip.getDogBirthCertificate().getPedigreeCertified())) {
			// 血统证书号不为空，取狗表犬主人
			tempUserName = dogChip.getDogOwner();
		} else {
			if (StringUtils.isBlank(tempUserName)) {
				// 血统证书号未生成，且临时犬主为空，取出生纸犬主人
				tempUserName = dogChip.getDogBirthCertificate().getDogOwenr();
			}
		}
		vo.setTempUserName(tempUserName);
		vo.setBusinessState(dogChipService.getBusinessState(dogChip));
		vo.setDogEnName(dogChip.getDogBirthCertificate().getDogEnName());
		DogType dogType = dogTypeService.getByDogBreedCode(dogChip.getDogBirthCertificate().getDogBreed());
		if (dogType != null) {
			StringBuilder dogBreed = new StringBuilder();
			dogBreed.append(dogType.getDogBreedCode());
			dogBreed.append("-");
			dogBreed.append(dogType.getBreedCnName());
			dogBreed.append("-");
			dogBreed.append(dogType.getBreedEnName());
			vo.setDogBreed(dogBreed.toString());
		}
		vo.setDogGender(DictUtils.getDictLabel(dogChip.getDogBirthCertificate().getDogGender(), "dog_gender", ""));
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		vo.setDogBirthday(sdf.format(dogChip.getDogBirthCertificate().getDogBirthday()));
		DogColorMark dogColorMark = dogColorMarkDao
				.getByDogColorMarkCode(dogChip.getDogBirthCertificate().getColorFlag());
		if (dogColorMark != null) {
			vo.setColorFlag(dogColorMark.getDogColorMarkCn());
		}
		vo.setBreeder(dogChip.getDogBirthCertificate().getBreeder());
		validateRefundState(dogChip, vo);
		return new RESTResponse("data", vo);
	}

	/**
	 * 申请退款数据
	 *
	 * @param ids
	 * @return
	 */
	public RESTResponse getRefundList(String ids, String runningNumber) {
		Member member = UserUtils.getLoginMember();
		DogChip example = new DogChip();
		example.setPaymentMemberCode(member.getMemberCode());
		example.setDelFlag("0");
		example.setRunningNumber(runningNumber);
		example.setId(ids);
		List<DogChip> dogChipList = dogChipService.findList(example);
		if (CollectionUtils.isEmpty(dogChipList)) {
			example.setId(null);
			example.setFmdogBreedCertifiedCode(ids);
			dogChipList = dogChipService.findList(example);
		}
		List<RestDogChip> list = new ArrayList<RestDogChip>();
		for (DogChip dogChip : dogChipList) {
			RestDogChip vo = new RestDogChip();
			BeanUtil.copyProperties(vo, dogChip, "yyyy-MM-dd");
			if ("1".equals(vo.getIsAll())) {
				vo.setId(vo.getFmdogBreedCertifiedCode());
			}
			vo.setReviewStateCode(vo.getReviewState());
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			vo.setPedigreeCertified(dogChip.getDogBirthCertificate().getPedigreeCertified());
			vo.setHasChip(!dogChipService.dogChipCanCanceled(dogChip));
			vo.setCanCanceled(dogChipService.dogChipCanCanceled(dogChip));
			vo.setIdentificationFlag(dogChip.getDogBirthCertificate().getIdentificationFlag());
			String tempUserName = dogChip.getDogBirthCertificate().getTempUserName();
			if (StringUtils.isNotBlank(dogChip.getDogBirthCertificate().getPedigreeCertified())) {
				// 血统证书号不为空，取狗表犬主人
				tempUserName = dogChip.getDogOwner();
			} else {
				if (StringUtils.isBlank(tempUserName)) {
					// 血统证书号未生成，且临时犬主为空，取出生纸犬主人
					tempUserName = dogChip.getDogBirthCertificate().getDogOwenr();
				}
			}
			vo.setTempUserName(tempUserName);
			if ("1".equals(vo.getReviewState())) {
				vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(), "proccess_state", ""));
			} else {
				if ("0".equals(dogChip.getDelFlag())) {
					vo.setProcessState("撤销");
				} else {
					vo.setProcessState("已撤销");
				}
			}
			vo.setBusinessState(dogChipService.getBusinessState(dogChip));
			// APP所需字段
			DogBirthCertificate dogBirthCertificate = dogChip.getDogBirthCertificate();
			vo.setBreeder(dogBirthCertificate.getBreeder());
			if (StringUtils.isNotBlank(dogBirthCertificate.getColorFlag())) {
				DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
				if (dogColorMark != null) {
					vo.setColorFlag(dogColorMark.getDogColorMarkCn());
				}
			}
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			vo.setDogBirthday(dogBirthCertificate.getDogBirthday() == null ? ""
					: sdf.format(dogBirthCertificate.getDogBirthday()));
			if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) {
				DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
				if (dogType != null) {
					vo.setDogBreed(dogType.getBreedCnName());
				}
			}
			vo.setDogGender(DictUtils.getDictLabel(dogBirthCertificate.getDogGender(), "dog_gender", ""));
			list.add(vo);
		}
		return new RESTResponse("data", list);
	}

	public RESTResponse getList(HttpServletRequest request) {

		Member member = UserUtils.getLoginMember();

		// 获取参数
		String birthCode = request.getParameter("birthCode");
		String dogBirthdayString = request.getParameter("dogBirthday");
		String applyDateString = request.getParameter("applyDate");
		String pageNo = request.getParameter("pageNo");
		String pageSize = request.getParameter("pageSize");

		// 参数校验
		int pageNoInt = 1;
		int pageSizeInt = 10;
		try {
			if (StringUtils.isNotBlank(pageNo)) {
				pageNoInt = Integer.parseInt(pageNo);
			}
			if (StringUtils.isNotBlank(pageSize)) {
				pageSizeInt = Integer.parseInt(pageSize);
			}
		} catch (Exception e) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "pageNo和pageSize必须都为数字");
		}

		DogChip example = new DogChip();
		// 设置分页参数
		Page<DogChip> page = new Page<DogChip>();
		page.setPageNo(pageNoInt);
		page.setPageSize(pageSizeInt);
		// 设置查询条件
		example.setPaymentMemberCode(member.getMemberCode());
		example.setPage(page);
		if (StringUtils.isNotBlank(birthCode)) {
			example.setBirthCode(birthCode);
		}
		// APP端根据出生日期查询
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if (StringUtils.isNotBlank(dogBirthdayString)) {
			Date dogBirthday;
			try {
				dogBirthday = sdf.parse(dogBirthdayString);
			} catch (ParseException e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生日期格式不对");
			}
			DogBirthCertificate dogBirthCertificate = new DogBirthCertificate();
			dogBirthCertificate.setDogBirthday(dogBirthday);
			example.setDogBirthCertificate(dogBirthCertificate);
		}
		// APP端根据申请日期查询
		if (StringUtils.isNotBlank(applyDateString)) {
			Date applyDate;
			try {
				applyDate = sdf.parse(applyDateString);
			} catch (ParseException e) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "申请日期格式不对");
			}
			example.setApplyDate(applyDate);
		}
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}

		// 查询并组装返回对象
		Page<DogChip> result = dogChipService.findPage(page, example);
		List<DogChip> dogChipList = result.getList();

		List<RestDogChip> list = new ArrayList<RestDogChip>();
		for (DogChip dogChip : dogChipList) {
			RestDogChip vo = new RestDogChip();
			BeanUtil.copyProperties(vo, dogChip, "yyyy-MM-dd");
			vo.setReviewState(DictUtils.getDictLabel(vo.getReviewState(), "review_state", ""));
			vo.setPedigreeCertified(dogChip.getDogBirthCertificate().getPedigreeCertified());
			// vo.setHasChip(!dogChipService.dogChipCanCanceled(dogChip));
			// vo.setCanCanceled(dogChipService.dogChipCanCanceled(dogChip));
			boolean canceledResult = dogChipService.dogChipCanCanceled(dogChip);
			vo.setHasChip(!canceledResult);
			vo.setCanCanceled(canceledResult);
			vo.setDogEnName(dogChip.getDogBirthCertificate().getDogEnName());
			// 校验可撤销状态为true时，增加校验是否已退款校验
			this.validateRefundState(dogChip, vo);
			if (vo.isCanCanceled()) {
				String businessIds = null;
				if ("1".equals(dogChip.getIsAll())) {
					businessIds = dogChip.getFmdogBreedCertifiedCode();
				} else {
					businessIds = dogChip.getId();
				}
				vo.setCanCanceled(paymentOrderService.getCanCanceledByBusinessIdAOrderCode(businessIds,
						dogChip.getRunningNumber()));
				vo.setCanEdit(vo.isCanCanceled());
			}
			vo.setIdentificationFlag(dogChip.getDogBirthCertificate().getIdentificationFlag());
			String tempUserName = dogChip.getDogBirthCertificate().getTempUserName();
			if (StringUtils.isNotBlank(dogChip.getDogBirthCertificate().getPedigreeCertified())) {
				// 血统证书号不为空，取狗表犬主人
				tempUserName = dogChip.getDogOwner();
			} else {
				if (StringUtils.isBlank(tempUserName)) {
					// 血统证书号未生成，且临时犬主为空，取出生纸犬主人
					tempUserName = dogChip.getDogBirthCertificate().getDogOwenr();
				}
			}
			vo.setTempUserName(tempUserName);
			if ("1".equals(vo.getReviewState())) {
				vo.setProcessState(DictUtils.getDictLabel(vo.getProcessState(), "proccess_state", ""));
			} else {
				if ("0".equals(dogChip.getDelFlag())) {
					vo.setProcessState("撤销");
				} else {
					vo.setProcessState("已撤销");
				}
			}
			vo.setBusinessState(dogChipService.getBusinessState(dogChip));
			// APP所需字段
			DogBirthCertificate dogBirthCertificate = dogChip.getDogBirthCertificate();
			vo.setBreeder(dogBirthCertificate.getBreeder());
			if (StringUtils.isNotBlank(dogBirthCertificate.getColorFlag())) {
				// 优化
				DogColorMark dogColorMark = dogColorMarkDao.getByDogColorMarkCode(dogBirthCertificate.getColorFlag());
				if (dogColorMark != null) {
					vo.setColorFlag(dogColorMark.getDogColorMarkCn());
				}
			}
			vo.setDogBirthday(dogBirthCertificate.getDogBirthday() == null ? ""
					: sdf.format(dogBirthCertificate.getDogBirthday()));
			if (StringUtils.isNotBlank(dogBirthCertificate.getDogBreed())) {
				// 优化
				DogType dogType = dogTypeService.getByDogBreedCode(dogBirthCertificate.getDogBreed());
				if (dogType != null) {
					vo.setDogBreed(dogType.getBreedCnName());
				}
			}
			vo.setDogGender(DictUtils.getDictLabel(dogBirthCertificate.getDogGender(), "dog_gender", ""));
			PaymentOrder paymentOrder = paymentOrderService.getByOrderCode(vo.getRunningNumber());
			vo.setOrderId(paymentOrder == null ? "" : paymentOrder.getId());
			vo.setPrice(paymentOrder == null ? "" : paymentOrder.getTotalPrice());
			vo.setBusinessName("新生犬血统证书");

			DogNose dogNose = new DogNose();
			// 优化
			DogBirthCertificate birthObj = dogBirthCertificateService.getByBirthCerRegCode(dogChip.getBirthCode());
			List<DogNose> noseList = null;
			if (birthObj != null) {
				dogNose.setDogBirthCertificateId(birthObj.getId());
				dogNose.setDelFlag("0");
				noseList = dogNoseService.findList(dogNose);
			}
			vo.setDogNose(!CollectionUtils.isEmpty(noseList));
			// 增加返回dog_id
			Dog dog = dogService.getByPedigreeCertifiedCode(vo.getPedigreeCertified());
			vo.setDogId(dog != null ? dog.getId() : null);
			list.add(vo);
		}
		long count = result.getCount();
		return new RESTResponse("list", new PageBeanResult<RestDogChip>(list, count));
	}

	@Transactional(readOnly = false)
	public RESTResponse delete(String id) {
		Member member = UserUtils.getLoginMember();
		DogChip po = dogChipService.get(id);
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// 已上传芯片新生犬登记记录不可以撤销
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(po.getBirthCode());
		if (StringUtils.isNotBlank(dogBirthCertificate.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已上传芯片,不可以撤销");
		}
		dogChipService.delete(po);
		// delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}

	@Transactional(readOnly = false)
	public RESTResponse post(String json, HttpServletRequest request) {
		// 获取参数
		Map<String, Class<?>> classMap = new HashMap<>();
		classMap.put("checkedCoupon", RestCouponGroup.class);
		RestDogChip vo = BeanUtil.toBean(json, RestDogChip.class, classMap);
		vo.setIsDnaParentsCompare("0");// 前台不发起双亲比对
		// 参数校验
		validateParameter(vo, request);
		// 将新犬主会员号字母转换大写
		// vo.setNewDogOwnerCode(vo.getNewDogOwnerCode().toUpperCase().trim());
		// 获取出生纸
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(vo.getBirthCode());
		// 校验犬只是否能办理当前登录类型的业务
		loginServerService.validBirthDogType(dogBirthCertificate);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号有误");
		}
		if (StringUtils.isNotBlank(vo.getSnCode())
				&& !vo.getSnCode().toUpperCase().equals(dogBirthCertificate.getSnCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡识别码有误");
		}
		if (StringUtils.isNotBlank(vo.getIdentificationFlag())
				&& !vo.getIdentificationFlag().trim().equals(dogBirthCertificate.getIdentificationFlag().trim())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "芯片号有误");
		}

		// 校验当然登录人是否有效会员
		Member member2 = UserUtils.getLoginMember();
		// 当前账号会员有效
		if (!MemberUtil.isActiveMember(member2)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "当前会员为无效会员，请进行续费后再申请");
		}

		// TODO@zhangjuwu 优惠券包业务
		// 如果选择优惠券，则校验犬只年龄12月及以上，办理人必须为银卡会员以上,办理人必须为犬主或繁殖人
		if (Objects.nonNull(vo.getCheckedCoupon())) {
			if (!DateUtils.isInOneYearOld(dogBirthCertificate.getDogBirthday())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券限犬只年龄12月内（含12月）使用");
			}
			if (!member2.getMemberCode().equals(vo.getNewDogOwnerCode())
					&& !member2.getMemberCode().equals(dogBirthCertificate.getBreederMemberCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券限申请人为繁殖人或犬主人时使用");
			}
		}

		// 新会员
		String memberCode = "";

		RestRenew restRenew = null;
		// 新注册犬主
		if (StringUtils.isNotBlank(vo.getNewMemberFlag()) && "1".equals(vo.getNewMemberFlag())) {
			LoginServer loginServer = loginServerService.getLoginServerByClub(request);
			memberCode = SysCodeUtil.getMemberCode();
			if (StringUtils.isNotBlank(loginServer.getMemberSite()) && !"0".equals(loginServer.getMemberSite())) {
				memberCode = loginServer.getUserShortName().toUpperCase() + memberCode;
			}
			vo.getNewMember().setGender("male");
			vo.getNewMember().setMemberType("basic");
			vo.getNewMember().setMemberCode(memberCode);

			vo.getNewMember().setMemberSite(loginServer.getMemberSite());
			vo.getNewMember().setMemberCardType(MemberCardTypeEnum.SILVER_CARD.code());
			vo.getNewMember().setReferee(member2.getMemberCode());
			memberService.save(vo.getNewMember());
		} else {
			memberCode = vo.getNewDogOwnerCode();
			Member newMember = memberService.getByMemberCode(memberCode);
			if (!MemberUtil.isActiveMember(newMember)) {
				// 过期犬主收费项
				restRenew = restMemberService.getRenewInfo(memberCode);
				if (restRenew.getCardType() == 0) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
							"新犬主需为CKU爱宠银卡会员或以上会员，现新犬主为CKU爱宠普卡会员，请升级后继续办理该业务");
				}
				if (restRenew.getCardType() == 30
						&& !newMember.getMemberEndDate().equals(newMember.getKennel().getEndTime())) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
							"新犬主会员截至日期和犬舍截至日期不同步，需登录宠爱王国APP完成会员日期同步后方可继续办理该业务");
				}
			}
		}
		// 新犬主赋值
		vo.setNewDogOwnerCode(memberCode);
		// 构造持久对象
		DogChip po = buildPo(vo, dogBirthCertificate);

		if (StringUtils.isNotBlank(vo.getHospitalCode())) {
			// 判断是否可申请该单犬种俱乐部
			orgDogTypeLimitService.checkSingleTypeClub(vo.getHospitalCode(), dogBirthCertificate.getDogBreed());
		}

		// 业务校验
		dogChipService.validateBusiness(po, dogBirthCertificate);
		// 出生纸表中增加新犬主会员号和名字的临时存储
		Member member = memberService.getByMemberCode(vo.getNewDogOwnerCode());
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主会员号有误");
		}
		// 判断新犬主与申请人为同一站点会员
		if (!((StringUtils.isBlank(member.getMemberSite()) && StringUtils.isBlank(member2.getMemberSite()))
				|| (member.getMemberSite() == null ? "" : member.getMemberSite()).equals(member2.getMemberSite()))) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主与申请人会员站点不同，不能进行新生犬登记");
		}

		// 新犬主会员必须有效 --》 改为代缴
		if (StringUtils.isBlank(vo.getNewMemberFlag()) && "0".equals(vo.getNewMemberFlag())) {
			if (!MemberUtil.isActiveMember(member)) {
				// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED,
				// "新犬主为无效会员，请新犬主缴费后再进行新生犬登记");
			}
		}
		// 新生犬登记信息申请后需对出生纸表中的临时犬主信息进行存储 by zhuoHeng
		dogBirthCertificateDao.updateTempDogOwner(vo.getBirthCode(), member.getMemberCode(), member.getName());

		String businessOrderCode = IdGen.uuid();
		StringBuilder cartIds = new StringBuilder();

		// 新生犬登记业务
		String dogChipCartId = dogChip(dogBirthCertificate, po, businessOrderCode);
		cartIds.append(dogChipCartId);

		// 建档费服务费 业务
		String saveInfoCartId = saveInfo(dogBirthCertificate, po, businessOrderCode);
		cartIds.append(",").append(saveInfoCartId);

		// 新生幼犬CKU血统证书业务
		String pedigreeCertifiedCartId = pedigreeCertified(po, businessOrderCode);
		cartIds.append(",").append(pedigreeCertifiedCartId);
		// dnaSaveWay DNA留存方式:血样留存0；DNA位点分析1；暂不留存2
		if ("0".equals(po.getDnaSaveWay()) && "1".equals(po.getHaddleWay())) {
			if (StringUtils.isBlank(vo.getHospitalCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作医院编号为空");
			}
			// 血样留存业务
			String bloodSaveCartId = bloodSaveAPP(dogBirthCertificate, po, businessOrderCode, vo.getHospitalCode());
			cartIds.append(",").append(bloodSaveCartId);
			String noseLineCartId = noseLine(dogBirthCertificate, po, businessOrderCode);
			cartIds.append(",").append(noseLineCartId);
		} else if ("1".equals(po.getDnaSaveWay()) && "1".equals(po.getHaddleWay())) {
			if (StringUtils.isBlank(vo.getHospitalCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作医院编号为空");
			}
			// DNA位点分析业务
			String dnaArchiveCartId = dnaArchive(dogBirthCertificate, po, businessOrderCode, vo.getHospitalCode());
			cartIds.append(",").append(dnaArchiveCartId);
			// 血样留存业务
			String bloodSaveCartId = bloodSaveAPP(dogBirthCertificate, po, businessOrderCode, vo.getHospitalCode());
			cartIds.append(",").append(bloodSaveCartId);
			if ("1".equals(po.getIsDnaParentsCompare())) {
				// DNA双亲比对业务
				String dnaParentsCompareCartId = dnaParentsCompare(dogBirthCertificate, po, businessOrderCode);
				cartIds.append(",").append(dnaParentsCompareCartId);
			}
		} else {
			// 血样留存业务 --》 改为鼻纹
			String noseLineCartId = noseLine(dogBirthCertificate, po, businessOrderCode);
			cartIds.append(",").append(noseLineCartId);
		}

		List<PaymentCartVO> cartsT = paymentCartService.findListByIds(Arrays.asList(cartIds.toString().split(",")),
				UserUtils.getLoginMember().getMemberCode());
		// 计算优惠券能抵扣的金额
		Double canDeductPrice = cartsT.stream()
				.filter(cart -> ConstantUtils.DOGCHIPAPPLY_DEDUCT_ITEM.contains(cart.getChargingItemId()))
				.mapToDouble(a -> Double.parseDouble(a.getTotalPrice())).sum();
		// TODO@zhangjuwu 优惠券包业务
		if (Objects.nonNull(vo.getCheckedCoupon())) {
			RestCouponGroup couponGroup = vo.getCheckedCoupon();
			SysCoupon sysCoupon = sysCouponService.getOneByGroupId(couponGroup.getGroupId());
			if (Objects.isNull(sysCoupon)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券不存在，请重新选择优惠券！");
			}
			// 校验此券是否为可用类型及有效期
			if (!ConstantUtils.COUPON_TARGET_DOGCHIPAPPLY.equals(sysCoupon.getTarget())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "此券非血统证书代金券，暂不可用！");
			}
			if ("2".equals(sysCoupon.getUseState()) || sysCoupon.getValidDate().before(new Date())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券已经过期，暂不可用！");
			}
			if ("1".equals(sysCoupon.getUseState())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券已使用，暂不可用！");
			}
			if ((Objects.nonNull(canDeductPrice) ? canDeductPrice : 0d) < Double
					.parseDouble(sysCoupon.getFacePrice())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券不符合可用条件，暂不可用！");
			}
			// 在购物车里面增加一条优惠券减免收费项，并把ID加到订单ID参数里面
			PaymentChargingItem couponXN = paymentChargingItemService
					.getByShortName("sys_coupon@" + sysCoupon.getTarget() + "_" + sysCoupon.getFacePrice());
			if (couponXN == null) {
				throw new ZAException(ZAErrorCode.ZA_ERROR, "此券还没有收费项，暂不可用！");
			}
			// 需要新建收费项
			PaymentCart paymentCart = new PaymentCart();
			paymentCart.setChargingItemId(couponXN.getId());
			paymentCart.setChargingItemName(couponXN.getName());
			// 计算可以减免多少钱
			if (canDeductPrice - Double.parseDouble(sysCoupon.getFacePrice()) > 0) {// 计算后总价不能小于0
				paymentCart.setPrice(String.valueOf(0 - Double.parseDouble(sysCoupon.getFacePrice())));
			} else {
				paymentCart.setPrice(String.valueOf(0 - canDeductPrice));
			}
			paymentCart.setTotalPrice(paymentCart.getPrice());
			po.setFloatingPrice(po.getFloatingPrice().subtract(new BigDecimal(paymentCart.getPrice()).abs()));
			paymentCart.setNum("1");
			paymentCart.setBusinessTable("sys_coupon");
			paymentCart.setBusinessIds(po.getId());
			paymentCart.setBusinessOrderCode(businessOrderCode);
			paymentCart.setCouponNum("1");
			paymentCartService.addBusinessManage(paymentCart, "1004");
			String cid = paymentCartService.addToCartFCoupon(paymentCart);
			cartIds.append(",").append(cid);
			// 把券置为已用
			sysCoupon.setUseState("1");
			sysCoupon.setTargetId(po.getId());
			sysCoupon.preUpdate();
			sysCouponService.save(sysCoupon);
		}

		dogChipService.updateBusinessPrice(po);

		// 新会员注册
		if ("1".equals(vo.getNewMemberFlag())) {
			String newMemberCartId = newMemberSave(po, businessOrderCode,
					memberService.getByMemberCode(memberCode).getId(), memberCode);
			cartIds.append(",").append(newMemberCartId);
		}
		// 会员续费
		// if (!CollectionUtils.isEmpty(renewItem)) {
		// for (String items : renewItem) {
		// PaymentCart paymentCart = new PaymentCart();
		// PaymentChargingItem item = paymentChargingItemService.getByShortName(items);
		// paymentCart.setChargingItemId(item.getId());
		// paymentCart.setChargingItemName(item.getName());
		// paymentCart.setNum("1");
		// paymentCart.setPrice(item.getPrice());
		// paymentCart.setTotalPrice(item.getPrice());
		// paymentCart.setBusinessTable("sys_member");
		// paymentCart.setBusinessIds(memberService.getByMemberCode(memberCode).getId());
		// paymentCart.setBusinessOrderCode(businessOrderCode);
		// PaymentCart cart = paymentCartService.addBusinessManage(paymentCart, "1021");
		// paymentCartService.addToCart(cart, "1021");
		// cartIds.append(",").append(cart.getId());
		// }
		// }
		if (restRenew != null && restRenew.getMember() != null
				&& !CollectionUtils.isEmpty(restRenew.getMember().getPaymentItems())) {
			for (RestRenewPaymentItem items : restRenew.getMember().getPaymentItems()) {
				PaymentCart paymentCart = new PaymentCart();
				PaymentChargingItem item = paymentChargingItemService.getByShortName(items.getShortName());
				paymentCart.setChargingItemId(item.getId());
				paymentCart.setChargingItemName(item.getName());
				paymentCart.setNum("1");
				paymentCart.setPrice(item.getPrice());
				paymentCart.setTotalPrice(item.getPrice());
				paymentCart.setBusinessTable("sys_member");
				paymentCart.setBusinessIds(memberService.getByMemberCode(memberCode).getId());
				// 代缴信息
				paymentCart.setBusinessOrderCode(restRenew.getRenewType() + "-" + businessOrderCode);
				PaymentCart cart = paymentCartService.addBusinessManage(paymentCart, "1021");
				paymentCartService.addToCart(cart, "1021");
				cartIds.append(",").append(cart.getId());
			}
		}

		if (restRenew != null && restRenew.getMember() != null
				&& !CollectionUtils.isEmpty(restRenew.getKennel().getPaymentItems())) {
			for (RestRenewPaymentItem items : restRenew.getKennel().getPaymentItems()) {
				PaymentCart paymentCart = new PaymentCart();
				PaymentChargingItem item = paymentChargingItemService.getByShortName(items.getShortName());
				paymentCart.setChargingItemId(item.getId());
				paymentCart.setChargingItemName(item.getName());
				paymentCart.setNum("1");
				paymentCart.setPrice(item.getPrice());
				paymentCart.setTotalPrice(item.getPrice());
				paymentCart.setBusinessTable("kennel");
				paymentCart.setBusinessIds(kennelService.getKennelByMemberCode(memberCode).getId());
				paymentCart.setBusinessOrderCode(restRenew.getRenewType() + "-" + businessOrderCode);
				PaymentCart cart = paymentCartService.addBusinessManage(paymentCart, "1021");
				paymentCartService.addToCart(cart, "1021");
				cartIds.append(",").append(cart.getId());
			}
		}
		String groupId = null;
		if (StringUtils.isNotBlank(vo.getNewMemberFlag()) && "1".equals(vo.getNewMemberFlag())) {
			groupId = "9991009101010";
		} else if (restRenew != null && StringUtils.isNotBlank(restRenew.getRenewType())) {
			groupId = restRenew.getRenewType();
		}
		if (StringUtils.isNotBlank(groupId)) {
			// 记录
			Member memberExt = memberService.findMemberAndKennelByMemberCode(memberCode);
			SysMemberActivityRecord record = new SysMemberActivityRecord();
			record.setId(IdGen.uuid());
			record.setActivityType(groupId);
			record.setGroomerType(memberExt.getGroomerType());
			record.setMemberType(memberExt.getMemberType());
			record.setMemeberCode(memberExt.getMemberCode());
			record.setMemeberName(memberExt.getName());
			if (memberExt.getKennel() != null) {
				record.setKennelCode(memberExt.getKennel().getKennelCode());
				record.setKennelEndDate(memberExt.getKennel().getEndTime());
				record.setKennelName(memberExt.getKennel().getName());
				record.setKennelType(memberExt.getKennel().getType());
			}
			record.setCreateDate(new Date());
			record.setGiveGift("0");
			record.setParticipationTime(new Date());
			record.setRecordType("2");
			record.setMemberEndDate(memberExt.getMemberEndDate());
			record.setGroomerEndDate(memberExt.getGroomerEndDate());
			record.setOrderCode(businessOrderCode);
			record.setMemberCardType(memberExt.getMemberCardType());
			record.setCreateBy(member2.getCreateBy());
			// 20201212活动
			memberActivity20201212Discount.buildDogChip20201212Discount(businessOrderCode, cartIds, record);
			sysMemberActivityRecordDao.insert(record);

		}

		return new RESTResponse("data", cartIds.toString());
	}

	protected String bloodSaveAPP(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode,
			String orgId) {// 单独申请时不能减免费用
		StringBuilder cartIds = new StringBuilder();
		List<PaymentChargingItem> items = getBloodSaveItems(dogBirthCertificate, po.getDnaSaveWay());
		Double price = items.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();

		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		dogBloodSave.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		dogBloodSave.setPrice(price.toString());
		po.setFloatingPrice(po.getFloatingPrice().add(new BigDecimal(price)));
		dogBloodSave.setOrgId(orgId);
		dogBloodSave.setPaymentState("1");
		dogBloodSave.setIsOEC(po.getDnaSaveWay());// 是否为口腔上皮细胞测试法:否0；是1
		dogBloodSaveService.save(dogBloodSave);
		items.stream().forEach(item -> {
			PaymentCart cart = null;
			if (RestDogChipService.NOSE_LINE.equals(item.getShortName())) {
				cart = getNoseCart(po, businessOrderCode);
			} else {
				cart = getBloodSaveCart(item, dogBloodSave, businessOrderCode);
			}

			paymentCartService.addToCart(cart, "1004");
			cartIds.append(",").append(cart.getId());
		});
		return cartIds.toString();
	}

	/**
	 * @description: 参数校验
	 * @author: laiguanglong
	 * @date: 2016年9月9日 上午9:41:47
	 */
	private void validateParameter(RestDogChip vo, HttpServletRequest request) {
		if (StringUtils.isBlank(vo.getBirthCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
		}
		if (StringUtils.isBlank(vo.getSnCode()) && StringUtils.isBlank(vo.getIdentificationFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请输入新生犬登记卡识别码或芯片号");
		}
		if (StringUtils.isBlank(vo.getNewMemberFlag()) || "0".equals(vo.getNewMemberFlag())) {
			if (StringUtils.isBlank(vo.getNewDogOwnerCode())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬主会员号为空");
			}
		}
		if ("1".equals(vo.getHaddleWay()) && StringUtils.isBlank(vo.getHospitalCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作医院编号为空");
		}
		if (StringUtils.isBlank(vo.getDnaSaveWay())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式为空");
		}
//		if (StringUtils.isBlank(vo.getIsDnaParentsCompare())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位为空");
//		}
		if (!"0".equals(vo.getDnaSaveWay()) && !"1".equals(vo.getDnaSaveWay()) && !"2".equals(vo.getDnaSaveWay())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式只能为0或1或2");
		}
//		if (!"0".equals(vo.getIsDnaParentsCompare()) && !"1".equals(vo.getIsDnaParentsCompare())) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位只能为0或1");
//		}
		// 新会员
		if (StringUtils.isNotBlank(vo.getNewMemberFlag()) && "1".equals(vo.getNewMemberFlag())) {
			if (vo.getNewMember() == null) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写会员信息");
			}
			Member member = vo.getNewMember();
			if (StringUtils.isBlank(member.getName())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写会员姓名");
			}
			if (StringUtils.isBlank(member.getCardNo())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写证件编号");
			}
			if (StringUtils.isBlank(member.getMobile())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写联系电话");
			}
			if (StringUtils.isBlank(member.getProvince()) || StringUtils.isBlank(member.getCity())
					|| StringUtils.isBlank(member.getStreet())) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "请填写邮寄地址");
			}

			if (StringUtils.isNotBlank(member.getCardNo())) {
				// 验证实名
				LoginServer loginServer = loginServerService.getLoginServerByClub(request);
				Integer i = restIDCardService.validateIDCard(null, member.getCardNo(), member.getName(),
						loginServer.getMemberSite(), true);
				if (i != 1) {
					throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "身份信息验证失败");
				}
			}
		}
	}

	/**
	 * @description: 构造持久对象
	 * @author: laiguanglong
	 * @date: 2016年9月13日 下午5:56:52
	 */
	private DogChip buildPo(RestDogChip vo, DogBirthCertificate dogBirthCertificate) {
		DogChip po = new DogChip();
		po.setBirthCode(vo.getBirthCode());
		Member member = memberService.getByMemberCode(vo.getNewDogOwnerCode());
		// 可替他人付款
		po.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());

		if (StringUtils.isNotBlank(vo.getHospitalCode())) {
			// 合作医院
			Org org = orgService.get(vo.getHospitalCode());
			if (org != null) {
				po.setHospitalName(org.getName());
				po.setHospitalCode(org.getId());
				// 更新出生纸的临时会员信息及addUser字段
				dogBirthCertificate.setAddUser(org.getUser().getLoginName());
			}
		}

		dogBirthCertificate.setTempMemberCode(member.getMemberCode());
		dogBirthCertificate.setTempUserName(member.getName());
		// dogBirthCertificate.setEcertFlag(vo.getEcertFlag());
		dogBirthCertificateService.save(dogBirthCertificate);
		po.setPrice(getDogChipPrice(dogBirthCertificate, vo.getEcertFlag()));
		po.setFloatingPrice(new BigDecimal(po.getPrice()));
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		po.setCallName(vo.getCallName());
		po.setPrintState("0");
		po.setHaddleWay(vo.getHaddleWay());
		po.setIsAll(vo.getIsAll() == null ? "0" : vo.getIsAll());
		po.setDnaSaveWay(vo.getDnaSaveWay());
		po.setIsDnaParentsCompare(vo.getIsDnaParentsCompare());
		if ("1".equals(vo.getEcertFlag())) {
			po.setEcertFlag("1");
		}
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		if ("1".equals(vo.getStickerFlag())) {
//			po.setStickerFlag("1");
//		}
		po.setStickerFlag("0");
		return po;
	}

	public RESTResponse getPrice(HttpServletRequest request) {
		// 获取参数
		String birthCode = request.getParameter("birthCode");
		String dnaSaveWay = request.getParameter("dnaSaveWay");
		String isDnaParentsCompare = request.getParameter("isDnaParentsCompare");
		String ecertFlag = request.getParameter("ecertFlag");
		if (StringUtils.isBlank(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生证明编号为空");
		}
		if (StringUtils.isBlank(dnaSaveWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式为空");
		}
		if (StringUtils.isBlank(isDnaParentsCompare)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位为空");
		}
		if (!"0".equals(dnaSaveWay) && !"1".equals(dnaSaveWay) && !"2".equals(dnaSaveWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式只能为0或1或2");
		}
		if (!"0".equals(isDnaParentsCompare) && !"1".equals(isDnaParentsCompare)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位只能为0或1");
		}
		if (!"1".equals(dnaSaveWay) && "1".equals(isDnaParentsCompare)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有选择DNA位点分析的情况下才能选择DNA双亲比对");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生证明编号有误");
		}
		// 是否为新犬主 非空或者1为新犬主[
		String newMember = request.getParameter("newMember");
		String memberCode = request.getParameter("memberCode");
		JSONObject jo = new JSONObject();
		List<PaymentChargingItem> chargingItemResult = getTotalPrice(dogBirthCertificate, dnaSaveWay,
				isDnaParentsCompare, ecertFlag, newMember, memberCode);
		Double totalPrice = chargingItemResult.stream().mapToDouble(a -> Double.parseDouble(a.getPrice())).sum();
		jo.put("price", String.format("%.2f", totalPrice));
		return new RESTResponse("data", jo);
	}

	public RestDogChipPriceResultDto getPriceWithCoupon(RestDogChipApplyCommonDto request) {
		// 获取参数
		String birthCode = request.getBirthCode();
		String dnaSaveWay = request.getDnaSaveWay();
//		String isDnaParentsCompare = request.getIsDnaParentsCompare();
		String ecertFlag = request.getEcertFlag();
		if (StringUtils.isBlank(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生证明编号为空");
		}
		if (StringUtils.isBlank(dnaSaveWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式为空");
		}
//		if (StringUtils.isBlank(isDnaParentsCompare)) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位为空");
//		}
		if (!"0".equals(dnaSaveWay) && !"1".equals(dnaSaveWay) && !"2".equals(dnaSaveWay)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA留存方式只能为0或1或2");
		}
//		if (!"0".equals(isDnaParentsCompare) && !"1".equals(isDnaParentsCompare)) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "DNA双亲比对标记位只能为0或1");
//		}
//		if (!"1".equals(dnaSaveWay) && "1".equals(isDnaParentsCompare)) {
//			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有选择DNA位点分析的情况下才能选择DNA双亲比对");
//		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "出生证明编号有误");
		}
		List<PaymentChargingItem> chargingItemResult = getTotalPrice(dogBirthCertificate, dnaSaveWay, null, ecertFlag,
				request.getNewMember(), request.getMemberCode());
		Double totalPrice = chargingItemResult.stream().mapToDouble(a -> Double.parseDouble(a.getPrice())).sum();
		// 计算优惠券可抵扣金额
		Double canDeductPrice = chargingItemResult.stream()
				.filter(cart -> ConstantUtils.DOGCHIPAPPLY_DEDUCT_ITEM.contains(cart.getId()))
				.mapToDouble(a -> Double.parseDouble(a.getPrice())).sum();
		AtomicDouble couponPrice = new AtomicDouble(BigDecimal.ZERO.doubleValue());

		if (request instanceof RestDogChipPriceDto
				&& Objects.nonNull(((RestDogChipPriceDto) request).getCheckedCoupon())) {
			RestCouponGroup couponGroup = ((RestDogChipPriceDto) request).getCheckedCoupon();
			SysCoupon sysCoupon = sysCouponService.getOneByGroupId(couponGroup.getGroupId());
			if (Objects.nonNull(couponPrice)) {
				couponPrice.addAndGet(Double.parseDouble(sysCoupon.getFacePrice()));
			} else {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "优惠券不存在，请重新选择优惠券！");
			}
		}
		totalPrice = totalPrice
				- (couponPrice.doubleValue() > canDeductPrice ? canDeductPrice : couponPrice.doubleValue());
		return RestDogChipPriceResultDto.builder().price(String.format("%.2f", totalPrice)).items(chargingItemResult)
				.build();
	}

	/**
	 * @description: 血统证书费用
	 * @author: laiguanglong
	 * @date: 2016年9月20日 下午3:27:25
	 */
	public String getFee(DogBirthCertificate dogBirthCertificate) {
		/*
		 * 幼犬出生4个月内申请血统书价格为180元/份，芯片150元/只； 5、幼犬出生4至12个月内申请血统书价格为200元/份，芯片150元/只；
		 * 6、幼犬出生12个月以上申请血统书价格为500元/份，芯片150元/只，同时幼犬必须采集DNA样本（超龄后不能在地方合作机构埋植）；
		 */
		// 计算血统证书费用
		String fee = null;
		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
			String shortName = PAYMENTCHARGINGITEM_SHORTNAME_ALL;
			if ("230".equals(dogBirthCertificate.getDogBreed())) {
				shortName = PAYMENTCHARGINGITEM_SHORTNAME_ZANGAO;
			}
			PaymentChargingItem paymentChargingItem = paymentChargingItemService.getByShortName(shortName);
			fee = paymentChargingItem.getPrice();
			// 4月龄办理血统证书优惠20元取消 by yuanshuai 2019年3月20日10:51:39
			// if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(),4)) {
			// Double temp = Double.valueOf(fee) - 20;
			// fee = temp.toString();
			// }
		} else if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 24)) {
			// 一岁到两岁之前的犬只申请时证书费变为500元，同时DNA留存方式默认为位点分析（不能修改），同时不享受任何优惠政策（芯片减免、出生纸抵扣等）
			return "500";
		} else {
			// 两岁以上犬只无法办理
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过24个月，不允许办理新生犬登记");
		}
		// 判断出生纸是否抵扣
		String deduction = dogBirthCertificate.getDeduction();
		// 2月龄办理出生纸，办理血统证书抵扣50元，时限由12月龄改为6月龄 by yuanshuai 2019年3月20日10:51:57
		if ("1".equals(deduction) && DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 6)) {
			Double temp = Double.valueOf(fee) - 50;
			fee = temp.toString();
		}
		return fee;
	}

	/**
	 * @description: dog_chip表订单费用
	 * @author: laiguanglong
	 * @date: 2016年9月20日 下午4:03:03
	 */
	public String getDogChipPrice(DogBirthCertificate dogBirthCertificate) {
		return getDogChipPrice(dogBirthCertificate, null);
	}

	public String getDogChipPrice(DogBirthCertificate dogBirthCertificate, String ecertFlag) {
		Double totalPrice = 0d;
		if (StringUtils.isBlank(dogBirthCertificate.getIdentificationFlag())) {
			// 旧出生纸：芯片费、电子芯片埋植服务费
			PaymentChargingItem chipItem = getChipItem();
			totalPrice += Double.parseDouble(chipItem.getPrice());
			PaymentChargingItem chipEmbedItem = getChipEmbedItem();
			totalPrice += Double.parseDouble(chipEmbedItem.getPrice());
		} else {
			// 新出生纸：信息管理费（信息匹配）
			PaymentChargingItem infoMatchItem = getInfoMatchItem();
			totalPrice += Double.parseDouble(infoMatchItem.getPrice());
		}

		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
			// 1岁内：建档费服务费（新生幼犬）
			PaymentChargingItem saveInfoItem = getSaveInfoItem(dogBirthCertificate.getBirthCerRegCode(), ecertFlag);
			totalPrice += Double.parseDouble(saveInfoItem.getPrice());
		} else if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 24)) {
			// 1岁-2岁：建档费服务费（青年犬）
			PaymentChargingItem saveInfoYoungItem = getSaveInfoYoungItem(ecertFlag);
			totalPrice += Double.parseDouble(saveInfoYoungItem.getPrice());
		} else {
			// 两岁以上犬只无法办理
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过2岁，不允许办理新生犬登记");
		}

		// 新生幼犬CKU血统证书费
		PaymentChargingItem pedigreeCertifiedItem = getPedigreeCertifiedItem();
		totalPrice += Double.parseDouble(pedigreeCertifiedItem.getPrice());
		// 合计
		return totalPrice.toString();
	}

	/**
	 * @description: 总订单费用
	 * @author: laiguanglong
	 * @date: 2016年9月20日 下午4:03:03
	 */
	public List<PaymentChargingItem> getTotalPrice(DogBirthCertificate dogBirthCertificate, String dnaSaveWay,
			String isDnaParentsCompare, String ecertFlag, String newMember, String memberCode) {
		List<PaymentChargingItem> chargingItemResult = new ArrayList<>();
		if (StringUtils.isBlank(dogBirthCertificate.getIdentificationFlag())) {
			// 旧出生纸：芯片费、电子芯片埋植服务费
			PaymentChargingItem chipItem = getChipItem();
			chargingItemResult.add(chipItem);
			PaymentChargingItem chipEmbedItem = getChipEmbedItem();
			chargingItemResult.add(chipEmbedItem);
		} else {
			// 新出生纸：信息管理费（信息匹配）
			PaymentChargingItem infoMatchItem = getInfoMatchItem();
			chargingItemResult.add(infoMatchItem);
		}
		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
			// 1岁内：建档费服务费（新生幼犬）
			PaymentChargingItem saveInfoItem = getSaveInfoItem(dogBirthCertificate.getBirthCerRegCode(), ecertFlag);
			chargingItemResult.add(saveInfoItem);
		} else if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 24)) {
			// 1岁-2岁：建档费服务费（青年犬）
			PaymentChargingItem saveInfoYoungItem = getSaveInfoYoungItem(ecertFlag);
			chargingItemResult.add(saveInfoYoungItem);
		} else {
			// 两岁以上犬只无法办理
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过2岁，不允许办理新生犬登记");
		}
		// 新生幼犬CKU血统证书费
		PaymentChargingItem pedigreeCertifiedItem = getPedigreeCertifiedItem();
		chargingItemResult.add(pedigreeCertifiedItem);
		Member loginMember = UserUtils.getLoginMember();
		// 检测服务费(纯种犬DNA样本)
		if ("1".equals(dnaSaveWay)) {
			List<PaymentChargingItem> dnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
			chargingItemResult.addAll(dnaArchiveItems);
			// 血样留存业务
			List<PaymentChargingItem> bloodSaveItems = getBloodSaveItem(dogBirthCertificate, dnaSaveWay);
			chargingItemResult.addAll(bloodSaveItems);
		} else if ("0".equals(dnaSaveWay) && "6".equals(loginMember.getUser().getUserType())) {// 玛犬特殊处理
			// 血样留存业务
			PaymentChargingItem bloodSaveItem = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE);
			chargingItemResult.add(bloodSaveItem);
		} else {
			// 登记服务费(纯种犬DNA样本) ---> 换成鼻纹收费项
			// PaymentChargingItem bloodSaveItem = getBloodSaveItem(dogBirthCertificate,
			// dnaSaveWay);
			// totalPrice += Double.parseDouble(bloodSaveItem.getPrice());
			PaymentChargingItem noselineItem = getNoseLineItem();
			chargingItemResult.add(noselineItem);
		}
		// 检测服务费(纯种犬DNA亲子关系)
		if ("1".equals(isDnaParentsCompare)) {
			PaymentChargingItem dnaParentsCompareItem = getDnaParentsCompareItem();
			chargingItemResult.add(dnaParentsCompareItem);
		}
		// 新犬主120会员费用
		if (StringUtils.isNotBlank(newMember) && "1".equals(newMember)) {
			PaymentChargingItem newMemberItem = getNewMemberItem();
			chargingItemResult.add(newMemberItem);
		} else {
			if (StringUtils.isEmpty(memberCode)) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "memberCode不能为空");
			}
			if (!MemberUtil.isActiveMember(memberService.getByMemberCode(memberCode))) {
				RestRenew restRenew = restMemberService.getRenewInfo(memberCode);
				if (restRenew != null) {
					PaymentChargingItem renewMemberItem = new PaymentChargingItem();
					renewMemberItem.setId(IdGen.uuid());
					renewMemberItem.setPrice(String.valueOf(restRenew.getTotalPrice().doubleValue()));
					chargingItemResult.add(renewMemberItem);
				}
			}
		}
		return chargingItemResult;
	}

	/**
	 * @description: 计算芯片费用
	 * @author: laiguanglong
	 * @date: 2016年9月20日 下午3:12:10
	 */
	public String getChipFee(DogBirthCertificate dogBirthCertificate) {
		String chipFee = null;
		// 计算芯片费用
		String dogBreed = dogBirthCertificate.getDogBreed();
		String chipShortName = CHIP_FEE_ALL;
		if ("230".equals(dogBreed)) {
			chipShortName = CHIP_FEE_ZANGAO;
		}
		chipFee = paymentChargingItemService.getByShortName(chipShortName).getPrice();
		// 一岁到两岁之前的犬只申请时证书费变为500元，同时DNA留存方式默认为位点分析（不能修改），同时不享受任何优惠政策（芯片减免、出生纸抵扣等）
		// 犬舍联盟免芯片费取消
		// KennelAlliance kennelAlliance = kennelAllianceDao
		// .getByMemberCode(dogBirthCertificate.getBreederMemberCode());
		// int ageMonth = getMonthAge(new Date(),
		// dogBirthCertificate.getDogBirthday());
		// if(!(ageMonth>11)&&(kennelAlliance != null &&
		// "0".equals(kennelAlliance.getValid()))){
		// // 有效犬舍联盟芯片费为0，但是也要记录收费项
		// chipFee = "0";
		// }
		return chipFee;
	}

	// private static final String CLUB_FEE = "dog_chip@club";

	/**
	 * @description: 俱乐部申请新生犬登记，写入新生犬登记表
	 * @author: laiguanglong
	 * @date: 2016年10月14日 上午10:10:28
	 */
	public DogChip clubPost(DogBirthCertificate dogBirthCertificate, String dnaSaveWay, String isDnaParentsCompare,
			String chipChangeId, String callName, String chipInject, String stickerFlag, String samplingCode) {
		Org org = (Org) UserUtils.getSession().getAttribute("org");
		String loginName = org.getUser().getLoginName();
		// 构造持久对象
		DogChip po = new DogChip();
		po.setCallName(callName);// 犬只呼名
		po.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		po.setPaymentMemberCode(dogBirthCertificate.getTempMemberCode());
		// 计算价格
		po.setPrice(getDogChipPrice(dogBirthCertificate));
		po.setFloatingPrice(new BigDecimal(po.getPrice()));
		// 合作机构
		po.setDnaSaveWay(dnaSaveWay);
		po.setIsDnaParentsCompare(isDnaParentsCompare);
		po.setBloodSaveFlag("0");
		po.setHospitalName(org.getName());
		po.setHospitalCode(org.getId());
		po.setReviewState("0");
		po.setPaymentState("1");
		po.setProcessState("0");
		po.setPrintState("0");
		// update by zjw 2023-02-07 工单号：ID1005116 取消宠爱护照发放
//		po.setStickerFlag(stickerFlag);
		po.setStickerFlag("0");
		po.setIsAll(dogBirthCertificate.getIsAll());
		// 地方俱乐部代打芯片
		if (!StringUtils.isBlank(chipInject) && "1".equals(chipInject)) {
			po.setChipInjectFlag(chipInject);
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-M-d");
		po.setOperator(loginName + ":" + formatter.format(new Date()));
		po.setIsDnaParentsCompare(isDnaParentsCompare);
		// 业务校验
		dogChipService.validateBusiness(po, dogBirthCertificate);
		po.setDogChipChangeId(chipChangeId);
		// 写入业务表
		dogChipService.save(po);
		if ("0".equals(dnaSaveWay) || "1".equals(dnaSaveWay)) {
			// 血样留存业务表
			List<PaymentChargingItem> itemList = getBloodSaveItem(dogBirthCertificate, dnaSaveWay);
			DogBloodSave dogBloodSave = buildBloodSave(dogBirthCertificate, po, itemList, true);
			dogBloodSaveService.save(dogBloodSave);
			// 位点分析业务表
			if ("1".equals(dnaSaveWay)) {
				List<PaymentChargingItem> dnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
				DogDnaArchive dogDnaArchive = buildDogDnaArchive(dogBirthCertificate, po, dnaArchiveItems, true, null);
				dogDnaArchiveService.save(dogDnaArchive);
				// 绑定采样包
				if (StringUtils.isBlank(samplingCode)) {
					throw new ZAException(-1, "点位分析必须绑定采样包!");
				}
				dogDnaArchiveService.bindSamplingFront(dogBirthCertificate.getBirthCerRegCode(),
						SamplingDogSourceTypeEnum.BIRTH_CODE, samplingCode, org.getMemberCode());
				// 双亲比对业务表
				if ("1".equals(isDnaParentsCompare)) {
					PaymentChargingItem dnaParentsCompareItem = getDnaParentsCompareItem();
					DogDnaParentsCompare dogDnaParentsCompare = buildDogDnaParentsCompare(dogBirthCertificate, po,
							dnaParentsCompareItem, true);
					dogDnaParentsCompareService.save(dogDnaParentsCompare);
				}
			}
		}
		dogChipService.updateBusinessPrice(po);
		return po;
	}

	/**
	 * @Description：新生犬登记撤销操作
	 * @author: zhuoHeng
	 * @version: 2016年10月25日 上午12:00:53
	 */
	@Transactional(readOnly = false)
	public RESTResponse canceled(String id) {
		DogChip po = dogChipService.get(id);
		Member member = UserUtils.getLoginMember();
		if (po == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		if (!member.getMemberCode().equals(po.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		// 增加退款中或已退款的业务不能再次撤销
		this.validateRefundState(po, null);
		dogChipService.canceled(po);
		return new RESTResponse();
	}

	private void validateRefundState(DogChip po, RestDogChip vo) {

		String businessIds = null;
		if ("1".equals(po.getIsAll())) {
			businessIds = po.getFmdogBreedCertifiedCode();
		} else {
			businessIds = po.getId();
		}
		boolean canCanceled = paymentOrderService.getCanCanceledByBusinessIdAOrderCode(businessIds,
				po.getRunningNumber());
		if (vo == null) {
			if (!canCanceled)
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已申请退费业务，无法操作");
		} else {
			vo.setCanCanceled(canCanceled);
			vo.setCanEdit(canCanceled);
		}
	}

	/**
	 * @description: 血样留存业务
	 * @author: laiguanglong
	 * @date: 2016/11/28 11:18
	 */
	// private String bloodSave(String birthCode,String businessOrderCode,String
	// dnaSaveWay){
	// //0根据出生证明查重
	// if(dogBloodSaveService.getByBirthCode(birthCode)!=null){
	// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该出生纸已有血样留存业务记录");
	// }
	// //收费项
	// PaymentChargingItem item = getBloodSaveItem(birthCode,dnaSaveWay);
	// //1保存到业务表
	// DogBloodSave dogBloodSave = buildBloodSave(birthCode,item,false);
	// dogBloodSaveService.save(dogBloodSave);
	// //2加入购物车
	// PaymentCart paymentCart =
	// buildDogBloodSavePaymentCart(dogBloodSave,businessOrderCode,item);
	// paymentCartService.addToCart(paymentCart);
	// return paymentCart.getId();
	// }

	/**
	 * @description: 新生犬登记业务 业务 写入业务表和购物车表
	 * @author: laiguanglong
	 * @date: 2017/5/25 16:16
	 */
	private String dogChip(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode) {
		StringBuilder cartIds = new StringBuilder();
		dogChipService.save(po);
		if (StringUtils.isBlank(dogBirthCertificate.getIdentificationFlag())) {
			// 旧出生纸：芯片费、电子芯片埋植服务费
			PaymentCart chipCart = getChipCart(po, businessOrderCode);
			paymentCartService.addToCart(chipCart, "1004");
			cartIds.append(chipCart.getId());
			PaymentCart chipEmbedCart = getChipEmbedCart(po, businessOrderCode);
			paymentCartService.addToCart(chipEmbedCart, "1004");
			cartIds.append(",").append(chipEmbedCart.getId());
		} else {
			// 新出生纸：信息管理费（信息匹配）
			PaymentCart infoMatchCart = getInfoMatchCart(po, businessOrderCode);
			paymentCartService.addToCart(infoMatchCart, "1004");
			cartIds.append(infoMatchCart.getId());
		}
		return cartIds.toString();
	}

	/**
	 * @description: 建档费服务费 业务 只写入购入车表
	 * @author: laiguanglong
	 * @date: 2017/5/25 16:16
	 */
	private String saveInfo(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode) {
		PaymentCart saveInfoCart;
		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
			// 1岁内：建档费服务费（新生幼犬）
			saveInfoCart = getSaveInfoCart(po, businessOrderCode);
		} else if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 24)) {
			// 1岁-2岁：建档费服务费（青年犬）
			saveInfoCart = getSaveInfoYoungCart(po, businessOrderCode);
		} else {
			// 两岁以上犬只无法办理
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬年龄已超过2岁，不允许办理新生犬登记");
		}
		paymentCartService.addToCart(saveInfoCart, "1004");
		return saveInfoCart.getId();
	}

	/**
	 * @description: 新生幼犬CKU血统证书业务 只写入购入车表
	 * @author: laiguanglong
	 * @date: 2016/11/28 11:18
	 */
	private String pedigreeCertified(DogChip po, String businessOrderCode) {
		PaymentCart pedigreeCertifiedCart = getPedigreeCertifiedCart(po, businessOrderCode);
		paymentCartService.addToCart(pedigreeCertifiedCart, "1004");
		return pedigreeCertifiedCart.getId();
	}

	private String newMemberSave(DogChip po, String businessOrderCode, String memberId, String memberCode) {
		PaymentCart pedigreeCertifiedCart = getNewMemberCart(po, businessOrderCode, memberId, memberCode);

		paymentCartService.addToCart(pedigreeCertifiedCart, "1021");
		return pedigreeCertifiedCart.getId();
	}

	protected String noseLine(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode) {
		// PaymentChargingItem noseLineItem = getNoseLineItem();
		PaymentCart noseCart = getNoseCart(po, businessOrderCode);

		paymentCartService.addToCart(noseCart, "1004");
		return noseCart.getId();
	}

	/**
	 * @description: 血样留存业务 写入业务表和购物车表
	 * @author: laiguanglong
	 * @date: 2016/11/28 11:18
	 */
	protected String bloodSave(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode) {
		List<PaymentChargingItem> itemList = getBloodSaveItem(dogBirthCertificate, po.getDnaSaveWay());
		DogBloodSave dogBloodSave = buildBloodSave(dogBirthCertificate, po, itemList, false);
		dogBloodSaveService.save(dogBloodSave);
		PaymentCart bloodSaveCart = getBloodSaveCart(itemList.get(0), dogBloodSave, businessOrderCode);
		paymentCartService.addToCart(bloodSaveCart, "1004");
		return bloodSaveCart.getId();
	}

	/**
	 * @description: 位点分析业务 写入业务表和购物车表
	 * @author: laiguanglong
	 * @date: 2016/11/28 11:18
	 */
	protected String dnaArchive(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode,
			String orgId) {
		List<PaymentChargingItem> dnaArchiveItems = dogDnaArchiveService.getDnaArchiveItem();
		DogDnaArchive dogDnaArchive = buildDogDnaArchive(dogBirthCertificate, po, dnaArchiveItems, false, orgId);
		dogDnaArchiveService.save(dogDnaArchive);
		List<PaymentCart> dnaArchiveCarts = getDnaArchiveCart(dogDnaArchive, businessOrderCode);
		StringBuilder cartIds = new StringBuilder();
		dnaArchiveCarts.stream().forEach(dnaArchiveCart -> {
			paymentCartService.addToCart(dnaArchiveCart, "1004");
			cartIds.append(",").append(dnaArchiveCart.getId());
		});
		return cartIds.toString();
	}

	/**
	 * @description: 双亲比对业务 写入业务表和购物车表
	 * @author: laiguanglong
	 * @date: 2016/11/28 11:18
	 */
	protected String dnaParentsCompare(DogBirthCertificate dogBirthCertificate, DogChip po, String businessOrderCode) {
		PaymentChargingItem dnaParentsCompareItem = getDnaParentsCompareItem();
		DogDnaParentsCompare dogDnaParentsCompare = buildDogDnaParentsCompare(dogBirthCertificate, po,
				dnaParentsCompareItem, false);
		dogDnaParentsCompareService.save(dogDnaParentsCompare);
		PaymentCart dnaParentsCompareCart = getDnaParentsCompareCart(dogDnaParentsCompare, businessOrderCode);
		paymentCartService.addToCart(dnaParentsCompareCart, "1004");
		return dnaParentsCompareCart.getId();
	}

	/**
	 * @Description：订单详细中业务数据查询
	 * @author: zhuoHeng
	 * @version: 2017年1月3日 上午9:36:42
	 */
	public RESTResponse orderDetail(String id) {
		DogChip dogChip = dogChipService.get(id);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if (dogChip == null) {

			List<DogChip> dl = dogChipService.getByFmdogBreedCertifiedCodes(id);
			List<Map<String, String>> ls = new ArrayList<>();
			dl.forEach(i -> {
				Map<String, String> map = new HashMap<>();
				DogType dogType = dogTypeService.getByDogBreedCode(i.getDogBirthCertificate().getDogBreed());
				String breedCnName;
				if (dogType == null) {
					breedCnName = dogTypeService.getUnMapBreedCnName(i.getDogBirthCertificate().getDogBreed());
				} else {
					breedCnName = dogType.getBreedCnName();
				}
				map.put("key1", "犬名：" + i.getDogBirthCertificate().getDogEnName());
				map.put("key2", "犬主人：" + i.getDogBirthCertificate().getDogOwenr());
				map.put("key3", "会员号：" + i.getDogBirthCertificate().getMemberCode());
				map.put("key4", "登记卡编号：" + i.getDogBirthCertificate().getBirthCerRegCode());
				map.put("key5", "犬种：" + breedCnName);
				map.put("key6", "出生日期：" + sdf.format(i.getDogBirthCertificate().getDogBirthday()));
				map.put("key7",
						"性别：" + DictUtils.getDictLabel(i.getDogBirthCertificate().getDogGender(), "dog_gender", ""));
				map.put("key8", "毛色：" + i.getDogBirthCertificate().getColorFlag());
				ls.add(map);
			});
			return new RESTResponse("data", ls);
		}
		Map<String, String> map = new HashMap<>();
		DogType dogType = dogTypeService.getByDogBreedCode(dogChip.getDogBirthCertificate().getDogBreed());
		map.put("key1", "犬名：" + dogChip.getDogBirthCertificate().getDogEnName());
		map.put("key2", "犬主人：" + dogChip.getDogBirthCertificate().getDogOwenr());
		map.put("key3", "会员号：" + dogChip.getDogBirthCertificate().getMemberCode());
		map.put("key4", "登记卡编号：" + dogChip.getDogBirthCertificate().getBirthCerRegCode());
		String breedCnName = "";
		if (dogType == null) {
			breedCnName = dogTypeService.getUnMapBreedCnName(dogChip.getDogBirthCertificate().getDogBreed());
		} else {
			breedCnName = dogType.getBreedCnName();
		}
		map.put("key5", "犬种：" + breedCnName);
		map.put("key6", "出生日期：" + sdf.format(dogChip.getDogBirthCertificate().getDogBirthday()));
		map.put("key7",
				"性别：" + DictUtils.getDictLabel(dogChip.getDogBirthCertificate().getDogGender(), "dog_gender", ""));
		map.put("key8", "毛色：" + dogChip.getDogBirthCertificate().getColorFlag());
		return new RESTResponse("data", map);
	}

	public DogBloodSave buildBloodSave(DogBirthCertificate dogBirthCertificate, DogChip po,
			List<PaymentChargingItem> itemList, boolean clubPostFlag) {
		DogBloodSave dogBloodSave = new DogBloodSave();
		dogBloodSave.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (clubPostFlag) {
			dogBloodSave.setTypeYes("2");
			dogBloodSave.setPaymentMemberCode(dogBirthCertificate.getTempMemberCode());
			dogChipService.setBloodSaveFlag(dogBirthCertificate.getBirthCerRegCode());
		} else {
			dogBloodSave.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		}
		dogBloodSave.setOrgId(((Org) UserUtils.getSession().getAttribute("org")).getId());
		BigDecimal totalPrice = BigDecimal.ZERO;
		for (PaymentChargingItem item : itemList) {
			totalPrice.add(new BigDecimal(item.getPrice()));
		}
		dogBloodSave.setPrice(totalPrice.toString());
		po.setFloatingPrice(po.getFloatingPrice().add(new BigDecimal(dogBloodSave.getPrice())));
		dogBloodSave.setPaymentState("1");
		dogBloodSave.setIsOEC(po.getDnaSaveWay());
		return dogBloodSave;
	}

	public DogDnaArchive buildDogDnaArchive(DogBirthCertificate dogBirthCertificate, DogChip po,
			List<PaymentChargingItem> items, boolean clubPostFlag, String orgId) {
		Double price = items.stream().mapToDouble(a -> Double.valueOf(a.getPrice())).sum();

		DogDnaArchive dogDnaArchive = new DogDnaArchive();
		dogDnaArchive.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (clubPostFlag) {
			dogDnaArchive.setPaymentMemberCode(dogBirthCertificate.getTempMemberCode());
		} else {
			dogDnaArchive.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		}
		if (orgId == null || orgId == "") {
			dogDnaArchive.setOrgId(((Org) UserUtils.getSession().getAttribute("org")).getId());
		} else {
			dogDnaArchive.setOrgId(orgId);
		}

		dogDnaArchive.setPrice(price.toString());
		po.setFloatingPrice(po.getFloatingPrice().add(new BigDecimal(price.toString())));
		dogDnaArchive.setReviewState("0");
		dogDnaArchive.setPaymentState("1");
		dogDnaArchive.setProcessState("0");
		dogDnaArchive.setPrintState("0");
		dogDnaArchive.setIsOEC(po.getDnaSaveWay());// 是否为口腔上皮细胞测试法:否0；是1
		return dogDnaArchive;
	}

	public DogDnaParentsCompare buildDogDnaParentsCompare(DogBirthCertificate dogBirthCertificate, DogChip po,
			PaymentChargingItem item, boolean clubPostFlag) {
		DogDnaParentsCompare dogDnaParentsCompare = new DogDnaParentsCompare();
		dogDnaParentsCompare.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		if (clubPostFlag) {
			dogDnaParentsCompare.setPaymentMemberCode(dogBirthCertificate.getTempMemberCode());
		} else {
			dogDnaParentsCompare.setPaymentMemberCode(UserUtils.getLoginMember().getMemberCode());
		}
		dogDnaParentsCompare.setPrice(item.getPrice());
		po.setFloatingPrice(po.getFloatingPrice().add(new BigDecimal(item.getPrice())));
		dogDnaParentsCompare.setReviewState("0");
		dogDnaParentsCompare.setPaymentState("1");
		return dogDnaParentsCompare;
	}

	public RESTResponse checkBirthCode(HttpServletRequest request) {
		// 获取参数
		String birthCode = request.getParameter("birthCode");
		if (StringUtils.isBlank(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号为空");
		}
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if (dogBirthCertificate == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡编号有误");
		}
		Date dogBirthday = dogBirthCertificate.getDogBirthday();
		Calendar ca = Calendar.getInstance();// 得到一个Calendar的实例
		ca.setTime(new Date()); // 设置时间为当前时间
		ca.add(Calendar.YEAR, -2); // 年份减2
		ca.add(Calendar.DATE, -1); // 日期加1
		Date lastMonth = ca.getTime();
		if (dogBirthday.getTime() < lastMonth.getTime()) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "犬只年龄已超过2岁，请联系CKU繁殖部办理此业务！！！");
		}
		DogNose dogNose = new DogNose();
		dogNose.setDogBirthCertificateId(dogBirthCertificate.getId());
		dogNose.setDelFlag("0");
		List<DogNose> ns = dogNoseService.findList(dogNose);
		if (ns.size() == 0) {
			// throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新生犬登记卡未采集鼻纹");
		}
		// 校验犬只是否能办理当前登录类型的业务
		loginServerService.validBirthDogType(dogBirthCertificate);
		boolean flag = true;
		String msg = "";
		// 记录查重
		DogChip example = new DogChip();
		example.setBirthCode(dogBirthCertificate.getBirthCerRegCode());
		// 已撤销的不校验
		example.setIsCanceled("0");
		// 根据当前登录是否杜高会员来判断个人狗列表是杜高犬还是CKU犬
		if (StringUtils.isBlank(example.getDogBreed())) {
			// 根据当前登录端查询犬种
			example.getSqlMap().put("dogBreedMap", loginServerService.dataScopeFilter());
		} else {
			example.getSqlMap().put("dogBreedMap", " ='" + example.getDogBreed() + "'");
		}
		example.setReviewStateExclud("3");
		if (dogChipService.findList(example).size() > 0) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该新生犬登记卡已申请血统证书业务，请勿重复申请");
		}
		// 新生犬登记业务检验出生纸
		dogChipService.checkDogBirthCertificate(dogBirthCertificate);
		JSONObject jo = new JSONObject();
		jo.put("rc", flag);
		jo.put("isNewDogBirthCertificate",
				dogBirthCertificate.getCreateDate().getTime() >= dogBirthCertificateService.newBusinessTimeMillis);
		jo.put("msg", msg);
		// 如果申请人是繁殖人返回芯片号或识别码
		jo.put("identificationFlag", dogBirthCertificate.getIdentificationFlag());
		jo.put("snCode", dogBirthCertificate.getSnCode());
		// 校验犬只是否有绑定的会员信息
		DogChipMemberLock dogChipMemberLock = dogChipMemberLockService
				.getByChipCode(dogBirthCertificate.getIdentificationFlag(), "1");
		String memberName = null, memberCode = null;
		if (dogChipMemberLock != null && !StringUtils.isBlank(dogChipMemberLock.getId())) {
			Member member = memberService.getByMemberCode(dogChipMemberLock.getMemberCode());
			if (member != null && !StringUtils.isBlank(member.getId())) {
				memberCode = member.getMemberCode();
				memberName = member.getName();
			}
		}
		jo.put("memberCode", memberCode);
		jo.put("memberName", memberName);
		return new RESTResponse("data", jo);
	}

	public RESTResponse checkNewDogOwner(HttpServletRequest request) {
		// 获取参数
		String newDogOwnerCode = request.getParameter("newDogOwnerCode");
		if (StringUtils.isBlank(newDogOwnerCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "新犬主会员号为空");
		}
		Member member = memberService.getByMemberCode(newDogOwnerCode);
		if (member == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "会员号码有误，请输入正确会员号，新犬主如非cku会员，请选择非cku会员");
		}

		JSONObject jo = new JSONObject();
		jo.put("memberCode", member.getMemberCode());
		jo.put("name", member.getName());
		String mobile = member.getMobile();
		if (StringUtils.isNotBlank(mobile) && mobile.length() > 7) {
			mobile = mobile.substring(0, 3) + "****" + mobile.substring(7);
		}
		jo.put("mobile", mobile);
		boolean newDogOwnerCheckFlag = true;
		String msg = "";
		if (!MemberUtil.isActiveMember(member)) {
			newDogOwnerCheckFlag = false;
			// String price = restMemberService.getRenewPrice(member.getMemberCode());
			RestRenew restRenew = restMemberService.getRenewInfo(member.getMemberCode());
			if (restRenew.getCardType() > 0) {
				// msg = "新犬主为无效会员，请新犬主缴费后再进行血统证书申请";
				msg = "因新犬主为无效CKU会员，无法办理犬主变更业务，如继续办理，需为其缴纳会员费";
				if (restRenew.getCardType() == 30 && !(member.getMemberEndDate() != null && member.getKennel() != null
						&& member.getMemberEndDate().equals(member.getKennel().getEndTime()))) {
					msg = "新犬主会员截至日期和犬舍截至日期不同步，需登录宠爱王国APP完成会员日期同步后方可继续办理该业务";
					restRenew.setCardType(0);
				}
			} else {
				msg = "新犬主需为CKU爱宠银卡会员或以上会员，现新犬主为CKU爱宠普卡会员，请升级后继续办理该业务";
			}
			jo.put("cardType", restRenew.getCardType().toString());
			jo.put("price", restRenew.getTotalPrice().toString());
		}

		jo.put("newDogOwnerCheckFlag", newDogOwnerCheckFlag);
		jo.put("msg", msg);
		return new RESTResponse("data", jo);
	}

	@Transactional(readOnly = false)
	public RESTResponse put(String json) {
		// json转换为对象
		DogChip put = BeanUtil.toBean(json, DogChip.class);
		// 参数校验
		if (StringUtils.isBlank(put.getId())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id为空");
		}
		if (StringUtils.isBlank(put.getHospitalCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "合作机构为空");
		}

		DogChip dogChip = dogChipService.get(put.getId());
		Member member = UserUtils.getLoginMember();
		if (dogChip == null || !member.getMemberCode().equals(dogChip.getPaymentMemberCode())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}

		// 增加退款中或已退款的业务不能再次撤销
		this.validateRefundState(dogChip, null);
		// 在待审核和已通过状态时，可修改，修改内容仅限合作机构
		String businessState = dogChipService.getBusinessState(dogChip);
		if (!"待审核".equals(businessState) && !"已通过".equals(businessState)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "只有待审核和已通过状态下可以修改合作机构");
		}
		// 血样留存标记为已采血不允许修改
		if ("1".equals(dogChip.getBloodSaveFlag())) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该犬只已采血，不可以修改合作机构");
		}
		List<DogChip> ld = new ArrayList<>();
		Org org = orgService.get(put.getHospitalCode());
		if ("1".equals(dogChip.getIsAll())) { // 整窝生 如果有一只办理成功 测不允许修改整窝的任何一只信息
			ld = dogChipService
					.getByFmdogBreedCertifiedCodes(dogChip.getDogBirthCertificate().getFmdogBreedCertifiedCode());
			if (ld.stream().filter(i -> "1".equals(i.getProcessState())).count() >= 1) {
				throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "该窝已有犬只完成血统证书办理，无法修改预约信息");
			}
			// 整窝办理修改一只犬只预约的俱乐部、则其余犬只全部修改
			for (DogChip chip : ld) {
				chip.setHospitalName(org.getName());
				chip.setHospitalCode(org.getId());
				dogChipService.save(chip);
			}
		} else {
			dogChip.setHospitalName(org.getName());
			dogChip.setHospitalCode(org.getId());
			dogChipService.save(dogChip);
		}

		DogBirthCertificate dogBirthCertificate = dogBirthCertificateDao.getByBirthCerRegCode(dogChip.getBirthCode());
		// 判断是否可申请该单犬种俱乐部
		orgDogTypeLimitService.checkSingleTypeClub(put.getHospitalCode(), dogBirthCertificate.getDogBreed());
		dogBirthCertificate.setAddUser(org.getUser().getLoginName());
		dogBirthCertificateService.save(dogBirthCertificate);
		if ("1".equals(dogChip.getIsAll())) {
			// 整窝生业务需要批量修改 血统证书和出生纸
			if (ld != null && ld.size() > 0) {
				ld.remove(dogChip);
				ld.forEach(i -> {
					i.setHospitalName(org.getName());
					i.setHospitalCode(org.getId());
					dogChipService.save(i);
					DogBirthCertificate d = dogBirthCertificateDao.getByBirthCerRegCode(i.getBirthCode());
					d.setAddUser(org.getUser().getLoginName());
					dogBirthCertificateService.save(d);
				});
			}
		}
		// 修改血样留存和dna位点分析
		dogBloodSaveService.updateOrg(dogChip.getBirthCode(), org.getId());
		dogDnaArchiveService.updateOrg(dogChip.getBirthCode(), org.getId());
		// delete和put方法直接返回RESTResponse对象表示操作成功
		return new RESTResponse();
	}

	/**
	 * @description: 芯片费
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getChipItem() {
		return paymentChargingItemService.getByShortName(CHIP_FEE);
	}

	/**
	 * @description: 电子芯片埋植服务费
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getChipEmbedItem() {
		return paymentChargingItemService.getByShortName(EMBED_CHIP_FEE);
	}

	/**
	 * @description: 信息管理费（信息匹配）
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getInfoMatchItem() {
		return paymentChargingItemService.getByShortName(INFO_MATCH_FEE);
	}

	/**
	 * @description: 建档费服务费（新生幼犬） 出生纸优惠-50 出生4个月内办理优惠-20
	 * @author: laiguanglong
	 * @date: 2017/5/23 19:32
	 */
	public PaymentChargingItem getSaveInfoItem(String birthCode) {
		return getSaveInfoItem(birthCode, null);
	}

	public PaymentChargingItem getSaveInfoItem(String birthCode, String ecertFlag) {
		PaymentChargingItem item = paymentChargingItemService.getByShortName(SAVE_INFO_FEE);
		Double price = Double.parseDouble(item.getPrice());
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		// 判断出生纸是否抵扣
		String deduction = dogBirthCertificate.getDeduction();
		// 2月龄办理出生纸，办理血统证书抵扣50元，时限由12月龄改为6月龄
		// 4月龄办理血统证书优惠20元取消
		// by yuanshuai 2019年3月20日10:44:44
		if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 6) && "1".equals(deduction)) {
			price = price - 50;
		}
		// 血统证书电子化优惠
		if ("1".equals(ecertFlag)) {
			// price = price - ECERT_DISCOUNTS;
		}
		item.setPrice(price.toString());
		return item;
	}

	/**
	 * @description: 新生幼犬CKU血统证书费
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getPedigreeCertifiedItem() {
		return paymentChargingItemService.getByShortName(PEDIGREE_CERTIFIED_FEE);
	}

	public PaymentChargingItem getNoseLineItem() {
		return paymentChargingItemService.getByShortName(NOSE_LINE);
	}

	public PaymentChargingItem getNewMemberFeeItem() {
		return paymentChargingItemService.getByShortName(NEW_MEMBER_FEE);
	}

	/**
	 * @description: 登记服务费(纯种犬DNA样本)
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public List<PaymentChargingItem> getBloodSaveItem(DogBirthCertificate dogBirthCertificate, String dnaSaveWay) {
		List<PaymentChargingItem> itemList = Lists.newArrayList();
		if ("1".equals(dnaSaveWay)) {
			// 点位分析
			itemList.add(paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE_OEC));
			if (!DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
				// 如果DNA留存方式为位点分析，则血样留存的价格为0,如果犬只年龄大于1岁，收鼻纹等级费100块
				itemList.add(paymentChargingItemService.getByShortName(NOSE_LINE));
			}
		} else {
			// 血样留存
			itemList.add(paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE));
			// 如果DNA留存方式为血样留存，则价格为0
			itemList.add(paymentChargingItemService.getByShortName(ClubDnaService.BLOOD_SAVE_FEE_MIAN_FEI));
		}

		return itemList;
	}

	public List<PaymentChargingItem> getBloodSaveItems(DogBirthCertificate dogBirthCertificate, String dnaSaveWay) {
		List<PaymentChargingItem> items = new ArrayList<>();
		// DNA留存方式:血样留存0
		if ("0".equals(dnaSaveWay)) {
			// 登记服务费(纯种犬DNA样本) dog_blood_save@New
			PaymentChargingItem item = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE);
			items.add(item);
			// 如果犬只年龄在1岁内 两个收费项抵消费用为0,如果犬只年龄大于1岁，费用照收100
			if (DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
				// 登记服务费（纯种犬DNA样本）100元，登记服务费（纯种犬DNA样本）减免 100元
				PaymentChargingItem itemFree = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE_DX);
				items.add(itemFree);
			}
		} else if ("1".equals(dnaSaveWay)) {
			// DNA位点分析1
			PaymentChargingItem item = paymentChargingItemService.getByShortName(BLOOD_SAVE_FEE_OEC);
			items.add(item);
			// 如果犬只年龄大于1岁费用照收100
			if (!DateUtils.isInXMounth(dogBirthCertificate.getDogBirthday(), 12)) {
				PaymentChargingItem item2 = paymentChargingItemService.getByShortName(NOSE_LINE);
				items.add(item2);
			}
		}
		return items;
	}

	/**
	 * @description: 检测服务费(纯种犬DNA亲子关系) 1只有选择了位点分析才能选择双亲比对 2如果选择了有位点分析，则双亲比对价格为0
	 *               3所以双亲比对的价格为0
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getDnaParentsCompareItem() {
		PaymentChargingItem item = paymentChargingItemService.getByShortName(DNA_PARENTS_COMPARE_FEE);
		item.setPrice("0");
		return item;
	}

	public PaymentChargingItem getNewMemberItem() {
		PaymentChargingItem item = paymentChargingItemService.getByShortName(NEW_MEMBER_FEE);
		return item;
	}

	// public PaymentChargingItem getRegisterMemberItem() {
	// PaymentChargingItem item =
	// paymentChargingItemService.getByShortName(RENEW_MEMBER_FEE);
	// return item;
	// }

	/**
	 * @description: 建档费服务费（青年犬）
	 * @author: laiguanglong
	 * @date: 2017/5/24 10:22
	 */
	public PaymentChargingItem getSaveInfoYoungItem() {
		return getSaveInfoYoungItem(null);
	}

	public PaymentChargingItem getSaveInfoYoungItem(String ecertFlag) {

		PaymentChargingItem item = paymentChargingItemService.getByShortName(SAVE_INFO_YOUNG_FEE);
		// 血统证书电子化优惠
		if ("1".equals(ecertFlag)) {
			// Double price = Double.parseDouble(item.getPrice());
			// price = price - ECERT_DISCOUNTS;
			// item.setPrice(price.toString());
		}
		return item;
	}

	/**
	 * @description: 芯片费 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getChipCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getChipItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		// return paymentCart;
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 电子芯片埋植服务费 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getChipEmbedCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getChipEmbedItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 信息管理费（信息匹配） 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getInfoMatchCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getInfoMatchItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 建档费服务费（新生幼犬） 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getSaveInfoCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getSaveInfoItem(po.getBirthCode(), po.getEcertFlag());
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 新生幼犬CKU血统证书费 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getPedigreeCertifiedCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getPedigreeCertifiedItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	private PaymentCart getNewMemberCart(DogChip po, String businessOrderCode, String memberId, String memberCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getNewMemberFeeItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("sys_member");
		paymentCart.setBusinessIds(memberId);
		paymentCart.setBusinessOrderCode("9991009101010" + "-" + businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	private PaymentCart getNoseCart(DogChip po, String businessOrderCode) {

		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getNoseLineItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		po.setFloatingPrice(po.getFloatingPrice().add(new BigDecimal(item.getPrice())));
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 登记服务费(纯种犬DNA样本) 购物车
	 * @author: laiguanglong
	 * @date: 2016/11/25 17:24
	 */
	protected PaymentCart getBloodSaveCart(PaymentChargingItem item, DogBloodSave dogBloodSave,
			String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setNum("1");
		paymentCart.setBusinessTable("dog_blood_save");
		paymentCart.setBusinessIds(dogBloodSave.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 检测服务费(纯种犬DNA样本) 购物车
	 * @author: laiguanglong
	 * @date: 2016/11/25 17:24
	 */
	private List<PaymentCart> getDnaArchiveCart(DogDnaArchive dogDnaArchive, String businessOrderCode) {
		List<PaymentCart> list = new ArrayList<>();
		List<PaymentChargingItem> items = dogDnaArchiveService.getDnaArchiveItem();
		items.stream().forEach(item -> {
			PaymentCart paymentCart = new PaymentCart();
			paymentCart.setChargingItemId(item.getId());
			paymentCart.setChargingItemName(item.getName());
			paymentCart.setPrice(item.getPrice());
			paymentCart.setTotalPrice(item.getPrice());
			paymentCart.setNum("1");
			paymentCart.setBusinessTable("dog_dna_archive");
			paymentCart.setBusinessIds(dogDnaArchive.getId());
			paymentCart.setBusinessOrderCode(businessOrderCode);
			list.add(paymentCartService.addBusinessManage(paymentCart, "1004"));
		});

		return list;
	}

	/**
	 * @description: 检测服务费(纯种犬DNA亲子关系) 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getDnaParentsCompareCart(DogDnaParentsCompare dogDnaParentsCompare, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getDnaParentsCompareItem();
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_dna_parents_compare");
		paymentCart.setBusinessIds(dogDnaParentsCompare.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	/**
	 * @description: 建档费服务费（青年犬） 购物车
	 * @author: laiguanglong
	 * @date: 2017/5/25 10:51
	 */
	private PaymentCart getSaveInfoYoungCart(DogChip po, String businessOrderCode) {
		PaymentCart paymentCart = new PaymentCart();
		PaymentChargingItem item = getSaveInfoYoungItem(po.getEcertFlag());
		paymentCart.setChargingItemId(item.getId());
		paymentCart.setChargingItemName(item.getName());
		paymentCart.setNum("1");
		paymentCart.setPrice(item.getPrice());
		paymentCart.setTotalPrice(item.getPrice());
		paymentCart.setBusinessTable("dog_chip");
		paymentCart.setBusinessIds(po.getId());
		paymentCart.setBusinessOrderCode(businessOrderCode);
		return paymentCartService.addBusinessManage(paymentCart, "1004");
	}

	public RESTResponse checkCallName(HttpServletRequest request) {
		String callName = request.getParameter("callName");
		if (StringUtils.isBlank(callName)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "呼名为空");
		}
		demandSensitiveWordService.validCallName(callName);
		return new RESTResponse();
	}

	/**
	 * @Description： 地方俱乐部芯片代打
	 * 
	 * @author: yuanshuai
	 * @date: 2018/7/9 14:40
	 */
	public PaymentChargingItem getChipInjectItem() {
		return paymentChargingItemService.getByShortName(CHIP_INJECT);
	}

	public RESTResponse checkNose(HttpServletRequest request) {
		String birthCode = request.getParameter("birthCode");
		if (StringUtils.isEmpty(birthCode)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数birthCode不能为空");
		}

		DogBirthCertificate birthObj = dogBirthCertificateService.getByBirthCerRegCode(birthCode);
		if (birthObj == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "无效的数据");
		}
		DogNose dogNose = new DogNose();
		dogNose.setDogBirthCertificateId(birthObj.getId());
		List<DogNose> list = dogNoseService.findList(dogNose);
		JSONObject jsonObj = new JSONObject();
		jsonObj.put("dogNose", !CollectionUtils.isEmpty(list));
		return new RESTResponse("data", jsonObj);
	}

	public RESTResponse viewCertificate(HttpServletRequest request) {
		String id = request.getParameter("id");
		if (StringUtils.isBlank(id)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "参数id不能为空");
		}

		DogChip dogChip = dogChipService.get(id);
		if (dogChip == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "id有误");
		}
		ViewCertificateVo vo = new ViewCertificateVo();
		DogBirthCertificate dogBirthCertificate = dogBirthCertificateService
				.getByBirthCerRegCode(dogChip.getBirthCode());
		Dog dog = dogService.getByPedigreeCertifiedCode(dogBirthCertificate.getPedigreeCertified());
		if (dog == null) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "证书制作中");
		}
		vo.setBreeder(dogBirthCertificate.getBreeder());
		vo.setCallName(dog.getCallName()); // 呼名

		DogColorMark dogColorMark = dogColorMarkService.getByDogColorMarkCode(dog.getColorFlag());
		if (dogColorMark != null) {
			String colorMarkCn = dogColorMark.getDogColorMarkCn();
			String[] color = colorMarkCn.split("-");
			vo.setColor(color[1]);
			vo.setColorDesc(dogColorMark.getDogColorMarkCode());
		}
		vo.setCreateDate(new SimpleDateFormat("yyyy/M/d").format(dog.getUpdateDate()));
		vo.setDogBirthday(new SimpleDateFormat("yyyy年M月d日").format(dog.getBirthdate()));

		DogType dogType = dogTypeService.getByDogBreedCode(dog.getDogBreed());
		vo.setDogBreed(dogType.getBreedEnName());
		vo.setDogBreedDesc(dogType.getBreedCnName());
		vo.setDogMemberNameEn(convertMemberName(memberService.getByMemberCode(dog.getMemberCode()).getNameEn()));
		vo.setBreederEn(convertMemberName(memberService.getByMemberCode(dog.getBreederMemberCode()).getNameEn()));
		vo.setDogGender("1".equals(dog.getGender()) ? "公" : "母");
		vo.setDogGenderDesc("1".equals(dog.getGender()) ? "Male" : "Female");
		vo.setDogName(StringUtils.isNotBlank(dog.getNameEn()) ? dog.getNameEn().trim() : dog.getNameEn());

		DogSticker dogSticker = dogStickerService.getDogStickerByIdentificationFlagByOne(dog.getIdentificationFlag());
		vo.setDogGrade(dogStickerService.getSticker(dogSticker));
		vo.setDogMemberName(dog.getDogOwner());
		vo.setPedigreeCertified(dog.getPedigreeCertifiedCode());

		Kennel kennel = kennelService.getKennelByMemberCode(dog.getBreederMemberCode());
		if (kennel != null) {
			vo.setKennleName(kennel.getName());
			vo.setKennelEnName(kennel.getNameEn().split("'")[0]);
			vo.setPaperKennelEnName(kennel.getNameEn());
		} else {
			vo.setKennleName("");
			vo.setKennelEnName("");
			vo.setPaperKennelEnName("");
		}

		vo.setDogName(dog.getNameEn().replace(vo.getKennelEnName(), ""));
		vo.setPaperDogName(StringUtils.isNotBlank(dog.getNameEn()) ? dog.getNameEn().toUpperCase() : "");
		vo.setIdentification(dog.getIdentificationFlag());

		Dog dog1 = getByPedigreeCertifiedCode(toUpdateEmpty(dog.getFdogPedigreeCertified()));
		if (dog1 != null) {
			vo.setDog1(dogService.convertDogVo(dog1));
			Dog dog3 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getFdogPedigreeCertified()));
			if (dog3 != null) {
				vo.setDog3(dogService.convertDogVo(dog3));
				Dog dog7 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getFdogPedigreeCertified()));
				if (dog7 != null) {
					vo.setDog7(dogService.convertDogVo(dog7));
				}

				Dog dog8 = getByPedigreeCertifiedCode(toUpdateEmpty(dog3.getMdogPedigreeCertified()));
				if (dog8 != null) {
					vo.setDog8(dogService.convertDogVo(dog8));
				}
			}
			Dog dog4 = getByPedigreeCertifiedCode(toUpdateEmpty(dog1.getMdogPedigreeCertified()));
			if (dog4 != null) {
				vo.setDog4(dogService.convertDogVo(dog4));
				Dog dog9 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getFdogPedigreeCertified()));
				if (dog9 != null) {
					vo.setDog9(dogService.convertDogVo(dog9));
				}
				Dog dog10 = getByPedigreeCertifiedCode(toUpdateEmpty(dog4.getMdogPedigreeCertified()));
				if (dog10 != null) {
					vo.setDog10(dogService.convertDogVo(dog10));
				}
			}
		}

		Dog dog2 = getByPedigreeCertifiedCode(toUpdateEmpty(dog.getMdogPedigreeCertified()));
		if (dog2 != null) {
			vo.setDog2(dogService.convertDogVo(dog2));
			Dog dog5 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getFdogPedigreeCertified()));
			if (dog5 != null) {
				vo.setDog5(dogService.convertDogVo(dog5));
				Dog dog11 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getFdogPedigreeCertified()));
				if (dog11 != null) {
					vo.setDog11(dogService.convertDogVo(dog11));
				}
				Dog dog12 = getByPedigreeCertifiedCode(toUpdateEmpty(dog5.getMdogPedigreeCertified()));
				if (dog12 != null) {
					vo.setDog12(dogService.convertDogVo(dog12));
				}
			}
			Dog dog6 = getByPedigreeCertifiedCode(toUpdateEmpty(dog2.getMdogPedigreeCertified()));
			if (dog6 != null) {
				vo.setDog6(dogService.convertDogVo(dog6));
				Dog dog13 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getFdogPedigreeCertified()));
				if (dog13 != null) {
					vo.setDog13(dogService.convertDogVo(dog13));
				}
				Dog dog14 = getByPedigreeCertifiedCode(toUpdateEmpty(dog6.getMdogPedigreeCertified()));
				if (dog14 != null) {
					vo.setDog14(dogService.convertDogVo(dog14));
				}
			}
		}

		return new RESTResponse("data", vo);
	}

	private String convertMemberName(String name) {
		if (StringUtils.isBlank(name)) {
			return "";
		}
		String[] names = name.split(" ");
		if (names.length > 1) {
			return names[1] + " " + names[0];
		}
		return name;
	}

	private Dog getByPedigreeCertifiedCode(String pedigreeCertifiedCode) {
		if (StringUtils.isBlank(pedigreeCertifiedCode)) {
			return null;
		}
		return dogService.getByPedigreeCertifiedCode(pedigreeCertifiedCode);
	}

	private String toUpdateEmpty(String a) {
		if (a == null) {
			return null;
		}
		if ("".equals(a.trim())) {
			return null;
		} else {
			return a;
		}
	}

	public RESTResponse updateEcertFlag(String id) {
		// 更改为纸质版
		dogBirthCertificateDao.updateEcertFlag(id);
		return new RESTResponse();
	}

	public RESTResponse getDuplicateRecordByBirthCertificateLevelCode(HttpServletRequest request) {
		List<DuplicateDog> dogs = this.dogDao.getDuplicateRecordByBirthCertificateLevelCode();
		return new RESTResponse("data", JsonMapper.toJsonString(dogs));
	}

	@Transactional(readOnly = false)
	public RESTResponse deleteDuplicateRecordByBirthCertificateLevelCode(String birthCertificateLevelCode,
			HttpServletRequest request) {
		int result = this.dogDao.deleteDuplicateRecordByBirthCertificateLevelCode(birthCertificateLevelCode);
		return new RESTResponse("data", result);
	}

}
