package com.cku.restful.v1.breeder.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.PageResultDto;
import com.cku.core.RESTResponse;
import com.cku.restful.v1.breeder.dto.RestPupDogDto;
import com.cku.restful.v1.breeder.dto.RestQueryDogDto;
import com.cku.restful.v1.breeder.dto.RestStudDogDto;
import com.cku.restful.v1.breeder.service.BreederDogBirthCertificateService;
import com.cku.restful.v1.breeder.service.RestBannerService;
import com.cku.restful.v1.breeder.service.RestCityService;
import com.cku.restful.v1.breeder.service.RestDogBreedService;
import com.cku.restful.v1.breeder.service.RestPupService;
import com.cku.restful.v1.breeder.service.RestStudDogService;
import com.cku.restful.v1.dog.service.RestDogActivationService;
import com.cku.restful.v1.sys.web.BaseRestController;
import com.cku.util.ServletUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@Api(tags = "CKU犬种，幼犬，种公查询API")
@RequestMapping(value = "/api/v1/open/breeder")
public class OpenBreederController extends BaseRestController {

    @Autowired
    private RestBannerService restBannerService;
    @Autowired
    private RestCityService restCityService;
    @Autowired
    private RestDogBreedService restDogBreedService;
    @Autowired
    private RestStudDogService restStudDogService;
    @Autowired
    private RestPupService restPupService;
    @Autowired
    private RestDogActivationService restDogActivationService;
    @Autowired
    private BreederDogBirthCertificateService breederDogBirthCertificateService;

    /**
     * @description: banner
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/banner", method = RequestMethod.GET)
    public void banner(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restBannerService.banner(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 热门犬种
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/hotDogBreed", method = RequestMethod.GET)
    public void hotDogBreed(HttpServletResponse response)
            throws IOException {
        RESTResponse result = restDogBreedService.hotDogBreed();
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 犬种列表
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/dogBreed", method = RequestMethod.GET)
    public void dogBreed(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restDogBreedService.dogBreed(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 热门城市
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/hotCity", method = RequestMethod.GET)
    public void hotCity(HttpServletResponse response)
            throws IOException {
        RESTResponse result = restCityService.hotCity();
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 城市列表
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/city", method = RequestMethod.GET)
    public void city(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restCityService.city(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 种公犬只列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog", method = RequestMethod.GET)
    public void getList(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        RESTResponse result = restStudDogService.getList(request);
        ServletUtils.writeResponse(response, result);
    }

    /**
     * @description: 种公信息详情接口
     * @author: laiguanglong
     * @date: 2017/10/17 10:11
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog/{id}", method = RequestMethod.GET)
    public void getStudDog(@PathVariable("id") String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restStudDogService.get(id, request));
    }

    /**
     * @description: 幼犬信息详情接口
     * @author: laiguanglong
     * @date: 2017/10/17 10:11
     */
    @ApiIgnore
    @RequestMapping(value = "/pup/{id}", method = RequestMethod.GET)
    public void getPup(@PathVariable("id") String id, HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restPupService.get(id, request));
    }

    /**
     * @description: 种公犬只列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog/search", method = RequestMethod.GET)
    public void studDogSearch(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restStudDogService.studDogSearch(request));
    }

    /**
     * @description: 幼犬列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/pup/search", method = RequestMethod.GET)
    public void pupSearch(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restPupService.pupSearch(request));
    }

    /**
     * @description: 犬只激活列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/dogActivation/search", method = RequestMethod.GET)
    public void dogActivationSearch(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restDogActivationService.dogActivationSearch(request));
    }

    /**
     * @description: 犬只激活列表接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/dogActivation/searchByChannel", method = RequestMethod.GET)
    public void searchByChannel(HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restDogActivationService.searchByChannel(request));
    }

    /**
     * @description: 种公搜索标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog/searchLabel", method = RequestMethod.GET)
    public void studDogSearchLabel(HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restStudDogService.studDogSearchLabel());
    }

    /**
     * @description: 种公其他搜索标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog/searchLabelOther", method = RequestMethod.GET)
    public void studDogSearchLabelOther(HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restStudDogService.studDogSearchLabelOther());
    }

    /**
     * @description: 幼犬其他搜索标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/pup/searchLabelOther", method = RequestMethod.GET)
    public void pupSearchLabelOther(HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restPupService.pupSearchLabelOther());
    }

    /**
     * @description: 犬只激活其他搜索标签接口
     * @author: laiguanglong
     * @date: 2017/10/9 15:15
     */
    @ApiIgnore
    @RequestMapping(value = "/dogActivation/searchLabelOther", method = RequestMethod.GET)
    public void dogActivationSearchLabelOther(HttpServletResponse response)
            throws IOException {
        ServletUtils.writeResponse(response, restDogActivationService.dogActivationSearchLabelOther());
    }

    /**
     * @description: 热门种公列表
     * @author: laiguanglong
     * @date: 2018/1/30 16:12
     */
    @ApiIgnore
    @RequestMapping(value = "/studDog/topList", method = RequestMethod.GET)
    public void studDogTopList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restStudDogService.studDogTopList(request));
    }

    /**
     * @description: 热门幼犬列表
     * @author: laiguanglong
     * @date: 2018/1/30 16:12
     */
    @ApiIgnore
    @RequestMapping(value = "/pup/topList", method = RequestMethod.GET)
    public void pupTopList(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletUtils.writeResponse(response, restPupService.pupTopList(request));
    }
    
    
    /**
     * @description: 根据犬舍编号，获取上架犬舍幼犬
     * @author: zhangjunwu
     * @date: 2021/1/20 16:12
     */
    @GetMapping(value = "/kennel/marketPupDogs")
    @ApiOperation("根据犬舍编号，获取犬舍上架幼犬")
    public PageResultDto<RestPupDogDto> kennelMarketPupDogs(RestQueryDogDto queryDto,HttpServletRequest request, HttpServletResponse response) throws IOException {
    	return breederDogBirthCertificateService.findMarketPopDogByKennelCode(queryDto,request);
    }
    
    
    /**
     * @description: 根据犬舍编号，获取犬舍种公
     * @author: zhangjunwu
     * @date: 2021/1/20 16:12
     */
    @GetMapping(value = "/kennel/marketStudDogs")
    @ApiOperation("根据犬舍编号，获取犬舍上架种公")
    public PageResultDto<RestStudDogDto> kennelMarketStudDogs(RestQueryDogDto queryDto,HttpServletRequest request, HttpServletResponse response) throws IOException {
        return restStudDogService.findMarketStudDogByKennelCode(queryDto,request);
    }
}