package com.cku.restful.v1.banner.web;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.cku.core.ListResultDto;
import com.cku.core.ResultDto;
import com.cku.oa.banner.service.AppSplashAdsService;
import com.cku.restful.v1.banner.vo.RestSplashAdsResponse;
import com.cku.restful.v1.sys.web.BaseRestController;

import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/api/v1/open/splashAds")
public class RestAppSplashAdsController extends BaseRestController {


	@Autowired
	private AppSplashAdsService appSplashAdsService;

	@ApiOperation(value = "开屏广告-取1", tags = { "app_splash_ads 开屏广告" })
	@GetMapping(value = "")
	public ResultDto<RestSplashAdsResponse> get(HttpServletRequest request,HttpServletResponse response) throws IOException {
		RestSplashAdsResponse re = appSplashAdsService.getOne();
		if(re != null) {
			return ResultDto.success(re);
		}
		return ResultDto.SUCCESSFUL();
	}
	
	@ApiOperation(value = "开屏广告-取多个", tags = { "app_splash_ads 开屏广告" })
	@GetMapping(value = "/{num}")
	public ListResultDto<RestSplashAdsResponse> getList(@PathVariable String num, HttpServletRequest request,HttpServletResponse response) throws IOException {
		return ListResultDto.success(appSplashAdsService.getList(num));
	}
	

}
