package com.cku.oa.sys.web;

import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.cku.core.RESTResponse;
import com.cku.oa.sys.entity.BaseFile;
import com.cku.oa.sys.service.FileService;
import com.cku.thirdparty.oss.OssApiClient;
import com.cku.thirdparty.oss.OssSignatureResult;
import com.cku.thirdparty.oss.OssUploadResult;
import com.cku.util.JSONUtils;
import com.cku.util.ServletUtils;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.thinkgem.jeesite.common.web.BaseController;

import net.sf.json.JSONObject;

@Controller
@RequestMapping(value = "${adminPath}/sys/file")
public class FileController extends BaseController {
	
	@Autowired
	private FileService fileService;
	
	@Value("${H5wxPayNotifyUrl}")
	private String H5wxPayNotifyUrl;
	
	@Autowired
	private OssApiClient ossApiClient;

	@RequestMapping(value = "upload")
	@ResponseBody
	public void upload(MultipartFile file, @RequestParam(value = "module") String module, @RequestParam(value = "state") String state, HttpServletResponse response)
			throws IOException {
		if(StringUtils.isBlank(state)){
			state = "0";
		}
		BaseFile baseFile = fileService.uploadFile(file, module, state);
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.toString());
	}

	@RequestMapping(value = "uploadJudge")
	@ResponseBody
	public void uploadJudge(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "judgePicture", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}

	/**
	 * 赛事layer 上传图片
	 * 
	 * @Author chaixueteng
	 * @2017年8月7日上午10:01:14
	 */
	@RequestMapping(value = "layupload")
	@ResponseBody
	public void layupload(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "ShowPic", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}

	/**
	 * 富文本编辑器上传
	 * 
	 * @Author chaixueteng
	 * @2017年8月7日上午10:01:37
	 */
	@RequestMapping(value = "editorUpload")
	@ResponseBody
	public void editorUpload(@RequestParam MultipartFile editorImg, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		String module = request.getParameter("module");
		if(StringUtils.isBlank(module)){
			module = "ShowPic";
		}
		BaseFile baseFile = fileService.uploadFile(editorImg, module, "1");
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.getString("url"));
	}

	@RequestMapping(value = "editorUploadJson")
	@ResponseBody
	public JSONObject editorUploadNew(@RequestParam MultipartFile editorImg, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		String module = request.getParameter("module");
		if(StringUtils.isBlank(module)){
			module = "ShowPic";
		}
		BaseFile baseFile = fileService.uploadFile(editorImg, module, "1");
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		return fileObject;
	}
	
	/**
	 * 原生犬管理上传
	 * 
	 * @Author chaixueteng
	 * @2017年8月7日上午10:01:37
	 */
	@RequestMapping(value = "nativeDogUpload")
	@ResponseBody
	public void nativeDogUpload(@RequestParam MultipartFile editorImg, HttpServletRequest request,
			HttpServletResponse response) throws IOException {
		BaseFile baseFile = fileService.uploadFile(editorImg, "NativeDogPic", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.getString("url"));
	}

	@RequestMapping(value = "image/{id}")
	@ResponseBody
	public void image(@PathVariable String id, HttpServletResponse response) throws IOException {
		response.setContentType("application/octet-stream");
		fileService.fileDownload(id,response.getOutputStream());
	}

	@RequestMapping(value = "/vod/{id}", method = RequestMethod.GET)
	@ResponseBody
	public void vod(@PathVariable String id, HttpServletResponse response) throws IOException {
		BaseFile file = fileService.get(id);
		if (file != null && !"1".equals(file.getOpenFlag())) {
			ServletUtils.writeResponse(response, new RESTResponse("1", "视频序号有误"));
			return;
		}
		response.setContentType("audio/mp4");
		fileService.fileDownload(file,response.getOutputStream());
	}

	/**
	 * 赛事layer 上传图片
	 * 
	 * @Author chaixueteng
	 * @2017年8月7日上午10:01:14
	 */
	@RequestMapping(value = "showReport/{child}")
	@ResponseBody
	public void showReport(@PathVariable String child, @RequestParam MultipartFile file, HttpServletRequest request,
			HttpServletResponse response) throws IOException {

		String dir = "showReport";
		if (StringUtils.isNotBlank(child)) {
			dir = dir + File.separator + child;
		}
		BaseFile baseFile = fileService.uploadFile(file, dir, "1");
		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());

	}
	
	@RequestMapping(value="uploadUpyun")
	@ResponseBody
    public void uploadUpyun(MultipartFile file,HttpServletResponse response) throws IOException {
		// 上传服务器
		OssUploadResult result = ossApiClient.upload(file,"upyun");
		JSONObject fileObject = new JSONObject();
		fileObject.put("url",result.getUploadUrl());
		fileObject.put("fileName",result.getOriginalName());
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.toString());
    }
	
	@RequestMapping(value="signature")
	@ResponseBody
    public void signature(@RequestParam(value = "module") String module,@RequestParam(value = "fileName") String fileName,HttpServletRequest request, HttpServletResponse response) throws IOException {
		// 上传服务器
		OssSignatureResult result = ossApiClient.getSignature(module,fileName);
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(JSONUtils.toJSON(result));
    }
	
	
	
	@RequestMapping(value="uploadOSS")
	@ResponseBody
    public void uploadOSS(@RequestParam( "requestMapping") String requestMapping,@RequestParam( "file")MultipartFile file,HttpServletResponse response) throws IOException {
		// 上传服务器
		OssUploadResult result = ossApiClient.upload(file,requestMapping);
		JSONObject fileObject = new JSONObject();
		fileObject.put("url",result.getUploadUrl());
		fileObject.put("fileName",result.getOriginalName());
		response.setContentType("application/json;charset=UTF-8");
		response.getWriter().write(fileObject.toString());
    }

	@RequestMapping(value = "uploadGroomerRefereePicture")
	@ResponseBody
	public void uploadGroomerRefereePicture(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "groomerRefereePicture", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}

	@RequestMapping(value = "uploadGroomerRefereeSignaturePhoto")
	@ResponseBody
	public void uploadGroomerRefereeSignaturePhoto(@RequestParam MultipartFile file, HttpServletRequest request, HttpServletResponse response)
			throws IOException {
		BaseFile baseFile = fileService.uploadFile(file, "groomerRefereeSignaturePhoto", "1");

		JSONObject fileObject = new JSONObject();
		fileObject.put("id", baseFile.getId());
		fileObject.put("fileName", baseFile.getName());
		fileObject.put("realName", baseFile.getOrginalname());
		String imgPath = H5wxPayNotifyUrl + "api/v1/open/image/" + baseFile.getId();
		fileObject.put("url", imgPath);
		response.setContentType("text/html;charset=UTF-8");// ie 浏览器使用layui 需设置头为html
		response.getWriter().write(fileObject.toString());
	}
}
