package com.cku.oa.sys.service.user;

import com.cku.oa.sys.dao.user.MemberLimitCountDao;
import com.cku.oa.sys.entity.user.MemberLimitCount;
import com.thinkgem.jeesite.common.service.CrudService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 会员限制数量表
 * @author yuanshuai
 * @version 2017-12-21 17:35:47
 */
@Service
@Transactional(readOnly = true)
public class MemberLimitCountService extends CrudService<MemberLimitCountDao, MemberLimitCount> {

	/**
	 * @Description： 保存
	 * @author: yuanshuai
	 * @date: 2017/12/21 17:47
	 */
	@Transactional(readOnly = false)
	public void save(MemberLimitCount memberLimitCount){
		super.save(memberLimitCount);
	}

	/**
	 * @Description： 根据会员号查询
	 * @author: yuanshuai
	 * @date: 2017/12/21 17:42
	 */
	public MemberLimitCount findByMemberCode(String memberCode) {
		return dao.findByMemberCode(memberCode);
	}

}