/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.entity;

import org.hibernate.validator.constraints.Length;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.thinkgem.jeesite.modules.sys.entity.User;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 业务提醒功能Entity
 * @author fanhuibin
 * @version 2016-08-11
 */
public class Remind extends DataEntity<Remind> {
	
	private static final long serialVersionUID = 1L;
	private String content;		// 主题
	private Date readDate;		// 消息阅读的时间
	private String readFlag;		// read_flag
	private String type;		// 预留字段，暂时没有使用
	private User user;		// 消息对应的用户id
	public Remind() {
		super();
	}

	public Remind(String id){
		super(id);
	}

	@Length(min=0, max=300, message="主题长度必须介于 0 和 300 之间")
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getReadDate() {
		return readDate;
	}

	public void setReadDate(Date readDate) {
		this.readDate = readDate;
	}
	
	@Length(min=0, max=1, message="read_flag长度必须介于 0 和 1 之间")
	public String getReadFlag() {
		return readFlag;
	}

	public void setReadFlag(String readFlag) {
		this.readFlag = readFlag;
	}
	
	@Length(min=0, max=64, message="预留字段，暂时没有使用长度必须介于 0 和 64 之间")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}
	
}