/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.sys.dao;

import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.sys.entity.TaskTrigger;
import com.mysql.fabric.xmlrpc.base.Data;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 计划任务管理DAO接口
 * @author zhuoHeng
 * @version 2017-03-29
 */
@MyBatisDao
public interface TaskTriggerDao extends CrudDao<TaskTrigger> {

	/**
	 * 
	 * @Description：更改计划任务运行状态
	 * @author: zhuoHeng
	 * @version: 2017年3月29日 上午11:02:55
	 */
	int changeState(TaskTrigger sysTask);

	/**
	 * 
	 * @Description：查询数据库中所有有效数据
	 * @author: zhuoHeng
	 * @version: 2017年4月5日 下午4:30:38
	 */
	List<TaskTrigger> findAll();

	/**
	 * 
	 * @Description：计划任务执行完成后更新执行时间
	 * @author: zhuoHeng
	 * @version: 2017年4月10日 下午2:05:28
	 */
	void renewExecuteTime(@Param("jobName") String jobName,@Param("date") Date date);
	
	/**
	 * 
	 * @Description：更改执行状态（执行中、未执行）
	 * @author: zhuoHeng
	 * @version: 2017年4月13日 下午3:21:28
	 * @return 
	 */
	int renewExecuteState(@Param("executeState") String executeState,@Param("jobName") String jobName);
	
	/**
	 * 
	 * @Description：根据jobName查询执行状态
	 * @author: zhuoHeng
	 * @version: 2017年4月13日 下午3:21:56
	 */
	TaskTrigger getExecuteState(@Param("jobName") String jobName);
	
}