package com.cku.oa.nativedog.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.thinkgem.jeesite.common.config.Global;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.web.BaseController;
import com.thinkgem.jeesite.common.utils.StringUtils;
import com.cku.oa.nativedog.entity.NativeDogNews;
import com.cku.oa.nativedog.service.NativeDogNewsService;

/**
 * 原生犬新闻Controller
 * @author lyy
 * @version 2018-12-11
 */
@Controller
@RequestMapping(value = "${adminPath}/nativedog/nativeDogNews")
public class NativeDogNewsController extends BaseController {

	@Autowired
	private NativeDogNewsService nativeDogNewsService;
	
	@ModelAttribute
	public NativeDogNews get(@RequestParam(required=false) String id) {
		NativeDogNews entity = null;
		if (StringUtils.isNotBlank(id)){
			entity = nativeDogNewsService.get(id);
		}
		if (entity == null){
			entity = new NativeDogNews();
		}
		return entity;
	}
	
	@RequiresPermissions("nativedog:nativeDogNews:view")
	@RequestMapping(value = {"list", ""})
	public String list(NativeDogNews nativeDogNews, HttpServletRequest request, HttpServletResponse response, Model model) {
		Page<NativeDogNews> page = nativeDogNewsService.findPage(new Page<NativeDogNews>(request, response), nativeDogNews); 
		model.addAttribute("page", page);
		return "oa/nativedog/nativeDogNewsList";
	}

	@RequiresPermissions("nativedog:nativeDogNews:view")
	@RequestMapping(value = "form")
	public String form(NativeDogNews nativeDogNews, Model model) {
		model.addAttribute("nativeDogNews", nativeDogNews);
		return "oa/nativedog/nativeDogNewsForm";
	}

	@RequiresPermissions("nativedog:nativeDogNews:edit")
	@RequestMapping(value = "save")
	public String save(NativeDogNews nativeDogNews, Model model, RedirectAttributes redirectAttributes) {
		if (!beanValidator(model, nativeDogNews)){
			return form(nativeDogNews, model);
		}
		nativeDogNewsService.save(nativeDogNews);
		addMessage(redirectAttributes, "保存原生犬新闻成功");
		return "redirect:"+Global.getAdminPath()+"/nativedog/nativeDogNews/?repage";
	}
	
	@RequiresPermissions("nativedog:nativeDogNews:edit")
	@RequestMapping(value = "delete")
	public String delete(NativeDogNews nativeDogNews, RedirectAttributes redirectAttributes) {
		nativeDogNewsService.delete(nativeDogNews);
		addMessage(redirectAttributes, "删除原生犬新闻成功");
		return "redirect:"+Global.getAdminPath()+"/nativedog/nativeDogNews/?repage";
	}

}