package com.cku.oa.goods.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import com.cku.core.ZAErrorCode;
import com.cku.core.ZAException;
import com.cku.oa.goods.dao.SysBusinessServiceDao;
import com.cku.oa.goods.entity.Sku;
import com.cku.oa.goods.entity.SysBusinessService;
import com.thinkgem.jeesite.common.persistence.Page;
import com.thinkgem.jeesite.common.service.CrudService;
import com.thinkgem.jeesite.common.utils.StringUtils;

/**
 * 业务注册Service
 * @author yuanshuai
 * @version 2023-06-16
 */
@Service
@Transactional(readOnly = true)
public class SysBusinessServiceService extends CrudService<SysBusinessServiceDao, SysBusinessService> {

	@Autowired
	private SkuService skuService;

	public SysBusinessService get(String id) {
		return super.get(id);
	}
	
	public List<SysBusinessService> findList(SysBusinessService sysBusinessService) {
		return super.findList(sysBusinessService);
	}
	
	public Page<SysBusinessService> findPage(Page<SysBusinessService> page, SysBusinessService sysBusinessService) {
		return super.findPage(page, sysBusinessService);
	}

	/**
	 * 根据业务分类ID查找list
	 * @author yuanshuai
	 * @date 2023/7/28 16:14
	 */
	public List<SysBusinessService> findListByCate(String catId) {
		if (StringUtils.isBlank(catId)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "业务分类ID为空");
		}
		return dao.findListByCate(catId);
	}

	/**
	 * 查找全部业务服务
	 * @author yuanshuai
	 * @date 2023/7/28 17:49
	 */
	public List<SysBusinessService> findAllList() {
		return dao.findAllList(new SysBusinessService());
	}

	@Transactional(readOnly = false)
	public void save(SysBusinessService sysBusinessService) {
		super.save(sysBusinessService);
	}
	
	@Transactional(readOnly = false)
	public void delete(SysBusinessService sysBusinessService) {
		//已使用不可删除
		List<Sku> skuList = skuService.findListByBusiness(sysBusinessService.getId());
		if (!CollectionUtils.isEmpty(skuList)) {
			throw new ZAException(ZAErrorCode.ZA_VALID_FAILED, "已有商品使用此分类");
		}
		super.delete(sysBusinessService);
	}

}