/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.goods.entity;

import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 商品Entity
 *
 * @author yuanshuai
 * @version 2023-06-16
 */
public class Sku extends DataEntity<Sku> {

    private static final long serialVersionUID = 1L;
    private String businessId;        // 归属业务id
    private String name;        // sku名称
    private Double price;        // 金额
    private Integer saleFlag;        // 销售标记 0下架,1上架
    private Integer refundFlag;        // 退款标记 0不支持,1支持
    // 服务类名
    private String serviceName;
    // 排序（处理顺序）
    private Integer sort;

	//显示查询用
	// 归属业务名称
	private String businessName;
	//收费项ID
	private String itemIds;

    public Sku() {
        super();
    }

    public Sku(String id) {
        super(id);
    }

    @Length(min = 1, max = 32, message = "归属业务id长度必须介于 1 和 32 之间")
    public String getBusinessId() {
        return businessId;
    }

    public void setBusinessId(String businessId) {
        this.businessId = businessId;
    }

    @Length(min = 1, max = 32, message = "sku名称长度必须介于 1 和 32 之间")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @NotNull(message = "金额不能为空")
    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Integer getSaleFlag() {
        return saleFlag;
    }

    public void setSaleFlag(Integer saleFlag) {
        this.saleFlag = saleFlag;
    }

    public Integer getRefundFlag() {
        return refundFlag;
    }

    public void setRefundFlag(Integer refundFlag) {
        this.refundFlag = refundFlag;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	public String getItemIds() {
		return itemIds;
	}

	public void setItemIds(String itemIds) {
		this.itemIds = itemIds;
	}
}