package com.cku.oa.gcWeb.entity;

import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

import com.thinkgem.jeesite.common.persistence.DataEntity;

/**
 * 美容官网信息Entity
 * @author yuanshuai
 * @version 2023-01-30
 */
public class GCWebInfo extends DataEntity<GCWebInfo> {
	
	private static final long serialVersionUID = 1L;
	private Integer type;		// 类型(1:关于2:讲座3:新闻4:合作机构5:友情链接10:联系我们)
	private Integer subType;		// 子类型（2::1美容讲座2:CKU专业培训,4::1:正式2:预备）
	private String title;		// 标题
	private String image;		// 图片
	private String url;		// 链接
	private String content;		// 内容
	private Integer showFlag;		// 显示标记（0不显示1显示）
	private Integer sort;		// 排序
	
	public GCWebInfo() {
		super();
	}

	public GCWebInfo(String id){
		super(id);
	}

	@NotNull(message="类型(1:关于2:讲座3:新闻4:合作机构5:友情链接10:联系我们)不能为空")
	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}
	
	public Integer getSubType() {
		return subType;
	}

	public void setSubType(Integer subType) {
		this.subType = subType;
	}
	
	@Length(min=1, max=64, message="标题长度必须介于 1 和 64 之间")
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	@Length(min=0, max=255, message="图片长度必须介于 0 和 255 之间")
	public String getImage() {
		return image;
	}

	public void setImage(String image) {
		this.image = image;
	}
	
	@Length(min=0, max=32, message="链接长度必须介于 0 和 32 之间")
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}
	
	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}
	
	@NotNull(message="显示标记（0不显示1显示）不能为空")
	public Integer getShowFlag() {
		return showFlag;
	}

	public void setShowFlag(Integer showFlag) {
		this.showFlag = showFlag;
	}
	
	public Integer getSort() {
		return sort;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}
	
}