/**
 * Copyright &copy; 2012-2014 <a href="https://github.com/thinkgem/jeesite">JeeSite</a> All rights reserved.
 */
package com.cku.oa.finance.dao;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.cku.oa.finance.entity.PaymentCart;
import com.cku.oa.finance.vo.PaymentCartVO;
import com.thinkgem.jeesite.common.persistence.CrudDao;
import com.thinkgem.jeesite.common.persistence.annotation.MyBatisDao;

/**
 * 购物车DAO接口
 * 
 * @author fanhuibin
 * @version 2016-09-20
 */
@MyBatisDao
public interface PaymentCartDao extends CrudDao<PaymentCart> {

	public void deleteByBusinessId(PaymentCart cart);

	public void deleteCartItem(@Param("tableName") String tableName, @Param("id") String id); // 物理删除业务表数据

	/**
	 * @description: 根据会员号和业务号查询购物车
	 * @author: laiguanglong
	 * @date: 2016/11/29 9:27
	 */
	public List<PaymentCart> getByBusinessOrderCode(PaymentCart cart);

	/**
	 * @description: 根据会员号和业务号删除购物车
	 * @author: laiguanglong
	 * @date: 2016/11/29 9:27
	 */
	public void deleteByBusinessOrderCode(PaymentCart cart);

	public void deleteDogBirthCertificate(@Param("fmdogBreedCertifiedCode") String fmdogBreedCertifiedCode);

	/**
	 * 
	 * @description: 根据表名和表id查询记录
	 * @author: laiguanglong
	 * @date: 2016年11月11日 下午5:55:53
	 */
	public PaymentCart getByTableAndId(@Param("businessTable") String businessTable,
			@Param("businessIds") String businessIds);

	/**
	 *
	 * @description: 根据表名和对象id查询记录 清空使用标记位
	 * @author: chaixueteng
	 * @date: 2018年04月18日 下午5:55:53
	 */
	void clearCouponItem(@Param("businessTable") String tableName, @Param("businessIds") String businessIds);

	void clearCouponShowItem(@Param("businessTable") String tableName, @Param("businessIds") String businessIds,
			@Param("pedigreeCertified") String pedigreeCertified);

	List<PaymentCartVO> findListByIds(@Param("ids") List<String> ids, @Param("memberCode") String memberCode);
	
	List<PaymentCart> findListByBusinessId(@Param("businessId")  String businessId, @Param("memberCode") String memberCode);
}